/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.CatalinaPropertiesUtil;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.wst.IModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Loader;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class TomcatPublishModuleVisitor
implements IModuleVisitor {
    protected final IPath baseDir;
    protected final ServerInstance serverInstance;
    protected final String sharedLoader;
    protected final boolean enableMetaInfResources;
    protected final List earCommonResources = new ArrayList();
    protected Set virtualClassClasspathElements = new LinkedHashSet();
    protected Set virtualJarClasspathElements = new LinkedHashSet();
    protected Map virtualDependentResources = new LinkedHashMap();

    TomcatPublishModuleVisitor(IPath catalinaBase, ServerInstance serverInstance, String sharedLoader, boolean enableMetaInfResources) {
        this.baseDir = catalinaBase;
        this.serverInstance = serverInstance;
        this.sharedLoader = sharedLoader;
        this.enableMetaInfResources = enableMetaInfResources;
    }

    public void visitWebComponent(IVirtualComponent component) throws CoreException {
    }

    public void visitArchiveComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualJarResource(runtimePath, workspacePath);
    }

    public void visitDependentComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualJarResource(runtimePath, workspacePath);
    }

    public void visitWebResource(IPath runtimePath, IPath workspacePath) {
        this.addVirtualClassResource(runtimePath, workspacePath);
    }

    public void visitDependentContentResource(IPath runtimePath, IPath workspacePath) {
        if (this.enableMetaInfResources) {
            this.addContentResource(runtimePath, workspacePath);
        }
    }

    public void visitEarResource(IPath runtimePath, IPath workspacePath) {
        this.earCommonResources.add(workspacePath.toOSString());
    }

    public void endVisitEarComponent(IVirtualComponent component) throws CoreException {
        if (this.earCommonResources.size() > 0) {
            try {
                try {
                    CatalinaPropertiesUtil.addGlobalClasspath(this.baseDir.append("conf/catalina.properties").toFile(), this.sharedLoader, this.earCommonResources.toArray(new String[this.earCommonResources.size()]));
                }
                catch (IOException e) {
                    Trace.trace((byte)1, "Unable to add ear path entries to catalina.properties", e);
                    this.earCommonResources.clear();
                }
            }
            finally {
                this.earCommonResources.clear();
            }
        }
    }

    public void endVisitWebComponent(IVirtualComponent component) throws CoreException {
        String oldResPaths;
        String resPaths;
        String string;
        String vcp;
        String path;
        String docBase;
        Context projectContext;
        boolean dirty = false;
        IModule module = ServerUtil.getModule((IProject)component.getProject());
        Context context = this.findContext(module);
        if (context == null) {
            String name = module != null ? module.getName() : component.getName();
            Trace.trace((byte)2, "Could not find context for module " + name);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishContextNotFound, (Object)name), null));
        }
        String contextName = null;
        boolean reloadable = true;
        contextName = context.getPath();
        reloadable = Boolean.valueOf(context.getReloadable());
        if (contextName.startsWith("/")) {
            contextName = contextName.substring(1);
        }
        if ("".equals(contextName)) {
            contextName = "ROOT";
        }
        if ((projectContext = this.getProjectContextXml(component)) != null) {
            projectContext.copyChildrenTo(context);
            Map attrs = projectContext.getAttributes();
            for (String name : attrs.keySet()) {
                String actualValue;
                String value;
                if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("docBase") || name.equalsIgnoreCase("source") || (value = (String)attrs.get(name)).equals(actualValue = context.getAttributeValue(name))) continue;
                context.setAttributeValue(name, value);
                dirty = true;
            }
        }
        if (!(docBase = component.getRootFolder().getUnderlyingFolder().getLocation().toOSString()).equals(context.getDocBase())) {
            dirty = true;
            context.setDocBase(docBase);
        }
        if (reloadable != Boolean.valueOf(context.getReloadable())) {
            dirty = true;
            context.setReloadable(Boolean.toString(reloadable));
        }
        String string2 = path = contextName.equals("ROOT") ? "" : "/" + contextName;
        if (!path.equals(context.getPath())) {
            dirty = true;
            context.setPath(path);
        }
        context.getResources().setClassName("org.eclipse.jst.server.tomcat.loader.WtpDirContext");
        Loader loader = context.getLoader();
        loader.setClassName("org.eclipse.jst.server.tomcat.loader.WtpWebappLoader");
        loader.setUseSystemClassLoaderAsParent(Boolean.FALSE.toString());
        StringBuffer vcBuffer = new StringBuffer();
        StringBuffer rpBuffer = new StringBuffer();
        for (Object element : this.virtualClassClasspathElements) {
            if (vcBuffer.length() > 0) {
                vcBuffer.append(";");
                rpBuffer.append(";");
            }
            vcBuffer.append(element);
            rpBuffer.append("/WEB-INF/classes").append("|").append(element);
        }
        if (vcBuffer.length() > 0 && this.virtualJarClasspathElements.size() > 0) {
            vcBuffer.append(";");
        }
        Iterator iterator = this.virtualJarClasspathElements.iterator();
        while (iterator.hasNext()) {
            vcBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            vcBuffer.append(";");
        }
        this.virtualClassClasspathElements.clear();
        this.virtualJarClasspathElements.clear();
        HashSet<String> rtPathsProcessed = new HashSet<String>();
        HashSet<String> locationsIncluded = new HashSet<String>();
        locationsIncluded.add(docBase);
        HashMap<String, String> retryLocations = new HashMap<String, String>();
        IVirtualResource[] virtualResources = component.getRootFolder().getResources("");
        int i = 0;
        while (i < virtualResources.length) {
            String string3 = virtualResources[i].getRuntimePath().toString();
            if (!rtPathsProcessed.contains(string3)) {
                if (!"/WEB-INF/classes".equals(string3)) {
                    IResource[] underlyingResources = virtualResources[i].getUnderlyingResources();
                    if ("/".equals(string3)) {
                        int j = 0;
                        while (j < underlyingResources.length) {
                            IPath resLoc = underlyingResources[j].getLocation();
                            String location = resLoc.toOSString();
                            if (!location.equals(docBase)) {
                                if (rpBuffer.length() != 0) {
                                    rpBuffer.append(";");
                                }
                                rpBuffer.append(location);
                                locationsIncluded.add(location);
                                File webInfLib = resLoc.append("WEB-INF/lib").toFile();
                                if (webInfLib.exists() && webInfLib.isDirectory()) {
                                    String[] jars = webInfLib.list(new FilenameFilter(){

                                        public boolean accept(File dir, String name) {
                                            File f = new File(dir, name);
                                            return f.isFile() && name.endsWith(".jar");
                                        }
                                    });
                                    int k = 0;
                                    while (k < jars.length) {
                                        if (vcBuffer.length() != 0) {
                                            vcBuffer.append(";");
                                        }
                                        vcBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                    } else {
                        int idx = string3.lastIndexOf(47);
                        if (idx >= 0) {
                            String lastSegment = string3.substring(idx + 1);
                            int j = 0;
                            while (j < underlyingResources.length) {
                                IPath resLoc = underlyingResources[j].getLocation();
                                String location = resLoc.toOSString();
                                if (!lastSegment.equals(resLoc.lastSegment())) {
                                    if (rpBuffer.length() != 0) {
                                        rpBuffer.append(";");
                                    }
                                    rpBuffer.append(string3).append("|").append(location);
                                    locationsIncluded.add(location);
                                    File webInfLib = null;
                                    if ("/WEB-INF".equals(string3)) {
                                        webInfLib = resLoc.append("lib").toFile();
                                    } else if ("/WEB-INF/lib".equals(string3)) {
                                        webInfLib = resLoc.toFile();
                                    }
                                    if (webInfLib != null && webInfLib.exists() && webInfLib.isDirectory()) {
                                        String[] jars = webInfLib.list(new FilenameFilter(){

                                            public boolean accept(File dir, String name) {
                                                File f = new File(dir, name);
                                                return f.isFile() && name.endsWith(".jar");
                                            }
                                        });
                                        int k = 0;
                                        while (k < jars.length) {
                                            if (vcBuffer.length() != 0) {
                                                vcBuffer.append(";");
                                            }
                                            vcBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                                            ++k;
                                        }
                                    }
                                } else {
                                    retryLocations.put(location, string3);
                                }
                                ++j;
                            }
                        }
                    }
                }
                rtPathsProcessed.add(string3);
            }
            ++i;
        }
        if (!retryLocations.isEmpty()) {
            Iterator iterator2 = retryLocations.keySet().iterator();
            block8: while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                for (String includedLocation : locationsIncluded) {
                    if (!string4.equals(includedLocation) && !string4.startsWith(String.valueOf(includedLocation) + File.separator)) continue;
                    iterator2.remove();
                    continue block8;
                }
            }
            if (!retryLocations.isEmpty()) {
                for (Map.Entry entry : retryLocations.entrySet()) {
                    String location = (String)entry.getKey();
                    String rtPath = (String)entry.getValue();
                    if (rpBuffer.length() != 0) {
                        rpBuffer.append(";");
                    }
                    rpBuffer.append(rtPath).append("|").append(location);
                    File webInfLib = null;
                    if ("/WEB-INF".equals(rtPath)) {
                        webInfLib = new File(location, "lib");
                    } else if ("/WEB-INF/lib".equals(rtPath)) {
                        webInfLib = new File(location);
                    }
                    if (webInfLib == null || !webInfLib.exists() || !webInfLib.isDirectory()) continue;
                    String[] jars = webInfLib.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            File f = new File(dir, name);
                            return f.isFile() && name.endsWith(".jar");
                        }
                    });
                    int k = 0;
                    while (k < jars.length) {
                        if (vcBuffer.length() != 0) {
                            vcBuffer.append(";");
                        }
                        vcBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                        ++k;
                    }
                }
            }
        }
        if (!this.virtualDependentResources.isEmpty()) {
            for (Map.Entry entry : this.virtualDependentResources.entrySet()) {
                String rtPath = (String)entry.getKey();
                List locations = (List)entry.getValue();
                for (String location : locations) {
                    if (rpBuffer.length() != 0) {
                        rpBuffer.append(";");
                    }
                    if (rtPath.length() > 0) {
                        rpBuffer.append(entry.getKey()).append("|").append(location);
                        continue;
                    }
                    rpBuffer.append(location);
                }
            }
        }
        if (!(vcp = vcBuffer.toString()).equals(string = loader.getVirtualClasspath())) {
            dirty = true;
            loader.setVirtualClasspath(vcp);
            context.getResources().setVirtualClasspath(vcp);
        }
        if (!(resPaths = rpBuffer.toString()).equals(oldResPaths = context.getResources().getExtraResourcePaths())) {
            dirty = true;
            context.getResources().setExtraResourcePaths(resPaths);
        }
        if (this.enableMetaInfResources) {
            context.findElement("JarScanner").setAttributeValue("scanAllDirectories", "true");
        }
    }

    private void addVirtualClassResource(IPath runtimePath, IPath workspacePath) {
        this.virtualClassClasspathElements.add(workspacePath.toOSString());
    }

    private void addVirtualJarResource(IPath runtimePath, IPath workspacePath) {
        this.virtualJarClasspathElements.add(workspacePath.toOSString());
    }

    private void addContentResource(IPath runtimePath, IPath workspacePath) {
        String rtPath = runtimePath.toString();
        ArrayList<String> locations = (ArrayList<String>)this.virtualDependentResources.get(rtPath);
        if (locations == null) {
            locations = new ArrayList<String>();
            this.virtualDependentResources.put(rtPath, locations);
        }
        locations.add(workspacePath.toOSString());
    }

    protected Context getProjectContextXml(IVirtualComponent component) throws CoreException {
        Context contextElement;
        block12: {
            IVirtualFile contextFile = (IVirtualFile)component.getRootFolder().findMember("META-INF/context.xml");
            contextElement = null;
            if (contextFile != null && contextFile.exists()) {
                Factory factory = new Factory();
                factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                InputStream fis = null;
                try {
                    try {
                        fis = contextFile.getUnderlyingFile().getContents();
                        contextElement = (Context)factory.loadDocument(fis);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, "Exception reading " + contextFile, e);
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contextElement;
    }

    protected Context findContext(IModule module) {
        if (module == null) {
            return null;
        }
        String source = module.getId();
        Context[] contexts = this.serverInstance.getContexts();
        int i = 0;
        while (i < contexts.length) {
            if (source.equals(contexts[i].getSource())) {
                return contexts[i];
            }
            ++i;
        }
        return null;
    }
}

