/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewCategoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskContainerComparator;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveToCategoryMenuContributor
implements IDynamicSubMenuContributor {
    @Override
    public MenuManager getSubMenuManager(final List<IRepositoryElement> selectedElements) {
        MenuManager subMenuManager = new MenuManager(Messages.MoveToCategoryMenuContributor_Move_to);
        ArrayList<AbstractTask> selectedTasks = new ArrayList<AbstractTask>(selectedElements.size());
        for (IRepositoryElement element : selectedElements) {
            if (!(element instanceof ITask)) continue;
            selectedTasks.add((AbstractTask)element);
        }
        subMenuManager.setVisible(!selectedTasks.isEmpty());
        ArrayList categories = new ArrayList(TasksUiInternal.getTaskList().getCategories());
        Collections.sort(categories, new TaskContainerComparator());
        for (final AbstractTaskCategory category : categories) {
            if (category instanceof UnmatchedTaskContainer) continue;
            String text = this.handleAcceleratorKeys(category.getSummary());
            Action action = new Action(text, 8){

                public void run() {
                    MoveToCategoryMenuContributor.this.moveToCategory(selectedElements, category);
                }
            };
            action.setImageDescriptor(TasksUiImages.CATEGORY);
            if (selectedTasks.size() == 1 && category.contains(((AbstractTask)selectedTasks.get(0)).getHandleIdentifier())) {
                action.setChecked(true);
            }
            subMenuManager.add((IAction)action);
        }
        NewCategoryAction action = new NewCategoryAction(){

            public void run() {
                TaskCategory category = this.createCategory();
                if (category != null) {
                    MoveToCategoryMenuContributor.this.moveToCategory(selectedElements, (AbstractTaskCategory)category);
                }
            }
        };
        subMenuManager.add((IContributionItem)new Separator());
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }

    public String handleAcceleratorKeys(String text) {
        if (text == null) {
            return null;
        }
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.concat("@");
        }
        return text;
    }

    private void moveToCategory(List<IRepositoryElement> selectedElements, AbstractTaskCategory category) {
        for (IRepositoryElement element : selectedElements) {
            if (!(element instanceof ITask)) continue;
            TasksUiInternal.getTaskList().addTask((ITask)((AbstractTask)element), (AbstractTaskContainer)category);
        }
    }
}

