/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.core.subsystem.impl;

import java.util.Vector;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;

public class RemoteProcessContext
implements IRemoteProcessContext {
    protected IRemoteProcessSubSystem subsystem;
    protected IRemoteProcess parentProcess;
    protected IHostProcessFilter filterString;
    protected Vector allFilterStrings;

    public RemoteProcessContext(IRemoteProcessSubSystem subsystem, IRemoteProcess parentProcessObject, IHostProcessFilter filterString) {
        this.subsystem = subsystem;
        this.parentProcess = parentProcessObject;
        this.filterString = filterString;
    }

    public RemoteProcessContext() {
    }

    public void setParentRemoteProcessSubSystem(IRemoteProcessSubSystem subsystem) {
        this.subsystem = subsystem;
    }

    public void setParentRemoteProcess(IRemoteProcess parentProcessObject) {
        this.parentProcess = parentProcessObject;
    }

    public void setFilterString(IHostProcessFilter filterString) {
        this.filterString = filterString;
        this.allFilterStrings = null;
    }

    public void addFilterString(IHostProcessFilter additionalFilterString) {
        if (this.allFilterStrings == null) {
            this.allFilterStrings = new Vector();
            if (this.filterString != null) {
                this.allFilterStrings.addElement(this.filterString);
            }
        }
        boolean match = false;
        String newfs = additionalFilterString.toString();
        int idx = 0;
        while (!match && idx < this.allFilterStrings.size()) {
            IHostProcessFilter prevfs = (IHostProcessFilter)this.allFilterStrings.elementAt(idx);
            if (newfs.equals(prevfs.toString())) {
                match = true;
            }
            ++idx;
        }
        if (!match) {
            this.allFilterStrings.addElement(additionalFilterString);
        }
    }

    public IRemoteProcessSubSystem getParentRemoteProcessSubSystem() {
        return this.subsystem;
    }

    public IRemoteProcess getParentRemoteProcess() {
        return this.parentProcess;
    }

    public IHostProcessFilter getFilterString() {
        return this.filterString;
    }

    public IHostProcessFilter[] getAllFilterStrings() {
        if (this.allFilterStrings == null) {
            return new IHostProcessFilter[]{this.filterString};
        }
        IHostProcessFilter[] all = new IHostProcessFilter[this.allFilterStrings.size()];
        int idx = 0;
        while (idx < all.length) {
            all[idx] = (IHostProcessFilter)this.allFilterStrings.elementAt(idx);
            ++idx;
        }
        return all;
    }
}

