/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.TypePromoter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTypePromoter
extends TypePromoter {
    @Override
    protected boolean checkCombination(Class<? extends AnyAtomicType> newType) {
        if (newType == XSDouble.class || this.getTargetType() == XSDouble.class) {
            this.setTargetType(XSDouble.class);
        } else if (newType == XSFloat.class || this.getTargetType() == XSFloat.class) {
            this.setTargetType(XSFloat.class);
        } else if (newType == XSInteger.class && this.getTargetType() == XSInteger.class) {
            this.setTargetType(XSInteger.class);
        } else {
            this.setTargetType(XSDecimal.class);
        }
        return true;
    }

    @Override
    public AnyAtomicType doPromote(AnyAtomicType value) throws DynamicError {
        if (this.getTargetType() == XSFloat.class) {
            return new XSFloat(value.string_value());
        }
        if (this.getTargetType() == XSDouble.class) {
            return new XSDouble(value.string_value());
        }
        if (this.getTargetType() == XSInteger.class) {
            return new XSInteger(value.string_value());
        }
        if (this.getTargetType() == XSDecimal.class) {
            return new XSDecimal(value.string_value());
        }
        return null;
    }

    @Override
    protected Class<? extends AnyAtomicType> substitute(Class<? extends AnyAtomicType> typeToConsider) {
        if (typeToConsider == XSUntypedAtomic.class) {
            return XSDouble.class;
        }
        if (this.isDerivedFrom(typeToConsider, XSFloat.class)) {
            return XSFloat.class;
        }
        if (this.isDerivedFrom(typeToConsider, XSDouble.class)) {
            return XSDouble.class;
        }
        if (this.isDerivedFrom(typeToConsider, XSInteger.class)) {
            return XSInteger.class;
        }
        if (this.isDerivedFrom(typeToConsider, XSDecimal.class)) {
            return XSDecimal.class;
        }
        return null;
    }

    private boolean isDerivedFrom(Class<? extends AnyType> typeToConsider, Class<? extends AnyType> superType) {
        return superType.isAssignableFrom(typeToConsider);
    }
}

