/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.ddlgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.wst.validation.ValidationFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDDLGenerator {
    public static String ECLIPSELINK_DDL_GEN_JAR_VERSION = "1.0.100";
    public static String LAUNCH_CONFIG_NAME = "EclipseLink";
    public static String DDL_GEN_PACKAGE_NAME = "org.eclipse.jpt.eclipselink.core.ddlgen";
    public static String ECLIPSELINK_DDL_GEN_CLASS = String.valueOf(DDL_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_DDL_GEN_JAR = String.valueOf(DDL_GEN_PACKAGE_NAME) + "_";
    public static String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    public static String PROPERTIES_FILE_NAME = "login.properties";
    public static String PLUGINS_DIR = "plugins/";
    public static String TRUE = "true";
    public static String FALSE = "false";
    public static String NONE = "NONE";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    private ILaunch launch;
    private String puName;
    private JpaProject jpaProject;
    private String projectLocation;
    private boolean isDebug = false;
    private static final String JAVAX_PERSISTENCE_BUNDLE = "javax.persistence";
    private static final String ORG_ECLIPSE_PERSISTENCE_CORE_BUNDLE = "org.eclipse.persistence.core";
    private static final String ORG_ECLIPSE_PERSISTENCE_ASM_BUNDLE = "org.eclipse.persistence.asm";
    private static final String ORG_ECLIPSE_PERSISTENCE_ANTLR_BUNDLE = "org.eclipse.persistence.antlr";
    private static final String ORG_ECLIPSE_PERSISTENCE_JPA_BUNDLE = "org.eclipse.persistence.jpa";

    public static void generate(String puName, JpaProject project, String projectLocation, IProgressMonitor monitor) {
        if (puName == null || puName.length() == 0 || project == null) {
            throw new NullPointerException();
        }
        new EclipseLinkDDLGenerator(puName, project, projectLocation, monitor).generate();
    }

    protected EclipseLinkDDLGenerator(String puName, JpaProject jpaProject, String projectLocation, IProgressMonitor monitor) {
        this.puName = puName;
        this.jpaProject = jpaProject;
        this.projectLocation = projectLocation;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
            this.launchConfig = this.buildLaunchConfiguration();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generate() {
        this.preGenerate();
        String propertiesFile = String.valueOf(this.projectLocation) + "/" + PROPERTIES_FILE_NAME;
        this.initializeLaunchConfiguration(this.projectLocation, propertiesFile);
        this.saveLoginProperties(this.projectLocation, propertiesFile);
        this.addLaunchListener();
        this.launch = this.saveAndLaunchConfig();
    }

    private void initializeLaunchConfiguration(String projectLocation, String propertiesFile) {
        this.specifyJRE(this.jre.getName(), this.jre.getVMInstallType().getId());
        this.specifyProject(this.getJpaProject().getProject().getName());
        this.specifyMainType(ECLIPSELINK_DDL_GEN_CLASS);
        this.specifyProgramArguments(this.puName, propertiesFile);
        this.specifyWorkingDir(projectLocation);
        this.specifyClasspathProperties(this.getJpaProject(), this.buildJdbcJarPath(), this.buildBootstrapJarPath());
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    protected void preGenerate() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.disconnect();
        }
    }

    protected void postGenerate() {
        try {
            if (!this.isDebug) {
                this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.reconnect();
        this.validateProject();
    }

    protected void reconnect() {
        JpaProject.Updater updater = this.getJpaProject().getUpdater();
        this.getJpaProject().setUpdater((JpaProject.Updater)new SynchronousJpaProjectUpdater(this.getJpaProject()));
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.connect();
        }
        this.getJpaProject().setUpdater(updater);
    }

    protected void validateProject() {
        IProject project = this.getJpaProject().getProject();
        ValidateJob job = new ValidateJob(project);
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    private IPath buildJdbcJarPath() {
        return new Path(this.getJpaProjectConnectionDriverJarList());
    }

    private String getJpaProjectConnectionDriverJarList() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? "" : cp.getDriverJarList();
    }

    private IPath buildBootstrapJarPath() {
        try {
            File jarInstallDir = this.getBundleParentDir("org.eclipse.jpt.eclipselink.core");
            ArrayList result = new ArrayList();
            this.findFile(ECLIPSELINK_DDL_GEN_JAR, jarInstallDir, result);
            if (result.isEmpty()) {
                throw new RuntimeException("Could not find: " + DDL_GEN_PACKAGE_NAME + ".jar in: " + jarInstallDir);
            }
            File ddlGenJarFile = (File)result.get(0);
            String ddlGenJarPath = ddlGenJarFile.getCanonicalPath();
            return new Path(ddlGenJarPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void findFile(String fileName, File directory, List<? super File> list) {
        if (directory.listFiles() == null) {
            throw new RuntimeException("Could not find directory: " + directory);
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(fileName)) {
                list.add(file);
            }
            if (file.isDirectory()) {
                this.findFile(fileName, file, list);
            }
            ++n2;
        }
    }

    private File getBundleParentDir(String bundleName) throws IOException {
        if (Platform.inDevelopmentMode()) {
            Location eclipseHomeLoc = Platform.getInstallLocation();
            String eclipseHome = eclipseHomeLoc.getURL().getPath();
            if (!eclipseHome.endsWith(PLUGINS_DIR)) {
                eclipseHome = String.valueOf(eclipseHome) + PLUGINS_DIR;
            }
            return new File(eclipseHome);
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        return FileLocator.getBundleFile((Bundle)bundle).getParentFile();
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (launch.equals(EclipseLinkDDLGenerator.this.getLaunch())) {
                        EclipseLinkDDLGenerator.this.postGenerate();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    private void specifyJRE(String jreName, String vmId) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject(String projectName) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private void specifyMainType(String mainType) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    private void specifyProgramArguments(String puName, String propertiesPath) {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append(this.buildPuNameArgument(puName));
        programArguments.append(this.buildPropertiesFileArgument(propertiesPath));
        programArguments.append(this.buildDebugArgument());
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private void specifyClasspathProperties(JpaProject project, IPath jdbcJar, IPath bootstrapJar) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            classpath.add(this.getArchiveClasspathEntry(bootstrapJar).getMemento());
            classpath.add(this.getDefaultProjectClasspathEntry(project.getJavaProject()).getMemento());
            classpath.addAll(this.getPersistenceOsgiBundlesMemento());
            classpath.add(this.getArchiveClasspathEntry(jdbcJar).getMemento());
            classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        }
        catch (CoreException e) {
            throw new RuntimeException("An error occurs generating a memento", e);
        }
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private void specifyWorkingDir(String projectLocation) {
        File workingDir = new Path(projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    private IRuntimeClasspathEntry getSystemLibraryClasspathEntry() throws CoreException {
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
    }

    private IRuntimeClasspathEntry getDefaultProjectClasspathEntry(IJavaProject project) {
        IRuntimeClasspathEntry projectEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)project);
        projectEntry.setClasspathProperty(3);
        return projectEntry;
    }

    private IRuntimeClasspathEntry getArchiveClasspathEntry(IPath archivePath) {
        IRuntimeClasspathEntry archiveEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)archivePath);
        archiveEntry.setClasspathProperty(3);
        return archiveEntry;
    }

    private IRuntimeClasspathEntry getBundleClasspathEntry(String bundleId) {
        IPath persistClasspath = this.getBundleClasspath(bundleId);
        IRuntimeClasspathEntry bundleEntry = this.getArchiveClasspathEntry(persistClasspath);
        return bundleEntry;
    }

    private ILaunch saveAndLaunchConfig() {
        ILaunchConfiguration configuration = null;
        ILaunch result = null;
        try {
            configuration = this.launchConfig.doSave();
        }
        catch (CoreException saveException) {
            throw new RuntimeException("Could not save LaunchConfig", saveException);
        }
        try {
            result = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException lauchException) {
            throw new RuntimeException("An error occured during launch", lauchException);
        }
        return result;
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = null;
        this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        launchConfig = type.newInstance(null, LAUNCH_CONFIG_NAME);
        return launchConfig;
    }

    private void removeLaunchConfiguration(String launchConfigurationName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(launchConfigurationName)) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private void buildProjectLocationProperty(Properties properties, String location) {
        this.putProperty(properties, "eclipselink.application-location", location);
    }

    private void buildDDLModeProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.ddl-generation", "drop-and-create-tables");
        this.putProperty(properties, "eclipselink.ddl-generation.output-mode", "database");
    }

    protected void buildConnectionProperties(Properties properties) {
        ConnectionProfile cp = this.getConnectionProfile();
        this.putProperty(properties, "eclipselink.jdbc.bind-parameters", FALSE);
        this.putProperty(properties, "eclipselink.jdbc.driver", cp == null ? "" : cp.getDriverClassName());
        this.putProperty(properties, "eclipselink.jdbc.url", cp == null ? "" : cp.getURL());
        this.putProperty(properties, "eclipselink.jdbc.user", cp == null ? "" : cp.getUserName());
        this.putProperty(properties, "eclipselink.jdbc.password", cp == null ? "" : cp.getUserPassword());
    }

    private void buildConnectionPoolingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.jdbc.read-connections.shared", TRUE);
    }

    private void buildLoggingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.logging.level", "FINE");
        this.putProperty(properties, "eclipselink.logging.timestamp", FALSE);
        this.putProperty(properties, "eclipselink.logging.thread", FALSE);
        this.putProperty(properties, "eclipselink.logging.session", FALSE);
        this.putProperty(properties, "eclipselink.logging.exceptions", TRUE);
    }

    protected void buildCustomizationProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.orm.throw.exceptions", TRUE);
    }

    protected void putProperty(Properties properties, String key, String value) {
        properties.put(key, value == null ? "" : value);
    }

    protected void buildAllProperties(Properties properties, String projectLocation) {
        this.buildConnectionProperties(properties);
        this.buildConnectionPoolingProperties(properties);
        this.buildLoggingProperties(properties);
        this.buildCustomizationProperties(properties);
        this.buildDDLModeProperties(properties);
        this.buildProjectLocationProperty(properties, projectLocation);
    }

    private void saveLoginProperties(String projectLocation, String propertiesFile) {
        Properties elProperties = new Properties();
        this.buildAllProperties(elProperties, projectLocation);
        try {
            File file = new File(propertiesFile);
            if (!file.exists() && !file.createNewFile()) {
                throw new RuntimeException("createNewFile() failed: " + file);
            }
            FileOutputStream stream = new FileOutputStream(file);
            elProperties.store(stream, null);
            stream.close();
        }
        catch (Exception e) {
            String message = "Error saving: " + propertiesFile;
            throw new RuntimeException(message, e);
        }
    }

    private String buildPuNameArgument(String puName) {
        return " -pu \"" + puName + "\"";
    }

    private String buildPropertiesFileArgument(String propertiesFile) {
        return " -p \"" + propertiesFile + "\"";
    }

    private String buildDebugArgument() {
        return this.isDebug ? " -debug" : "";
    }

    protected JpaPlatform getPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    protected JpaProject getJpaProject() {
        return this.jpaProject;
    }

    protected ConnectionProfile getConnectionProfile() {
        return this.getJpaProject().getConnectionProfile();
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.getJpaProject().getJavaProject());
    }

    private Collection<String> getPersistenceOsgiBundlesMemento() throws CoreException {
        HashSet<String> result = new HashSet<String>();
        if (this.javaxPersistenceBundleExists()) {
            result.add(this.getBundleClasspathEntry(JAVAX_PERSISTENCE_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_CORE_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_ASM_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_ANTLR_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_JPA_BUNDLE).getMemento());
        }
        return result;
    }

    private IPath getBundleClasspath(String pluginID) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            throw new RuntimeException(String.valueOf(pluginID) + " cannot be retrieved from the Platform");
        }
        return this.getClassPath(bundle);
    }

    private IPath getClassPath(Bundle bundle) {
        String path = (String)bundle.getHeaders().get(BUNDLE_CLASSPATH);
        if (path == null) {
            path = ".";
        }
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)BUNDLE_CLASSPATH, (String)path);
        }
        catch (BundleException e) {
            throw new RuntimeException("Error parsing bundle header: " + bundle, e);
        }
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                URL url;
                ManifestElement element = elements[i];
                String value = element.getValue();
                if (".".equals(value)) {
                    value = "/";
                }
                if ((url = bundle.getEntry(value)) != null) {
                    try {
                        URL resolvedURL = FileLocator.resolve((URL)url);
                        String filestring = FileLocator.toFileURL((URL)resolvedURL).getFile();
                        if (filestring.startsWith("file:")) {
                            filestring = filestring.substring(filestring.indexOf(58) + 1);
                        }
                        if (filestring.endsWith("!/")) {
                            filestring = filestring.substring(0, filestring.lastIndexOf(33));
                        }
                        File file = new File(filestring);
                        String filePath = file.getCanonicalPath();
                        return new Path(filePath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error locating bundle: " + bundle, e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private boolean javaxPersistenceBundleExists() {
        return Platform.getBundle((String)JAVAX_PERSISTENCE_BUNDLE) != null;
    }

    private class ValidateJob
    extends Job {
        private IProject project;

        public ValidateJob(IProject project) {
            super(JptCoreMessages.VALIDATE_JOB);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                ValidationFramework.getDefault().validate(new IProject[]{this.project}, true, false, monitor);
            }
            catch (CoreException coreException) {
                status = Status.CANCEL_STATUS;
            }
            return status;
        }
    }
}

