/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.BaseEclipseLinkTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseEclipseLinkTypeConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements BaseEclipseLinkTypeConverterAnnotation {
    final DeclarationAnnotationElementAdapter<String> dataTypeDeclarationAdapter = this.buildTypeAdapter(this.getDataTypeElementName());
    final AnnotationElementAdapter<String> dataTypeAdapter = new MemberAnnotationElementAdapter(this.member, this.dataTypeDeclarationAdapter);
    String dataType;
    String fullyQualifiedDataType;
    final DeclarationAnnotationElementAdapter<String> objectTypeDeclarationAdapter = this.buildTypeAdapter(this.getObjectTypeElementName());
    final AnnotationElementAdapter<String> objectTypeAdapter = new MemberAnnotationElementAdapter(this.member, this.objectTypeDeclarationAdapter);
    String objectType;
    String fullyQualifiedObjectType;

    SourceBaseEclipseLinkTypeConverterAnnotation(JavaResourcePersistentMember parent, Member member, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, member, daa);
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, elementName, false, TypeStringExpressionConverter.instance());
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.dataType = this.buildDataType(astRoot);
        this.fullyQualifiedDataType = this.buildFullyQualifiedDataType(astRoot);
        this.objectType = this.buildObjectType(astRoot);
        this.fullyQualifiedObjectType = this.buildFullyQualifiedObjectType(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncDataType(this.buildDataType(astRoot));
        this.syncFullyQualifiedDataType(this.buildFullyQualifiedDataType(astRoot));
        this.syncObjectType(this.buildObjectType(astRoot));
        this.syncFullyQualifiedObjectType(this.buildFullyQualifiedObjectType(astRoot));
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        if (this.attributeValueHasChanged(this.dataType, dataType)) {
            this.dataType = dataType;
            this.dataTypeAdapter.setValue((Object)dataType);
        }
    }

    private void syncDataType(String astDataType) {
        String old = this.dataType;
        this.dataType = astDataType;
        this.firePropertyChanged("dataType", old, astDataType);
    }

    private String buildDataType(CompilationUnit astRoot) {
        return (String)this.dataTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataTypeDeclarationAdapter, astRoot);
    }

    abstract String getDataTypeElementName();

    @Override
    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    private void syncFullyQualifiedDataType(String name) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = name;
        this.firePropertyChanged("fullyQualifiedDataType", old, name);
    }

    private String buildFullyQualifiedDataType(CompilationUnit astRoot) {
        return this.dataType == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.dataTypeAdapter.getExpression(astRoot));
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        if (this.attributeValueHasChanged(this.objectType, objectType)) {
            this.objectType = objectType;
            this.objectTypeAdapter.setValue((Object)objectType);
        }
    }

    private void syncObjectType(String astObjectType) {
        String old = this.objectType;
        this.objectType = astObjectType;
        this.firePropertyChanged("objectType", old, astObjectType);
    }

    private String buildObjectType(CompilationUnit astRoot) {
        return (String)this.objectTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectTypeDeclarationAdapter, astRoot);
    }

    abstract String getObjectTypeElementName();

    @Override
    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    private void syncFullyQualifiedObjectType(String name) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = name;
        this.firePropertyChanged("fullyQualifiedObjectType", old, name);
    }

    private String buildFullyQualifiedObjectType(CompilationUnit astRoot) {
        return this.objectType == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.objectTypeAdapter.getExpression(astRoot));
    }
}

