/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements EclipseLinkConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Converter");
    private static final DeclarationAnnotationElementAdapter<String> CONVERTER_CLASS_ADAPTER = SourceEclipseLinkConverterAnnotation.buildConverterClassAdapter();
    private final AnnotationElementAdapter<String> converterClassAdapter;
    private String converterClass;
    private String fullyQualifiedConverterClassName;

    public SourceEclipseLinkConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.converterClassAdapter = new MemberAnnotationElementAdapter(member, CONVERTER_CLASS_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.converterClass = this.buildConverterClass(astRoot);
        this.fullyQualifiedConverterClassName = this.buildFullyQualifiedConverterClassName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncConverterClass(this.buildConverterClass(astRoot));
        this.syncFullyQualifiedConverterClassName(this.buildFullyQualifiedConverterClassName(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        if (this.attributeValueHasChanged(this.converterClass, converterClass)) {
            this.converterClass = converterClass;
            this.converterClassAdapter.setValue((Object)converterClass);
        }
    }

    private void syncConverterClass(String astConverterClass) {
        String old = this.converterClass;
        this.converterClass = astConverterClass;
        this.firePropertyChanged("converterClass", old, astConverterClass);
    }

    private String buildConverterClass(CompilationUnit astRoot) {
        return (String)this.converterClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CONVERTER_CLASS_ADAPTER, astRoot);
    }

    @Override
    public boolean converterClassImplementsInterface(String interfaceName, CompilationUnit astRoot) {
        return this.converterClass != null && ASTTools.typeIsSubTypeOf((Expression)this.converterClassAdapter.getExpression(astRoot), (String)interfaceName);
    }

    @Override
    public String getFullyQualifiedConverterClassName() {
        return this.fullyQualifiedConverterClassName;
    }

    private void syncFullyQualifiedConverterClassName(String name) {
        String old = this.fullyQualifiedConverterClassName;
        this.fullyQualifiedConverterClassName = name;
        this.firePropertyChanged("fullyQualifiedConverterClassName", old, name);
    }

    private String buildFullyQualifiedConverterClassName(CompilationUnit astRoot) {
        return this.converterClass == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.converterClassAdapter.getExpression(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildConverterClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "converterClass", false, SimpleTypeStringExpressionConverter.instance());
    }
}

