/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocaleObjectCache {
    private Map _map = Collections.synchronizedMap(new HashMap());
    private ReferenceQueue _rq = new ReferenceQueue();

    public Object get(Object key) {
        this.expungeStaleEntries();
        WeakValueRef ref = (WeakValueRef)this._map.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        String valInCache;
        this.expungeStaleEntries();
        WeakValueRef ref = (WeakValueRef)this._map.get(key);
        if (ref != null && (valInCache = (String)ref.get()) != null) {
            return valInCache;
        }
        this._map.put(key, new WeakValueRef(key, value, this._rq));
        return value;
    }

    private void expungeStaleEntries() {
        Reference val;
        while ((val = this._rq.poll()) != null) {
            Object key = ((WeakValueRef)val).getKey();
            this._map.remove(key);
        }
    }

    private static class WeakValueRef
    extends WeakReference {
        private Object _key;

        public WeakValueRef(Object key, Object value, ReferenceQueue rq) {
            super(value, rq);
            this._key = key;
        }

        public Object get() {
            return super.get();
        }

        public Object getKey() {
            return this._key;
        }
    }
}

