/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.details;

import java.util.ListIterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkConversionValueDialog;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkUiDetailsMessages;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveTablePane;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkObjectTypeConverterComposite
extends Pane<EclipseLinkObjectTypeConverter> {
    public EclipseLinkObjectTypeConverterComposite(PropertyValueModel<? extends EclipseLinkObjectTypeConverter> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.addLabeledText(container, EclipseLinkUiDetailsMessages.EclipseLinkConverterComposite_nameTextLabel, this.buildNameTextHolder());
        this.addDataTypeChooser(container);
        this.addObjectTypeChooser(container);
        this.addConversionValuesTable(container);
        this.addLabeledEditableCombo(container, EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_defaultObjectValueLabel, this.buildDefaultObjectValueListHolder(), this.buildDefaultObjectValueHolder(), this.buildStringConverter(), null);
        new PaneEnabler(this.buildBooleanHolder(), (Pane)this);
    }

    protected WritablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<EclipseLinkObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((EclipseLinkObjectTypeConverter)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((EclipseLinkObjectTypeConverter)this.subject).setName(value);
            }
        };
    }

    private ClassChooserPane<EclipseLinkObjectTypeConverter> addDataTypeChooser(Composite container) {
        return new ClassChooserPane<EclipseLinkObjectTypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"dataType"}){

                    protected String buildValue_() {
                        return ((EclipseLinkObjectTypeConverter)this.subject).getDataType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((EclipseLinkObjectTypeConverter)this.subject).setDataType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getDataType();
            }

            protected String getLabelText() {
                return EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_dataTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getJpaProject();
            }

            protected void setClassName(String className) {
                ((EclipseLinkObjectTypeConverter)this.getSubject()).setDataType(className);
            }

            protected char getEnclosingTypeSeparator() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getEnclosingTypeSeparator();
            }
        };
    }

    private ClassChooserPane<EclipseLinkObjectTypeConverter> addObjectTypeChooser(Composite container) {
        return new ClassChooserPane<EclipseLinkObjectTypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"objectType"}){

                    protected String buildValue_() {
                        return ((EclipseLinkObjectTypeConverter)this.subject).getObjectType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((EclipseLinkObjectTypeConverter)this.subject).setObjectType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getObjectType();
            }

            protected String getLabelText() {
                return EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_objectTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getJpaProject();
            }

            protected void setClassName(String className) {
                ((EclipseLinkObjectTypeConverter)this.getSubject()).setObjectType(className);
            }

            protected int getTypeDialogStyle() {
                return 1024;
            }

            protected char getEnclosingTypeSeparator() {
                return ((EclipseLinkObjectTypeConverter)this.getSubject()).getEnclosingTypeSeparator();
            }
        };
    }

    protected void addConversionValuesTable(Composite container) {
        Group conversionValuesGroupPane = this.addTitledGroup(container, EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_conversionValuesGroupTitle);
        WritablePropertyValueModel<EclipseLinkConversionValue> conversionValueHolder = this.buildConversionValueHolder();
        new AddRemoveTablePane<EclipseLinkObjectTypeConverter>((Pane)this, (Composite)conversionValuesGroupPane, this.buildConversionValuesAdapter(), this.buildConversionValuesListModel(), conversionValueHolder, this.buildConversionValuesLabelProvider(), null){

            protected ColumnAdapter<EclipseLinkConversionValue> buildColumnAdapter() {
                return new ConversionValueColumnAdapter();
            }
        };
    }

    protected WritablePropertyValueModel<EclipseLinkConversionValue> buildConversionValueHolder() {
        return new SimplePropertyValueModel();
    }

    protected AddRemovePane.Adapter buildConversionValuesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EclipseLinkConversionValueDialog dialog = EclipseLinkObjectTypeConverterComposite.this.buildConversionValueDialogForAdd();
                EclipseLinkObjectTypeConverterComposite.this.addConversionValueFromDialog(dialog, listSelectionModel);
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_conversionValueEdit;
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                EclipseLinkConversionValue conversionValue = (EclipseLinkConversionValue)listSelectionModel.selectedValue();
                EclipseLinkConversionValueDialog dialog = new EclipseLinkConversionValueDialog(EclipseLinkObjectTypeConverterComposite.this.getShell(), (EclipseLinkObjectTypeConverter)EclipseLinkObjectTypeConverterComposite.this.getSubject(), conversionValue);
                EclipseLinkObjectTypeConverterComposite.this.editConversionValueFromDialog(dialog, conversionValue);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)EclipseLinkObjectTypeConverterComposite.this.getSubject();
                int[] selectedIndices = listSelectionModel.selectedIndices();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    converter.removeConversionValue(selectedIndices[index]);
                }
            }
        };
    }

    protected EclipseLinkConversionValueDialog buildConversionValueDialogForAdd() {
        return new EclipseLinkConversionValueDialog(this.getShell(), (EclipseLinkObjectTypeConverter)this.getSubject());
    }

    protected void addConversionValueFromDialog(EclipseLinkConversionValueDialog dialog, ObjectListSelectionModel listSelectionModel) {
        if (dialog.open() != 0) {
            return;
        }
        EclipseLinkConversionValue conversionValue = ((EclipseLinkObjectTypeConverter)this.getSubject()).addConversionValue();
        conversionValue.setDataValue(dialog.getDataValue());
        conversionValue.setObjectValue(dialog.getObjectValue());
        listSelectionModel.setSelectedValue((Object)conversionValue);
    }

    protected void editConversionValueFromDialog(EclipseLinkConversionValueDialog dialog, EclipseLinkConversionValue conversionValue) {
        if (dialog.open() != 0) {
            return;
        }
        conversionValue.setDataValue(dialog.getDataValue());
        conversionValue.setObjectValue(dialog.getObjectValue());
    }

    private ListValueModel<EclipseLinkConversionValue> buildConversionValuesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildConversionValuesListHolder(), new String[]{"dataValue", "objectValue"});
    }

    private ListValueModel<EclipseLinkConversionValue> buildConversionValuesListHolder() {
        return new ListAspectAdapter<EclipseLinkObjectTypeConverter, EclipseLinkConversionValue>(this.getSubjectHolder(), new String[]{"conversionValues"}){

            protected ListIterator<EclipseLinkConversionValue> listIterator_() {
                return ((EclipseLinkObjectTypeConverter)this.subject).conversionValues();
            }

            protected int size_() {
                return ((EclipseLinkObjectTypeConverter)this.subject).conversionValuesSize();
            }
        };
    }

    private ITableLabelProvider buildConversionValuesLabelProvider() {
        return new TableLabelProvider();
    }

    protected ListValueModel<String> buildDefaultObjectValueListHolder() {
        return new TransformationListValueModelAdapter<EclipseLinkConversionValue, String>(this.buildConversionValuesListModel()){

            protected String transformItem(EclipseLinkConversionValue conversionValue) {
                return conversionValue.getObjectValue();
            }
        };
    }

    protected WritablePropertyValueModel<String> buildDefaultObjectValueHolder() {
        return new PropertyAspectAdapter<EclipseLinkObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"defaultObjectValue"}){

            protected String buildValue_() {
                return ((EclipseLinkObjectTypeConverter)this.subject).getDefaultObjectValue();
            }

            protected void setValue_(String value) {
                if (value != null && value.length() == 0) {
                    value = null;
                }
                ((EclipseLinkObjectTypeConverter)this.subject).setDefaultObjectValue(value);
            }
        };
    }

    protected final StringConverter<String> buildStringConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                return value == null ? "" : value;
            }
        };
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<EclipseLinkObjectTypeConverter, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(EclipseLinkObjectTypeConverter value) {
                return value != null;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConversionValueColumnAdapter
    implements ColumnAdapter<EclipseLinkConversionValue> {
        public static final int COLUMN_COUNT = 2;
        public static final int DATA_VALUE_COLUMN = 0;
        public static final int OBJECT_VALUE_COLUMN = 1;

        private ConversionValueColumnAdapter() {
        }

        private WritablePropertyValueModel<String> buildDataValueHolder(EclipseLinkConversionValue subject) {
            return new PropertyAspectAdapter<EclipseLinkConversionValue, String>("dataValue", subject){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValue)this.subject).getDataValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValue)this.subject).setDataValue(value);
                }
            };
        }

        private WritablePropertyValueModel<String> buildObjectValueHolder(EclipseLinkConversionValue subject) {
            return new PropertyAspectAdapter<EclipseLinkConversionValue, String>("objectValue", subject){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValue)this.subject).getObjectValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValue)this.subject).setObjectValue(value);
                }
            };
        }

        public WritablePropertyValueModel<?>[] cellModels(EclipseLinkConversionValue subject) {
            WritablePropertyValueModel[] holders = new WritablePropertyValueModel[]{this.buildDataValueHolder(subject), this.buildObjectValueHolder(subject)};
            return holders;
        }

        public int columnCount() {
            return 2;
        }

        public String columnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_conversionValuesDataValueColumn;
                }
                case 1: {
                    return EclipseLinkUiDetailsMessages.EclipseLinkObjectTypeConverterComposite_conversionValuesObjectValueColumn;
                }
            }
            return null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EclipseLinkConversionValue conversionValue = (EclipseLinkConversionValue)element;
            String value = null;
            switch (columnIndex) {
                case 0: {
                    value = conversionValue.getDataValue();
                    break;
                }
                case 1: {
                    value = conversionValue.getObjectValue();
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }
}

