/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ExceptionRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.SuspendRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadExitRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDeathRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ThreadReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.BreakpointEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.DebuggerStatementEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.EventSetImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ExceptionEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ScriptLoadEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.StepEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.SuspendEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ThreadEnterEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ThreadExitEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.VMDeathEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.BreakpointRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.DebuggerStatementRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestManagerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.StepRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.SuspendRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TimeoutException;

public final class EventQueueImpl
extends MirrorImpl
implements EventQueue {
    private VirtualMachineImpl vm;
    private EventRequestManagerImpl eventRequestManager;

    public EventQueueImpl(VirtualMachineImpl vm, EventRequestManagerImpl eventRequestManager) {
        super(vm);
        this.vm = vm;
        this.eventRequestManager = eventRequestManager;
    }

    public EventSet remove() {
        return this.remove(-1);
    }

    public EventSet remove(int timeout) {
        try {
            EventSetImpl eventSet;
            while (true) {
                Location location;
                ScriptReferenceImpl script;
                Long scriptId;
                ThreadReferenceImpl thread;
                Long threadId;
                EventPacket event = this.vm.receiveEvent(timeout);
                String eventName = event.getEvent();
                eventSet = new EventSetImpl(this.vm);
                if (eventName.equals("script")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread == null) continue;
                    eventSet.setThread(thread);
                    scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                    script = this.vm.addScript(scriptId);
                    if (script != null) {
                        List scriptLoadRequests = this.eventRequestManager.scriptLoadRequests();
                        Iterator iterator = scriptLoadRequests.iterator();
                        while (iterator.hasNext()) {
                            ScriptLoadRequest request = (ScriptLoadRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ScriptLoadEventImpl(this.vm, (ThreadReference)thread, script, request));
                        }
                    }
                    if (!eventSet.isEmpty()) {
                        thread.markSuspended(false);
                    }
                } else if (eventName.equals("break")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread == null) continue;
                    eventSet.setThread(thread);
                    scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                    script = this.vm.getScript(scriptId);
                    if (script != null) {
                        ThreadReference requestThread;
                        EventRequestImpl request;
                        Iterator iterator;
                        String stepType;
                        int lineNumber = ((Number)event.getBody().get("lineNumber")).intValue();
                        location = script.lineLocation(lineNumber);
                        boolean atBreakpoint = false;
                        Number breakpointId = (Number)event.getBody().get("breakpoint");
                        if (breakpointId != null) {
                            List breakpointRequests = this.eventRequestManager.breakpointRequests();
                            Iterator iterator2 = breakpointRequests.iterator();
                            while (iterator2.hasNext()) {
                                BreakpointRequestImpl request2 = (BreakpointRequestImpl)iterator2.next();
                                ThreadReference requestThread2 = request2.thread();
                                if (!request2.isEnabled() || requestThread2 != null && thread != requestThread2 || breakpointId.longValue() != request2.breakpointId().longValue()) continue;
                                eventSet.add(new BreakpointEventImpl(this.vm, (ThreadReference)thread, location, request2));
                                atBreakpoint = true;
                            }
                        }
                        if ("suspended".equals(stepType = (String)event.getBody().get("step"))) {
                            List suspendRequests = this.eventRequestManager.suspendRequests();
                            iterator = suspendRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (SuspendRequestImpl)iterator.next();
                                requestThread = ((SuspendRequestImpl)request).thread();
                                if (!request.isEnabled() || requestThread != null && thread != requestThread) continue;
                                eventSet.add(new SuspendEventImpl(this.vm, (ThreadReference)thread, location, (SuspendRequest)request));
                            }
                        } else if (stepType != null) {
                            List stepRequests = this.eventRequestManager.stepRequests();
                            iterator = stepRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (StepRequestImpl)iterator.next();
                                requestThread = ((StepRequestImpl)request).thread();
                                if (!request.isEnabled() || requestThread != null && thread != requestThread) continue;
                                eventSet.add(new StepEventImpl(this.vm, (ThreadReference)thread, location, (StepRequest)request));
                            }
                        }
                        Boolean debuggerStatement = (Boolean)event.getBody().get("debuggerStatement");
                        if (debuggerStatement.booleanValue()) {
                            List debuggerStatementRequests = this.eventRequestManager.debuggerStatementRequests();
                            Iterator iterator3 = debuggerStatementRequests.iterator();
                            while (iterator3.hasNext()) {
                                DebuggerStatementRequestImpl request3 = (DebuggerStatementRequestImpl)iterator3.next();
                                ThreadReference requestThread3 = request3.thread();
                                if (!request3.isEnabled() || requestThread3 != null && thread != requestThread3) continue;
                                eventSet.add(new DebuggerStatementEventImpl(this.vm, (ThreadReference)thread, location, request3));
                            }
                        }
                        if (!eventSet.isEmpty()) {
                            thread.markSuspended(atBreakpoint);
                        }
                    }
                } else if (eventName.equals("exception")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread != null) {
                        eventSet.setThread(thread);
                        scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                        script = this.vm.getScript(scriptId);
                        int lineNumber = ((Number)event.getBody().get("lineNumber")).intValue();
                        location = script.lineLocation(lineNumber);
                        String message = (String)event.getBody().get("message");
                        List exceptionRequests = this.eventRequestManager.exceptionRequests();
                        Iterator iterator = exceptionRequests.iterator();
                        while (iterator.hasNext()) {
                            ExceptionRequest request = (ExceptionRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ExceptionEventImpl(this.vm, thread, location, message, request));
                        }
                        if (!eventSet.isEmpty()) {
                            thread.markSuspended(false);
                        }
                    }
                } else if (eventName.equals("thread")) {
                    ThreadExitRequest request;
                    Iterator iterator;
                    ThreadReferenceImpl thread2;
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    String type = (String)event.getBody().get("type");
                    if ("enter".equals(type)) {
                        thread2 = this.vm.getThread(threadId);
                        if (thread2 != null) {
                            eventSet.setThread(thread2);
                            List threadEnterRequests = this.eventRequestManager.threadEnterRequests();
                            iterator = threadEnterRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (ThreadEnterRequest)iterator.next();
                                if (!request.isEnabled()) continue;
                                eventSet.add(new ThreadEnterEventImpl(this.vm, thread2, (ThreadEnterRequest)request));
                            }
                        }
                    } else if ("exit".equals(type)) {
                        thread2 = this.vm.removeThread(threadId);
                        List threadExitRequests = this.eventRequestManager.threadExitRequests();
                        iterator = threadExitRequests.iterator();
                        while (iterator.hasNext()) {
                            request = (ThreadExitRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ThreadExitEventImpl(this.vm, thread2, request));
                        }
                    } else if ("vmdeath".equals(type)) {
                        List requests = this.eventRequestManager.vmDeathRequests();
                        Iterator iter = requests.iterator();
                        while (iter.hasNext()) {
                            VMDeathRequest request4 = (VMDeathRequest)iter.next();
                            if (!request4.isEnabled()) continue;
                            eventSet.add(new VMDeathEventImpl(this.vm, (EventRequest)request4));
                        }
                    }
                }
                if (!eventSet.isEmpty()) break;
                eventSet.resume();
            }
            return eventSet;
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        catch (DisconnectedException e) {
            this.vm.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        return null;
    }
}

