/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.Messages;
import org.eclipse.wst.xml.xpath.ui.internal.views.JFaceNodeContentProviderXPath;
import org.eclipse.wst.xml.xpath.ui.internal.views.JFaceNodeLabelProviderXPath;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathComputer;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathViewActions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathView
extends ViewPart {
    private boolean isFiringSelection = false;
    private IPartListener2 partListener2 = new XPathPartListener();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == XPathView.this.getSite().getPage().getActiveEditor() && selection instanceof IStructuredSelection) {
                XPathView.this.currentSelection = (IStructuredSelection)selection;
                if (!selection.isEmpty() && XPathView.this.currentSelection.getFirstElement() instanceof Node) {
                    XPathView.this.recalculateLocation((Node)XPathView.this.currentSelection.getFirstElement());
                    boolean isLinked = XPathView.this.xpathViewActions.isLinkedWithEditor(XPathView.this.treeViewer);
                    if (isLinked) {
                        XPathView.this.treeViewer.setSelection((ISelection)XPathView.this.currentSelection, true);
                    }
                } else {
                    XPathView.this.recalculateLocation(null);
                }
            }
        }
    };
    private TreeViewer treeViewer;
    private IEditorPart activeEditor;
    private Text text;
    private XPathComputer xpathComputer;
    private Text locationText;
    private XPathViewActions xpathViewActions = new XPathViewActions();
    private IPostSelectionProvider selectionProvider = new SelectionProvider();
    private String location = "";
    private String message;
    private boolean expressionValid = true;
    private Integer currentSheet = 0;
    private Map<Integer, String> sheetMap;
    private IStructuredSelection currentSelection;
    private Node contextNode = null;

    public void createPartControl(Composite parent) {
        Composite parentComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parentComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 0, true, false, 2, 1);
        parentComp.setLayoutData((Object)gd);
        Composite comp = new Composite(parentComp, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label(comp, 0);
        label.setText(Messages.XPathView_1);
        this.text = new Text(comp, 2048);
        gd = new GridData(4, 0, true, false);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPathView.this.recomputeXPath();
            }
        });
        this.locationText = new Text(comp, 65544);
        gd = new GridData(4, 0, true, false);
        this.locationText.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(parentComp, 0);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new JFaceNodeLabelProviderXPath());
        this.treeViewer.setContentProvider((IContentProvider)new JFaceNodeContentProviderXPath());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (XPathView.this.getSite().getPage().getActivePart() == XPathView.this) {
                    XPathView.this.handleTreeSelection((IStructuredSelection)event.getSelection(), false);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XPathView.this.handleTreeSelection((IStructuredSelection)event.getSelection(), true);
            }
        });
        final CTabFolder folder = new CTabFolder(parentComp, 0x800400);
        gd = new GridData(4, 0, true, false);
        gd.heightHint = 0;
        folder.setLayoutData((Object)gd);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                XPathView.this.sheetMap.put(XPathView.this.currentSheet, XPathView.this.text.getText());
                XPathView.this.pageChange(folder.indexOf(item));
            }
        });
        int i = 0;
        while (i < 5) {
            CTabItem item = new CTabItem(folder, 0, i);
            item.setText(String.valueOf(Messages.XPathView_2) + (i + 1));
            ++i;
        }
        folder.setSelection(this.currentSheet.intValue());
        this.pageChange(this.currentSheet);
        this.xpathComputer = new XPathComputer(this);
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.initEditorListener();
    }

    private void handleTreeSelection(IStructuredSelection selection, boolean reveal) {
        if (this.activeEditor != null) {
            Object element;
            this.isFiringSelection = true;
            if (selection.getFirstElement() != null && (element = selection.getFirstElement()) instanceof IDOMNode) {
                IDOMNode node = (IDOMNode)element;
                ITextEditor textEditor = (ITextEditor)this.activeEditor.getAdapter(ITextEditor.class);
                if (textEditor != null) {
                    this.getSite().getWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)textEditor);
                    if (reveal) {
                        textEditor.selectAndReveal(node.getStartOffset(), node.getEndOffset() - node.getStartOffset());
                    } else {
                        textEditor.setHighlightRange(node.getStartOffset(), 0, true);
                    }
                }
            }
            this.isFiringSelection = false;
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                XPathView.this.xpathViewActions.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void pageChange(int index) {
        this.currentSheet = index;
        String exp = this.sheetMap.get(index);
        if (exp != null) {
            this.text.setText(exp);
        } else {
            this.text.setText("/");
        }
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        IAction[] items = this.xpathViewActions.createMenuContributions(this.treeViewer);
        int i = 0;
        while (i < items.length) {
            IAction item = items[i];
            mgr.add(item);
            ++i;
        }
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        IAction[] items = this.xpathViewActions.createToolbarContributions(this.treeViewer);
        int i = 0;
        while (i < items.length) {
            IAction item = items[i];
            mgr.add(item);
            ++i;
        }
    }

    private void recalculateLocation(Node selected) {
        this.location = XSLTXPathHelper.calculateXPathToNode((Node)selected);
        this.contextNode = selected;
        this.updateLocationText();
    }

    private void recomputeXPath() {
        if (this.activeEditor != null) {
            boolean valid = this.expressionValid;
            try {
                if (this.contextNode != null) {
                    this.xpathComputer.setSelectedNode(this.contextNode);
                }
                this.xpathComputer.setText(this.text.getText());
                this.xpathComputer.compute();
                valid = true;
            }
            catch (XPathExpressionException e) {
                valid = false;
                this.message = e.getCause() != null ? e.getCause().getMessage() : "Invalid XPath expression";
            }
            if (this.expressionValid != valid) {
                this.expressionValid = valid;
                this.updateLocationText();
            }
        }
    }

    void xpathRecomputed(NodeList nodeList) {
        Control refreshControl = this.treeViewer.getControl();
        if (refreshControl != null && !refreshControl.isDisposed()) {
            refreshControl.setRedraw(false);
            this.treeViewer.setInput((Object)nodeList);
            this.treeViewer.setSelection((ISelection)this.currentSelection, true);
            refreshControl.setRedraw(true);
        }
    }

    private void updateLocationText() {
        if (this.expressionValid) {
            this.locationText.setText(String.valueOf(Messages.XPathView_0) + this.location);
            this.locationText.setForeground(null);
        } else {
            this.locationText.setText(this.message);
            this.locationText.setForeground(JFaceColors.getErrorText((Display)this.locationText.getDisplay()));
        }
    }

    private void initEditorListener() {
        this.getSite().getPage().addPartListener(this.partListener2);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        this.editorActivated((IWorkbenchPart)this.getSite().getPage().getActiveEditor());
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener2);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        this.xpathComputer.dispose();
        super.dispose();
    }

    private void editorActivated(IWorkbenchPart part) {
        if (part != this.activeEditor && part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            IStructuredModel model = this.getEditorModel(editor);
            if (model != null) {
                this.activeEditor = editor;
                this.xpathComputer.setModel(model);
                this.xpathComputer.setSelectedNode((Document)model.getAdapter(Document.class));
            }
            this.recomputeXPath();
        }
    }

    private void editorClosed(IWorkbenchPart part) {
        if (part == this.activeEditor) {
            this.treeViewer.setInput(null);
            this.locationText.setText("");
            this.activeEditor = null;
        }
    }

    private IStructuredModel getEditorModel(IEditorPart editor) {
        return (IStructuredModel)editor.getAdapter(IStructuredModel.class);
    }

    public Object getAdapter(Class key) {
        Object adapter = null;
        if (key.equals(IShowInTarget.class) && this.treeViewer != null) {
            adapter = new IShowInTarget(){

                public boolean show(ShowInContext context) {
                    XPathView.this.treeViewer.setSelection(context.getSelection());
                    return XPathView.this.treeViewer.getSelection().equals(context.getSelection());
                }
            };
        } else if (key.equals(IShowInSource.class) && this.activeEditor != null) {
            adapter = new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)XPathView.this.activeEditor.getEditorInput(), XPathView.this.activeEditor.getEditorSite().getSelectionProvider().getSelection());
                }
            };
        } else if (key.equals(IShowInTargetList.class) && this.activeEditor != null) {
            adapter = this.activeEditor.getAdapter(key);
        }
        if (adapter == null) {
            adapter = super.getAdapter(key);
        }
        return adapter;
    }

    public void saveState(IMemento memento) {
        this.sheetMap.put(this.currentSheet, this.text.getText());
        memento.putInteger("CurrentSheet", this.currentSheet.intValue());
        for (Map.Entry<Integer, String> entry : this.sheetMap.entrySet()) {
            IMemento child = memento.createChild("Sheet");
            child.putInteger("Index", entry.getKey().intValue());
            child.putString("XPath", entry.getValue());
        }
        boolean link = this.xpathViewActions.isLinkWithEditor();
        memento.putBoolean("LinkWithEditor", link);
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.sheetMap = new HashMap<Integer, String>();
        if (memento != null) {
            IMemento[] sheets = memento.getChildren("Sheet");
            if (sheets != null) {
                this.currentSheet = memento.getInteger("CurrentSheet");
                IMemento[] iMementoArray = sheets;
                int n = sheets.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento sheet = iMementoArray[n2];
                    this.sheetMap.put(sheet.getInteger("Index"), sheet.getString("XPath"));
                    ++n2;
                }
            }
            Boolean linkWithEditor = memento.getBoolean("LinkWithEditor");
            boolean link = false;
            if (linkWithEditor != null) {
                link = linkWithEditor;
            }
            this.xpathViewActions.setLinkWithEditor(link);
        }
        if (this.currentSheet == null) {
            this.currentSheet = 0;
        }
        super.init(site, memento);
    }

    private class SelectionProvider
    implements IPostSelectionProvider {
        private ListenerList listeners = new ListenerList();
        private ListenerList postListeners = new ListenerList();
        private ISelectionChangedListener postSelectionChangedListener = new PostSelectionChangedListener();
        private ISelectionChangedListener selectionChangedListener = new SelectionChangedListener();

        private SelectionProvider() {
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.add((Object)listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public void fireSelectionChanged(final SelectionChangedEvent event, ListenerList listenerList) {
            XPathView.this.isFiringSelection = true;
            Object[] listeners = listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++i;
            }
            XPathView.this.isFiringSelection = false;
        }

        public ISelection getSelection() {
            if (XPathView.this.treeViewer != null) {
                return XPathView.this.treeViewer.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public boolean isFiringSelection() {
            return XPathView.this.isFiringSelection;
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.remove((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (!XPathView.this.isFiringSelection) {
                XPathView.this.treeViewer.setSelection(selection);
            }
        }

        private class PostSelectionChangedListener
        implements ISelectionChangedListener {
            private PostSelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection()) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.postListeners);
                }
            }
        }

        private class SelectionChangedListener
        implements ISelectionChangedListener {
            private SelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection()) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.listeners);
                }
            }
        }
    }

    private class XPathPartListener
    implements IPartListener2 {
        private XPathPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            XPathView.this.editorActivated(partRef.getPart(false));
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            XPathView.this.editorClosed(partRef.getPart(false));
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }
    }
}

