/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsManager {
    private static final String ANNOTATION_DEFINITION = "annotationDefinition";
    private static final String ANNOTATION_CATEGORY = "annotationCategory";
    private static final String ANNOTATION_INITIALIZER = "annotationInitializer";
    private static final String ANNOTATION_PROCESSOR = "annotationProcessor";
    private static final String ANNOTATION = "annotation";
    private static List<AnnotationDefinition> annotationCache = null;
    private static Map<String, String> annotationCategoryCache = null;
    private static Map<String, IConfigurationElement> annotationInitializerCache = null;
    private static Map<String, List<IConfigurationElement>> annotationProcessorCache = null;
    private static Map<String, List<AnnotationDefinition>> annotationsByCategoryMap = null;
    private static Map<String, AnnotationDefinition> annotationClassNameToDefinitionMap;
    private static Map<String, AnnotationDefinition> annotationSimpleNameToDefinitionMap;
    private static Map<String, AnnotationDefinition> annotationQualifiedNameToDefinitionMap;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CATEGORY = "category";

    private AnnotationsManager() {
    }

    public static synchronized List<AnnotationDefinition> getAnnotations() {
        if (annotationCache == null) {
            annotationCache = new ArrayList<AnnotationDefinition>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_DEFINITION);
            if (extensionPoint != null) {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    if (element.getName().equals(ANNOTATION)) {
                        AnnotationDefinition annotationDefinition = new AnnotationDefinition(element, AnnotationsManager.getAnnotationCategory(AnnotationsManager.getAttributeValue(element, ATT_CATEGORY)));
                        annotationCache.add(annotationDefinition);
                    }
                    ++i;
                }
            }
        }
        return annotationCache;
    }

    public static List<Class<? extends Annotation>> getAnnotations(IJavaElement javaElement) {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        try {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAllAnnotationsForElement(javaElement);
            AnnotationsManager.filterAnnotationsList(javaElement, annotationDefinitions);
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotations.add(annotationDefinition.getAnnotationClass());
            }
        }
        catch (JavaModelException jme) {
            AnnotationsCorePlugin.log(jme.getStatus());
        }
        return annotations;
    }

    private static synchronized Map<String, AnnotationDefinition> getAnnotationToClassNameDefinitionMap() {
        if (annotationClassNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationClassNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                if (annotationDefinition.getAnnotationClass() == null) continue;
                annotationClassNameToDefinitionMap.put(annotationDefinition.getAnnotationClass().getCanonicalName(), annotationDefinition);
            }
        }
        return annotationClassNameToDefinitionMap;
    }

    private static synchronized Map<String, AnnotationDefinition> getSimpleNameToDefinitionMap() {
        if (annotationSimpleNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationSimpleNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotationSimpleNameToDefinitionMap.put(annotationDefinition.getName(), annotationDefinition);
            }
        }
        return annotationSimpleNameToDefinitionMap;
    }

    private static synchronized Map<String, AnnotationDefinition> getQualifiedNameToDefinitionMap() {
        if (annotationQualifiedNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationQualifiedNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotationQualifiedNameToDefinitionMap.put(annotationDefinition.getAnnotationClassName(), annotationDefinition);
            }
        }
        return annotationQualifiedNameToDefinitionMap;
    }

    public static AnnotationDefinition getAnnotationDefinitionForClass(Class<? extends Annotation> annotationClass) {
        return AnnotationsManager.getAnnotationToClassNameDefinitionMap().get(annotationClass.getCanonicalName());
    }

    public static AnnotationDefinition getAnnotationDefinitionForClass(String canonicalName) {
        return AnnotationsManager.getAnnotationToClassNameDefinitionMap().get(canonicalName);
    }

    public static IAnnotationAttributeInitializer getAnnotationAttributeInitializerForName(Name name) {
        if (name != null) {
            if (name.isSimpleName() && AnnotationsManager.getSimpleNameToDefinitionMap().containsKey(((SimpleName)name).getIdentifier())) {
                return AnnotationsManager.getSimpleNameToDefinitionMap().get(((SimpleName)name).getIdentifier()).getAnnotationAttributeInitializer();
            }
            if (name.isQualifiedName() && AnnotationsManager.getQualifiedNameToDefinitionMap().containsKey(name.getFullyQualifiedName())) {
                return AnnotationsManager.getQualifiedNameToDefinitionMap().get(name.getFullyQualifiedName()).getAnnotationAttributeInitializer();
            }
        }
        return null;
    }

    public static synchronized List<AnnotationDefinition> getAnnotationsByCategory(String categoryName) {
        if (annotationsByCategoryMap == null) {
            annotationsByCategoryMap = new HashMap<String, List<AnnotationDefinition>>();
            for (AnnotationDefinition annotationDefinition : AnnotationsManager.getAnnotations()) {
                List<AnnotationDefinition> annotationDefinitionList = annotationsByCategoryMap.get(annotationDefinition.getCategory());
                if (annotationDefinitionList == null) {
                    annotationDefinitionList = new ArrayList<AnnotationDefinition>();
                    annotationDefinitionList.add(annotationDefinition);
                    annotationsByCategoryMap.put(annotationDefinition.getCategory(), annotationDefinitionList);
                    continue;
                }
                annotationDefinitionList.add(annotationDefinition);
            }
        }
        return annotationsByCategoryMap.get(categoryName);
    }

    public static List<String> getAnnotationCategories() {
        return Arrays.asList(AnnotationsManager.getAnnotationCategoryCache().values().toArray(new String[AnnotationsManager.getAnnotationCategoryCache().size()]));
    }

    private static String getAnnotationCategory(String categoryId) {
        return AnnotationsManager.getAnnotationCategoryCache().get(categoryId);
    }

    private static synchronized Map<String, String> getAnnotationCategoryCache() {
        if (annotationCategoryCache != null) {
            return annotationCategoryCache;
        }
        annotationCategoryCache = new HashMap<String, String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_CATEGORY);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                annotationCategoryCache.put(AnnotationsManager.getAttributeValue(element, ATT_ID), AnnotationsManager.getAttributeValue(element, ATT_NAME));
                ++i;
            }
        }
        return annotationCategoryCache;
    }

    protected static synchronized Map<String, IConfigurationElement> getAnnotationInitializerCache() {
        if (annotationInitializerCache != null) {
            return annotationInitializerCache;
        }
        annotationInitializerCache = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_INITIALIZER);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                annotationInitializerCache.put(AnnotationsManager.getAttributeValue(element, ANNOTATION), element);
                ++i;
            }
        }
        return annotationInitializerCache;
    }

    public static synchronized Map<String, List<IConfigurationElement>> getAnnotationProcessorsCache() {
        if (annotationProcessorCache == null) {
            annotationProcessorCache = new HashMap<String, List<IConfigurationElement>>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_PROCESSOR);
            if (extensionPoint != null) {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    if (element.getName().equalsIgnoreCase("processor")) {
                        String annotationKey = AnnotationsManager.getAttributeValue(element, ANNOTATION);
                        List<IConfigurationElement> configurationElements = annotationProcessorCache.get(annotationKey);
                        if (configurationElements == null) {
                            configurationElements = new ArrayList<IConfigurationElement>();
                            configurationElements.add(element);
                            annotationProcessorCache.put(annotationKey, configurationElements);
                        } else {
                            configurationElements.add(element);
                        }
                    }
                    ++i;
                }
            }
        }
        return annotationProcessorCache;
    }

    static String getAttributeValue(IConfigurationElement configurationElement, String attributeName) {
        String attribute = configurationElement.getAttribute(attributeName);
        if (attribute != null) {
            return attribute;
        }
        return "";
    }

    private static List<AnnotationDefinition> getAllAnnotationsForElement(IJavaElement javaElement) throws JavaModelException {
        if (javaElement instanceof IPackageDeclaration) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.PACKAGE);
        }
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            if (type.isAnnotation()) {
                return AnnotationsManager.getAnnotationsForElementType(ElementType.ANNOTATION_TYPE);
            }
            return AnnotationsManager.getAnnotationsForElementType(ElementType.TYPE);
        }
        if (javaElement instanceof IField) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.FIELD);
        }
        if (javaElement instanceof IMethod) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.METHOD);
        }
        if (javaElement instanceof ILocalVariable) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.PARAMETER);
        }
        if (javaElement instanceof IAnnotation) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.ANNOTATION_TYPE);
        }
        return Collections.emptyList();
    }

    private static List<AnnotationDefinition> getAnnotationsForElementType(ElementType elementType) {
        ArrayList<AnnotationDefinition> annotationDefinitions = new ArrayList<AnnotationDefinition>();
        if (annotationCache == null) {
            AnnotationsManager.getAnnotations();
        }
        for (AnnotationDefinition annotationDefinition : annotationCache) {
            if (!annotationDefinition.getTargets().contains((Object)elementType) || AnnotationsManager.isDeprecated(annotationDefinition)) continue;
            annotationDefinitions.add(annotationDefinition);
        }
        return annotationDefinitions;
    }

    private static void filterAnnotationsList(IJavaElement javaElement, List<AnnotationDefinition> annotationDefinitions) throws JavaModelException {
        Iterator<AnnotationDefinition> annotationIter = annotationDefinitions.iterator();
        while (annotationIter.hasNext()) {
            IType type;
            AnnotationDefinition annotationDefinition = annotationIter.next();
            if (javaElement instanceof IType && (AnnotationsManager.isClassRestricted((IJavaElement)(type = (IType)javaElement), annotationDefinition) || AnnotationsManager.isInterfaceRestricted((IJavaElement)type, annotationDefinition) || AnnotationsManager.isEnumRestricted((IJavaElement)type, annotationDefinition))) {
                annotationIter.remove();
            }
            if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                if (method.isMainMethod()) {
                    annotationIter.remove();
                }
                if (method.isConstructor() && !annotationDefinition.getTargets().contains((Object)ElementType.CONSTRUCTOR)) {
                    annotationIter.remove();
                }
                if (AnnotationsManager.isClassRestricted((IJavaElement)method, annotationDefinition) || AnnotationsManager.isInterfaceRestricted((IJavaElement)method, annotationDefinition) || AnnotationsManager.isEnumRestricted((IJavaElement)method, annotationDefinition)) {
                    annotationIter.remove();
                }
            }
            if (!(javaElement instanceof IField) || !AnnotationsManager.isClassRestricted(javaElement, annotationDefinition) && !AnnotationsManager.isInterfaceRestricted(javaElement, annotationDefinition) && !AnnotationsManager.isEnumRestricted(javaElement, annotationDefinition)) continue;
            annotationIter.remove();
        }
    }

    private static boolean isClassRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isClass() && annotationDefinition.isClassOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isClass() && annotationDefinition.isClassOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isClass() && annotationDefinition.isClassOnly();
        }
        return false;
    }

    private static boolean isInterfaceRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isInterface() && annotationDefinition.isInterfaceOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isInterface() && annotationDefinition.isInterfaceOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isInterface() && annotationDefinition.isInterfaceOnly();
        }
        return false;
    }

    private static boolean isEnumRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isEnum() && annotationDefinition.isEnumOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isEnum() && annotationDefinition.isEnumOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isEnum() && annotationDefinition.isEnumOnly();
        }
        return false;
    }

    private static boolean isDeprecated(AnnotationDefinition annotationDefinition) {
        Class<? extends Annotation> annotationClass = annotationDefinition.getAnnotationClass();
        return annotationClass.getAnnotation(Deprecated.class) != null;
    }
}

