/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core.initialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultsAnnotationAttributeInitializer
extends AnnotationAttributeInitializer {
    @Override
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        return this.getMemberValuePairs(ast, annotationClass);
    }

    private List<MemberValuePair> getMemberValuePairs(AST ast, Class<? extends Annotation> annotationClass) {
        Method[] declaredMethods;
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        Method[] methodArray = declaredMethods = annotationClass.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            Object defaultValue = method.getDefaultValue();
            if (defaultValue != null) {
                if (returnType.equals(String.class)) {
                    memberValuePairs.add(AnnotationsCore.createStringMemberValuePair(ast, name, defaultValue.toString()));
                }
                if (returnType.equals(Boolean.TYPE)) {
                    memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair(ast, name, Boolean.parseBoolean(defaultValue.toString())));
                }
                if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
                    memberValuePairs.add(AnnotationsCore.createNumberMemberValuePair(ast, name, defaultValue.toString()));
                }
                if (returnType.isArray()) {
                    memberValuePairs.add(AnnotationsCore.createArrayMemberValuePair(ast, method.getName(), (Object[])defaultValue));
                }
                if (returnType.isEnum()) {
                    memberValuePairs.add(AnnotationsCore.createEnumMemberValuePair(ast, method.getDeclaringClass().getCanonicalName(), name, defaultValue));
                }
                if (returnType.equals(Class.class)) {
                    memberValuePairs.add(AnnotationsCore.createTypeMemberValuePair(ast, name, defaultValue));
                }
            }
            ++n2;
        }
        return memberValuePairs;
    }
}

