/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogListViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class CatalogSelectionPage
extends WizardPage {
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogListViewer viewer;

    public CatalogSelectionPage(MarketplaceCatalogConfiguration configuration) {
        super(CatalogSelectionPage.class.getName());
        this.configuration = configuration;
        this.setTitle(Messages.CatalogSelectionPage_solutionMarketplaceCatalog);
        this.setDescription(Messages.CatalogSelectionPage_selectASolutionCatalog);
        this.setPageComplete(configuration.getCatalogDescriptor() != null);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.viewer = new CatalogListViewer(container, 2048);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 200).applyTo((Control)this.viewer.getControl());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 == e2) {
                    return 0;
                }
                CatalogDescriptor descriptor1 = (CatalogDescriptor)e1;
                CatalogDescriptor descriptor2 = (CatalogDescriptor)e2;
                int i = super.compare(viewer, (Object)descriptor1.getLabel(), (Object)descriptor2.getLabel());
                if (i == 0) {
                    i = super.compare(viewer, (Object)descriptor1.getUrl().toString(), (Object)descriptor2.getUrl().toString());
                }
                return i;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CatalogSelectionPage.this.configuration.setCatalogDescriptor(selection.isEmpty() ? null : (CatalogDescriptor)selection.getFirstElement());
                CatalogSelectionPage.this.setPageComplete(CatalogSelectionPage.this.configuration.getCatalogDescriptor() != null);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == CatalogSelectionPage.this.configuration) {
                    return CatalogSelectionPage.this.configuration.getCatalogDescriptors().toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setInput((Object)this.configuration);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        MarketplaceClientUi.setDefaultHelp(this.getControl());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.configuration.getCatalogDescriptor() == null) {
                for (CatalogDescriptor descriptor : this.configuration.getCatalogDescriptors()) {
                    if (!descriptor.getUrl().getHost().endsWith(".eclipse.org")) continue;
                    this.configuration.setCatalogDescriptor(descriptor);
                    break;
                }
            }
            if (this.configuration.getCatalogDescriptor() != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.configuration.getCatalogDescriptor()));
                this.setPageComplete(true);
            }
        }
        super.setVisible(visible);
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }
}

