/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetDelegate;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetInstallDelegate
extends JavaFacetDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        JavaFacetInstallDelegate.validateEdit(project);
        JavaFacetInstallConfig config = JavaFacetInstallDelegate.castToConfig(cfg);
        IJavaProject jproject = null;
        if (project.exists()) {
            jproject = JavaCore.create((IProject)project);
        }
        if (!jproject.exists()) {
            ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>();
            for (IPath srcFolderPath : config.getSourceFolders()) {
                IFolder folder = project.getFolder(srcFolderPath);
                JavaFacetInstallDelegate.mkdirs(folder, false);
                cp.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
            }
            IPath defOutputPath = config.getDefaultOutputFolder();
            IFolder defOutputFolder = null;
            if (defOutputPath != null) {
                defOutputFolder = project.getFolder(config.getDefaultOutputFolder());
                JavaFacetInstallDelegate.mkdirs(defOutputFolder, true);
            }
            IProjectDescription desc = project.getDescription();
            String[] current = desc.getNatureIds();
            String[] replacement = new String[current.length + 1];
            System.arraycopy(current, 0, replacement, 0, current.length);
            replacement[current.length] = "org.eclipse.jdt.core.javanature";
            desc.setNatureIds(replacement);
            project.setDescription(desc, null);
            if (defOutputFolder == null) {
                jproject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
            } else {
                jproject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), defOutputFolder.getFullPath(), null);
            }
            JavaFacetUtil.resetClasspath(project, null, fv);
            JavaFacetUtil.setCompilerLevel(project, fv);
        } else {
            String oldCompilerLevel = JavaFacetUtil.getCompilerLevel(project);
            JavaFacetUtil.setCompilerLevel(project, fv);
            String newCompilerLevel = JavaFacetUtil.getCompilerLevel(project);
            if (newCompilerLevel != null && !newCompilerLevel.equals(oldCompilerLevel)) {
                JavaFacetUtil.scheduleFullBuild(project);
            }
        }
    }

    private static JavaFacetInstallConfig castToConfig(Object cfg) {
        if (cfg instanceof JavaFacetInstallConfig) {
            return (JavaFacetInstallConfig)((Object)cfg);
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (JavaFacetInstallConfig)((Object)manager.getAdapter(cfg, JavaFacetInstallConfig.class));
    }

    private static void mkdirs(IFolder folder, boolean isDerived) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                JavaFacetInstallDelegate.mkdirs((IFolder)parent, isDerived);
            }
            folder.create(true, true, null);
            folder.setDerived(isDerived);
        }
    }
}

