/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.jspel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOperatorExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.jspel.ELProblem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;

public class ELGeneratorVisitor
implements JSPELParserVisitor {
    private static final String ENDL = "\n";
    private static final String fExpressionHeader1 = "public String _elExpression";
    private static final String fExpressionHeader2 = "()\n\t\tthrows java.io.IOException, javax.servlet.ServletException, javax.servlet.jsp.JspException {\njavax.servlet.jsp.PageContext pageContext = null;\njava.util.Map param = null;\njava.util.Map paramValues = null;\njava.util.Map header = null;\njava.util.Map headerValues = null;\njava.util.Map cookie = null;\njava.util.Map initParam = null;\njava.util.Map pageScope = null;\njava.util.Map requestScope = null;\njava.util.Map sessionScope = null;\njava.util.Map applicationScope = null;\nreturn \"\"+";
    private static final String fExpressionHeader2_param = "()\n\t\tthrows java.io.IOException, javax.servlet.ServletException, javax.servlet.jsp.JspException {\njavax.servlet.jsp.PageContext pageContext = null;\njava.util.Map<String, String> param = null;\njava.util.Map<String, String[]> paramValues = null;\njava.util.Map<String, String> header = null;\njava.util.Map<String, String[]> headerValues = null;\njava.util.Map<String, javax.servlet.http.Cookie> cookie = null;\njava.util.Map<String, String> initParam = null;\njava.util.Map<String, Object> pageScope = null;\njava.util.Map<String, Object> requestScope = null;\njava.util.Map<String, Object> sessionScope = null;\njava.util.Map<String, Object> applicationScope = null;\nreturn \"\"+";
    private static final String[] fJspImplicitObjects = new String[]{"pageContext"};
    private static final String[] fJspImplicitMaps = new String[]{"param", "paramValues", "header", "headerValues", "cookie", "initParam", "pageScope", "requestScope", "sessionScope", "applicationScope"};
    private static final HashMap fJSPImplicitObjectMap = new HashMap(fJspImplicitObjects.length);
    private static final String fFooter = " ;\n}\n";
    private StringBuffer fResult;
    private Map fCodeMap;
    private int fOffsetInUserCode;
    private static int methodCounter;
    private IStructuredDocument fDocument = null;
    private int fContentStart;
    private static Map fOperatorMap;
    private int fGeneratedFunctionStart;
    private boolean fCanGenerate = true;
    private IStructuredDocumentRegion fCurrentNode;
    private boolean fUseParameterizedTypes;
    private List fELProblems;

    static {
        int i = 0;
        while (i < fJspImplicitObjects.length) {
            fJSPImplicitObjectMap.put(fJspImplicitObjects[i], new Boolean(true));
            ++i;
        }
        i = 0;
        while (i < fJspImplicitMaps.length) {
            fJSPImplicitObjectMap.put(fJspImplicitMaps[i], new Boolean(false));
            ++i;
        }
        methodCounter = 0;
        fOperatorMap = new HashMap();
        fOperatorMap.put("gt", ">");
        fOperatorMap.put("lt", "<");
        fOperatorMap.put("ge", ">=");
        fOperatorMap.put("le", "<=");
        fOperatorMap.put("mod", "%");
        fOperatorMap.put("eq", "==");
        fOperatorMap.put("and", "&&");
        fOperatorMap.put("or", "||");
        fOperatorMap.put("not", "!");
    }

    public ELGeneratorVisitor(StringBuffer result, IStructuredDocumentRegion currentNode, Map codeMap, IStructuredDocument document, ITextRegionCollection jspReferenceRegion, int contentStart) {
        this.fResult = result;
        this.fCodeMap = codeMap;
        this.fOffsetInUserCode = result.length();
        this.fContentStart = contentStart;
        this.fDocument = document;
        this.fCurrentNode = currentNode;
        this.fGeneratedFunctionStart = -1;
        this.fUseParameterizedTypes = this.compilerSupportsParameterizedTypes();
        this.fELProblems = new ArrayList();
    }

    private void append(Token token) {
        this.append(token.image, token.beginColumn - 1, token.endColumn);
    }

    private void append(String translated, Token token) {
        this.append(translated, token.beginColumn - 1, token.endColumn);
    }

    private void append(String newText, int jspPositionStart, int jspPositionEnd) {
        this.fResult.append(newText);
        Position javaRange = new Position(this.fOffsetInUserCode, newText.length());
        Position jspRange = new Position(this.fContentStart + jspPositionStart, jspPositionEnd - jspPositionStart);
        this.fCodeMap.put(javaRange, jspRange);
        this.fOffsetInUserCode += newText.length();
    }

    private void append(String newText) {
        this.fResult.append(newText);
        this.fOffsetInUserCode += newText.length();
    }

    protected String genFunction(String fullFunctionName) {
        TLDCMDocumentManager docMgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fDocument);
        int colonIndex = fullFunctionName.indexOf(58);
        String prefix = fullFunctionName.substring(0, colonIndex);
        String functionName = fullFunctionName.substring(colonIndex + 1);
        if (docMgr == null) {
            return null;
        }
        Iterator taglibs = docMgr.getCMDocumentTrackers(this.fCurrentNode.getStartOffset()).iterator();
        while (taglibs.hasNext()) {
            TaglibTracker tracker = (TaglibTracker)taglibs.next();
            if (!tracker.getPrefix().equals(prefix)) continue;
            CMDocumentImpl doc = (CMDocumentImpl)tracker.getDocument();
            List functions = doc.getFunctions();
            Iterator it = functions.iterator();
            while (it.hasNext()) {
                TLDFunction function = (TLDFunction)it.next();
                if (!function.getName().equals(functionName)) continue;
                String javaFuncName = ELGeneratorVisitor.getFunctionNameFromSignature(function.getSignature());
                if (javaFuncName == null) {
                    javaFuncName = functionName;
                }
                return String.valueOf(function.getClassName()) + "." + javaFuncName;
            }
        }
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept(this, data);
    }

    static synchronized int getMethodCounter() {
        return methodCounter++;
    }

    public Object visit(ASTExpression node, Object data) {
        return node.childrenAccept(this, data);
    }

    public void startFunctionDefinition(int start) {
        this.fGeneratedFunctionStart = this.fResult.length();
        this.append(fExpressionHeader1, start, start);
        this.append(Integer.toString(ELGeneratorVisitor.getMethodCounter()), start, start);
        if (this.fUseParameterizedTypes) {
            this.append(fExpressionHeader2_param, start, start);
        } else {
            this.append(fExpressionHeader2, start, start);
        }
    }

    public void endFunctionDefinition(int end) {
        if (this.fGeneratedFunctionStart < 0) {
            throw new IllegalStateException("Cannot end function definition because none has been started.");
        }
        this.append(fFooter, end, end);
        if (!this.fCanGenerate) {
            this.fResult.delete(this.fGeneratedFunctionStart, this.fResult.length());
            this.fOffsetInUserCode = this.fResult.length();
            Iterator it = this.fCodeMap.entrySet().iterator();
            while (it.hasNext()) {
                Position pos;
                Map.Entry entry = it.next();
                if (!(entry.getKey() instanceof Position) || (pos = (Position)entry.getKey()).getOffset() < this.fGeneratedFunctionStart) continue;
                it.remove();
            }
        }
        this.fGeneratedFunctionStart = -1;
    }

    private boolean compilerSupportsParameterizedTypes() {
        if (this.fDocument != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath location = TaglibController.getLocation((IDocument)this.fDocument);
            if (location != null && location.segmentCount() > 0) {
                IJavaProject project = JavaCore.create((IProject)root.getProject(location.segment(0)));
                String compliance = project.getOption("org.eclipse.jdt.core.compiler.source", true);
                try {
                    return (double)Float.parseFloat(compliance) >= 1.5;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return false;
    }

    private void generateOperatorNode(ASTOperatorExpression node, Object data) {
        int i = 0;
        while (i < node.children.length) {
            node.children[i].jjtAccept(this, data);
            if (node.children.length - i > 1) {
                this.appendOperator((Token)node.getOperatorTokens().get(i));
            }
            ++i;
        }
    }

    private String appendOperator(Token token) {
        String tokenImage = token.image.trim();
        String translated = (String)fOperatorMap.get(tokenImage);
        if (translated != null) {
            this.append(translated, token);
        } else {
            this.append(token);
        }
        return translated;
    }

    public Object visit(ASTOrExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTAndExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTAddExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        node.children[0].jjtAccept(this, data);
        this.append("?");
        node.children[1].jjtAccept(this, data);
        this.append(":");
        node.children[2].jjtAccept(this, data);
        return null;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        if (45 == node.firstToken.kind) {
            this.append("((null == ");
            node.childrenAccept(this, data);
            this.append(") || (");
            node.childrenAccept(this, data);
            this.append(").isEmpty())");
        } else if (39 == node.firstToken.kind || 40 == node.firstToken.kind) {
            this.append("(!");
            node.childrenAccept(this, data);
            this.append(")");
        } else if (33 == node.firstToken.kind) {
            this.append("(-");
            node.childrenAccept(this, data);
            this.append(")");
        } else {
            node.childrenAccept(this, data);
        }
        return null;
    }

    public Object visit(ASTValue node, Object data) {
        if (node.jjtGetNumChildren() >= 2 && node.jjtGetChild(0) instanceof ASTValuePrefix && node.jjtGetChild(1) instanceof ASTValueSuffix) {
            ASTValuePrefix prefix = (ASTValuePrefix)node.jjtGetChild(0);
            ASTValueSuffix suffix = (ASTValueSuffix)node.jjtGetChild(1);
            if (prefix.firstToken.image.equals("pageContext") && suffix.getPropertyNameToken() != null && suffix.getPropertyNameToken().image.equals("request")) {
                this.append("((HttpServletRequest)");
            }
        }
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTValuePrefix node, Object data) {
        if (node.children == null) {
            if (this.isCompletingObject(node.firstToken.image)) {
                this.append(node.firstToken);
            } else {
                this.fCanGenerate = false;
            }
            return null;
        }
        return node.childrenAccept(this, data);
    }

    private boolean isCompletingObject(String image) {
        Boolean value = (Boolean)fJSPImplicitObjectMap.get(image);
        return value == null ? false : value;
    }

    public Object visit(ASTValueSuffix node, Object data) {
        if (30 == node.firstToken.kind) {
            this.fCanGenerate = false;
        } else if (node.getPropertyNameToken() != null) {
            Token suffix = node.getPropertyNameToken();
            String ucaseName = String.valueOf(suffix.image.substring(0, 1).toUpperCase()) + suffix.image.substring(1, suffix.image.length());
            this.append(node.firstToken);
            this.append("get" + ucaseName + "()", suffix);
            SimpleNode parent = (SimpleNode)node.jjtGetParent();
            if (suffix.image.equals("request") && parent instanceof ASTValue && parent.jjtGetParent() instanceof ASTUnaryExpression && parent.firstToken.image.equals("pageContext")) {
                this.append(")");
            }
        } else if (node.getLastToken().image.equals(".") && node.getLastToken().next.image.equals("")) {
            this.append(node.firstToken);
            this.append("get()", node.getLastToken().beginColumn, node.getLastToken().beginColumn);
        } else {
            this.append(node.firstToken);
        }
        return null;
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        String functionTranslation = this.genFunction(node.getFullFunctionName());
        if (functionTranslation != null) {
            Token jspFuncNameToken = this.getJSPFuncNameToken(node);
            int indexOfDot = functionTranslation.lastIndexOf(46);
            if (indexOfDot != -1) {
                String funcClass = functionTranslation.substring(0, indexOfDot + 1);
                String funcName = functionTranslation.substring(indexOfDot + 1);
                this.append(funcClass, jspFuncNameToken);
                this.append(funcName, jspFuncNameToken);
            } else {
                this.append(functionTranslation, jspFuncNameToken);
            }
            this.append("(");
            if (node.children != null) {
                int i = 0;
                while (i < node.children.length) {
                    node.children[i].jjtAccept(this, data);
                    if (node.children.length - i > 1) {
                        this.append(",");
                    }
                    ++i;
                }
            }
            this.append(")");
        } else {
            int problemOffset = this.fContentStart + node.getFirstToken().beginColumn - 1;
            int problemLength = node.getLastToken().endColumn - 1;
            this.fELProblems.add(new ELProblem(new Position(problemOffset, problemLength), NLS.bind((String)JSPCoreMessages.JSPELTranslator_0, (Object)node.getFullFunctionName())));
            String errorMsg = "\"Could not find function translation for: " + node.getFullFunctionName() + "\"";
            this.append(errorMsg);
        }
        return null;
    }

    public List getELProblems() {
        return this.fELProblems;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (ELGeneratorVisitor.isSingleQuotedStringLiteral(node)) {
            String image = node.firstToken.image;
            node.firstToken.image = image = "\"" + image.substring(1, image.length() - 1) + "\"";
        }
        this.append(node.firstToken);
        return null;
    }

    private static boolean isSingleQuotedStringLiteral(ASTLiteral node) {
        String content = node.firstToken.image;
        return content.length() > 1 && content.startsWith("'") && content.endsWith("'");
    }

    private static String getFunctionNameFromSignature(String methodSignature) {
        int length = methodSignature.length();
        char c = '\u0000';
        int identifierStart = -1;
        int whitespaceStart = -1;
        int i = 0;
        while (i < length) {
            c = methodSignature.charAt(i);
            if (Character.isJavaIdentifierPart(c) && whitespaceStart >= identifierStart) {
                identifierStart = i;
            } else if (Character.isWhitespace(c)) {
                whitespaceStart = i;
            } else if (c == '(' && identifierStart >= 0) {
                return methodSignature.substring(identifierStart, i).trim();
            }
            ++i;
        }
        return null;
    }

    private Token getJSPFuncNameToken(ASTFunctionInvocation funcInvo) {
        Token funcNameToken = funcInvo.getFirstToken();
        Token temp = funcInvo.getFirstToken();
        do {
            if (!temp.image.equals(":")) continue;
            funcNameToken = temp.next;
        } while (temp.next != null && funcNameToken == null);
        return funcNameToken;
    }
}

