/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceSingletonObjectManager<MANAGEDOBJECT extends IManagedObject, RESOURCE extends IResource>
extends ObjectManager<MANAGEDOBJECT, RESOURCE> {
    private LifecycleListener _lifecycleListener;
    final Map<RESOURCE, ManagedResourceObject<MANAGEDOBJECT>> _perResourceObjects;
    private final IWorkspace _workspace;

    protected ResourceSingletonObjectManager(IWorkspace workspace) {
        this._workspace = workspace;
        this._perResourceObjects = new HashMap<RESOURCE, ManagedResourceObject<MANAGEDOBJECT>>();
    }

    protected final IWorkspace getWorkspace() {
        return this._workspace;
    }

    protected final Map<RESOURCE, ManagedResourceObject<MANAGEDOBJECT>> getPerResourceObjects() {
        return Collections.unmodifiableMap(this._perResourceObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MANAGEDOBJECT getInstance(RESOURCE key) throws ObjectManager.ManagedObjectException {
        this.assertNotDisposed();
        ResourceSingletonObjectManager resourceSingletonObjectManager = this;
        synchronized (resourceSingletonObjectManager) {
            this.runBeforeGetInstance(key);
            ManagedResourceObject managedResObject = this._perResourceObjects.get(key);
            if (managedResObject == null) {
                MANAGEDOBJECT managedObject = this.createNewInstance(key);
                if (managedObject == null) {
                    throw new ObjectManager.ManagedObjectException("No object available for resource");
                }
                managedResObject = this.manageResource(key, managedObject);
            }
            this.runAfterGetInstance(key);
            return managedResObject.getManagedObject();
        }
    }

    protected abstract MANAGEDOBJECT createNewInstance(RESOURCE var1);

    protected void runBeforeGetInstance(RESOURCE resource) {
    }

    protected void runAfterGetInstance(RESOURCE resource) {
    }

    public synchronized boolean isInstance(RESOURCE resource) {
        this.assertNotDisposed();
        return this._perResourceObjects.containsKey(resource);
    }

    public synchronized Collection<RESOURCE> getManagedResources() {
        this.assertNotDisposed();
        return new HashSet<RESOURCE>(this._perResourceObjects.keySet());
    }

    private synchronized ManagedResourceObject manageResource(RESOURCE resource, MANAGEDOBJECT managedObject) {
        LifecycleListener listener = this.lazilyGetLifecycleListener();
        listener.addResource((IResource)resource);
        MyLifecycleEventListener eventListener = new MyLifecycleEventListener(this, (IManagedObject)managedObject, (IResource)resource, null);
        listener.addListener(eventListener);
        ManagedResourceObject managedResourceObject = new ManagedResourceObject((IManagedObject)managedObject, eventListener, null);
        this._perResourceObjects.put(resource, managedResourceObject);
        return managedResourceObject;
    }

    protected final synchronized MANAGEDOBJECT unmanageResource(RESOURCE resource) {
        ManagedResourceObject<MANAGEDOBJECT> managedResourceObject = this._perResourceObjects.remove(resource);
        LifecycleListener listener = this.lazilyGetLifecycleListener();
        if (managedResourceObject != null) {
            listener.removeListener(managedResourceObject.getEventListener());
        }
        listener.removeResource((IResource)resource);
        return managedResourceObject.getManagedObject();
    }

    protected final void addLifecycleEventListener(IResourceLifecycleListener listener) {
        this.assertNotDisposed();
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.addListener(listener);
    }

    protected final void removeLifecycleEventListener(IResourceLifecycleListener listener) {
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.removeListener(listener);
    }

    protected final void addResource(IResource res) {
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.addResource(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeResource(IResource res) {
        ResourceSingletonObjectManager resourceSingletonObjectManager = this;
        synchronized (resourceSingletonObjectManager) {
            if (this._perResourceObjects.keySet().contains(res)) {
                throw new IllegalArgumentException("Can't remove managed resources with this method");
            }
        }
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.removeResource(res);
    }

    private synchronized LifecycleListener lazilyGetLifecycleListener() {
        if (this._lifecycleListener == null) {
            this._lifecycleListener = new LifecycleListener(this._workspace);
        }
        return this._lifecycleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            ResourceSingletonObjectManager resourceSingletonObjectManager = this;
            synchronized (resourceSingletonObjectManager) {
                HashMap<RESOURCE, ManagedResourceObject<MANAGEDOBJECT>> copy = new HashMap<RESOURCE, ManagedResourceObject<MANAGEDOBJECT>>(this.getPerResourceObjects());
                for (Map.Entry entry : copy.entrySet()) {
                    IResource res = (IResource)entry.getKey();
                    MANAGEDOBJECT unmanagedResource = this.unmanageResource(res);
                    unmanagedResource.checkpoint();
                    unmanagedResource.dispose();
                }
                this._perResourceObjects.clear();
                if (this._lifecycleListener != null) {
                    this._lifecycleListener.dispose();
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void checkpoint() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ManagedResourceObject<MANAGEDOBJECT extends IManagedObject> {
        private final MANAGEDOBJECT _managedObject;
        private final MyLifecycleEventListener _eventListener;

        private ManagedResourceObject(MANAGEDOBJECT managedObject, MyLifecycleEventListener eventListener) {
            this._managedObject = managedObject;
            this._eventListener = eventListener;
        }

        public MANAGEDOBJECT getManagedObject() {
            return this._managedObject;
        }

        public MyLifecycleEventListener getEventListener() {
            return this._eventListener;
        }

        /* synthetic */ ManagedResourceObject(IManagedObject iManagedObject, MyLifecycleEventListener myLifecycleEventListener, ManagedResourceObject managedResourceObject) {
            this(iManagedObject, myLifecycleEventListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyLifecycleEventListener<RESOURCE extends IResource, MANAGEDOBJECT extends IManagedObject>
    implements IResourceLifecycleListener {
        private final RESOURCE _resource;
        private final MANAGEDOBJECT _managedObject;
        private final ResourceSingletonObjectManager<MANAGEDOBJECT, RESOURCE> _target;

        private MyLifecycleEventListener(ResourceSingletonObjectManager<MANAGEDOBJECT, RESOURCE> target, MANAGEDOBJECT managedObject, RESOURCE resource) {
            this._resource = resource;
            this._managedObject = managedObject;
            this._target = target;
        }

        @Override
        public EventResult acceptEvent(ResourceLifecycleEvent event) {
            EventResult result = EventResult.getDefaultEventResult();
            if (!this._resource.equals(event.getAffectedResource())) {
                return EventResult.getDefaultEventResult();
            }
            if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                try {
                    if (event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED || event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED) {
                        this._managedObject.destroy();
                    } else {
                        this._managedObject.dispose();
                    }
                }
                finally {
                    this._target.unmanageResource(this._resource);
                }
            }
            return result;
        }

        /* synthetic */ MyLifecycleEventListener(ResourceSingletonObjectManager resourceSingletonObjectManager, IManagedObject iManagedObject, IResource iResource, MyLifecycleEventListener myLifecycleEventListener) {
            this(resourceSingletonObjectManager, iManagedObject, iResource);
        }
    }
}

