/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pattern;

import com.ibm.pattern.Pool;
import java.util.List;
import java.util.Vector;

public abstract class AbstractPool
implements Pool {
    private Object poolLock = new Object();
    private List poolList = null;
    private static final long DEFAULT_MINIMUM_SIZE = 10L;
    private static final long DEFAULT_PREFERRED_SIZE = 20L;
    private static final long DEFAULT_MAXIMUM_SIZE = 100L;

    protected AbstractPool() {
        this(new Vector());
    }

    protected AbstractPool(List list) {
        this.poolList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getMinimumSize() >= this.getSize()) {
                this.grow();
            }
            return this.getList().remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws IllegalArgumentException {
        if (this.acceptObject(object) && this.getMaximumSize() > this.getSize()) {
            Object object2 = this.getLock();
            synchronized (object2) {
                this.getList().add(object);
            }
        }
    }

    protected abstract Object createObject();

    protected void destroyObject(Object object) {
    }

    protected boolean acceptObject(Object object) throws IllegalArgumentException {
        return null != object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grow() {
        Object object = this.getLock();
        synchronized (object) {
            while (this.getPreferredSize() > this.getSize()) {
                this.getList().add(this.createObject());
            }
        }
    }

    protected List getList() {
        return this.poolList;
    }

    protected Object getLock() {
        return this.poolLock;
    }

    protected long getSize() {
        return this.getList().size();
    }

    protected long getMinimumSize() {
        return 10L;
    }

    protected long getMaximumSize() {
        return 100L;
    }

    protected long getPreferredSize() {
        return 20L;
    }
}

