/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus.ps2;

import com.ibm.poskbd.Leds;
import com.ibm.poskbd.bus.KeyboardAbstraction;
import com.ibm.poskbd.bus.KeyboardImp;
import com.ibm.poskbd.bus.ps2.PS2FunctionImp;
import com.ibm.poskbd.bus.ps2.PS2SnifferProxy;
import com.ibm.poskbd.bus.ps2.PosKbd;

public class PS2KeyboardImp
implements KeyboardImp {
    private KeyboardAbstraction keyboardAbstraction = null;
    private PS2SnifferProxy ps2SnifferProxy = null;
    private PS2FunctionImp ps2FunctionImp = null;

    public KeyboardAbstraction getKeyboardAbstraction() {
        return this.keyboardAbstraction;
    }

    public Leds getLeds() {
        return PosKbd.getLeds();
    }

    public void setLeds(Leds leds) {
        PosKbd.setLeds(leds);
    }

    public void setEnable(boolean value) {
        this.ps2SnifferProxy.setEnable(value);
    }

    public void fireScancode(byte scancode) {
        this.getKeyboardAbstraction().fireScancodeEvent(scancode);
    }

    boolean init(int[] validKbds, int[] validKbdsByVendor, int[] validKbdsByProduct) {
        this.keyboardAbstraction = new KeyboardAbstraction(this);
        this.ps2FunctionImp = new PS2FunctionImp();
        if (!PosKbd.loadLib()) {
            return false;
        }
        this.ps2FunctionImp.init(this.keyboardAbstraction);
        this.ps2SnifferProxy = new PS2SnifferProxy(this);
        this.ps2SnifferProxy.setValidKbds(validKbds);
        this.ps2SnifferProxy.setValidKbdsByVendorProduct(validKbdsByVendor, validKbdsByProduct);
        if (!this.ps2SnifferProxy.start()) {
            this.ps2FunctionImp.stop();
            return false;
        }
        return true;
    }

    void stop() {
        this.ps2SnifferProxy.stop();
        this.ps2FunctionImp.stop();
        this.getKeyboardAbstraction().fireKeyboardDisconnectedEvent();
    }

    PS2FunctionImp getPS2FunctionImp() {
        return this.ps2FunctionImp;
    }
}

