/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus.ps2;

import com.ibm.poskbd.bus.ps2.PS2ProxyThread;

public abstract class PS2Proxy {
    protected PS2ProxyThread thread = null;

    public boolean isRunning() {
        try {
            return this.thread.isRunning();
        }
        catch (NullPointerException npE) {
            return false;
        }
    }

    public synchronized boolean start() {
        if (null != this.thread && this.thread.isRunning()) {
            return true;
        }
        this.thread = new PS2ProxyThread(this.getProxyRunnable());
        try {
            this.thread.setDaemon(true);
            this.thread.setName(this.getProxyName());
            return this.thread.startAndWait();
        }
        catch (IllegalThreadStateException itsE) {
            this.thread = null;
            throw new RuntimeException("This should not happen :\nIllegalThreadStateException while initializing new PS2Proxy.ProxyThread : " + itsE.getMessage());
        }
        catch (SecurityException sE) {
            this.thread = null;
            throw new RuntimeException("This should not happen :\nSecurityException while initializing new PS2Proxy.ProxyThread : " + sE.getMessage());
        }
    }

    public synchronized void stop() {
        if (null != this.thread) {
            this.thread.stopRunning();
        }
    }

    protected abstract String getProxyName();

    protected abstract Runnable getProxyRunnable();
}

