/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.util.JposEntryInfo;
import java.lang.reflect.Constructor;
import jpos.JposException;

public class ImpFactory {
    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        JposEntryInfo jposEntryInfo = deviceServiceAbstraction.getDeviceServiceState().getJposEntryInfo();
        String string = jposEntryInfo.getImpClassName();
        Class<?> clazz = null;
        try {
            if (string != null) {
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG);
        }
        Constructor constructor = ImpFactory.lookForValidImpConstructor(clazz);
        if (constructor == null) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
        }
        DeviceServiceImp deviceServiceImp = null;
        Object[] objectArray = new Object[]{deviceServiceAbstraction};
        try {
            deviceServiceImp = (DeviceServiceImp)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG);
        }
        return deviceServiceImp;
    }

    private static Constructor lookForValidImpConstructor(Class clazz) {
        Constructor<?>[] constructorArray = null;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (constructorArray == null || constructorArray.length == 0) {
            return null;
        }
        Constructor<?> constructor = null;
        int n = 0;
        while (n < constructorArray.length) {
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            if (classArray.length == 1 && classArray[0].getName().equals("com.ibm.jpos.services.DeviceServiceAbstraction")) {
                constructor = constructorArray[n];
                break;
            }
            ++n;
        }
        return constructor;
    }
}

