/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.jcomm.Serial4610Const;
import com.ibm.jpos.services.jcomm.Serial4610Device;
import com.ibm.jpos.services.jcomm.Serial4610ImpFactory;
import com.ibm.jpos.util.Tracer;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.services.EventCallbacks;

public abstract class Serial4610DeviceServiceImp
implements DeviceServiceImp,
JposConst,
Serial4610Const {
    private static final String className = "Serial4610DeviceServiceImp";
    private DeviceServiceAbstraction dsAbstraction = null;
    private DeviceServiceState serviceState = null;
    private String logicalName = null;
    private EventCallbacks eventCallbacks = null;
    private Serial4610Device serial4610Device = new Serial4610Device();
    private JposEntry jposEntry = null;

    protected Serial4610DeviceServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        Tracer.trace(4, className, "Serial4610DeviceServiceImp()", "Entry");
        if (deviceServiceAbstraction == null) {
            throw new JposException(111, "Serial4610DeviceServiceImp::Serial4610DeviceServiceImp: dsAbstraction == null");
        }
        this.dsAbstraction = deviceServiceAbstraction;
        this.serviceState = deviceServiceAbstraction.getDeviceServiceState();
        this.jposEntry = this.serviceState.getJposEntryInfo().getJposEntry();
        this.logicalName = this.serviceState.getJposEntryInfo().getLogicalName();
        Tracer.trace(4, className, "Serial4610DeviceServiceImp()", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        Tracer.trace(4, className, "deleteImp()", "Entry");
        Tracer.trace(4, className, "deleteImp()", "Exit");
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        Tracer.trace(4, className, "createImp()", "Entry");
        ServiceInstanceImp serviceInstanceImp = Serial4610ImpFactory.createImp(deviceServiceAbstraction);
        Tracer.trace(4, className, "createImp()", "Exit");
        return serviceInstanceImp;
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled()", "Entry");
        try {
            if (bl) {
                this.serial4610Device.unlock();
            } else {
                this.serial4610Device.lock();
            }
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "JPOS_E_FAILURE", exception);
        }
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    public void setFreezeEvents(boolean bl) throws JposException {
        Tracer.trace(4, className, "freezeEvents()", "Entry");
        Tracer.trace(4, className, "freezeEvents()", "Exit");
    }

    public void setPowerNotify(int n) throws JposException {
        Tracer.trace(4, className, "setPowerNotify(" + Integer.toString(n) + ")", "Entry");
        Tracer.trace(4, className, "setPowerNotify()", "Exit");
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + Integer.toString(n) + ")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        Tracer.trace(4, className, "claim()", "Exit");
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(\"" + string + "\")", "Entry");
        this.serial4610Device.open(this.jposEntry);
        Tracer.trace(4, className, "open()", "Exit");
    }

    public synchronized void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        this.serial4610Device.close();
        Tracer.trace(4, className, "close()", "Exit");
    }

    public void checkHealth(int n) throws JposException {
        Tracer.trace(4, className, "checkHealth()", "Entry");
        switch (n) {
            case 1: {
                if (this.isOnline()) {
                    this.serviceState.setCheckHealthText("Internal HCheck: Successful");
                    break;
                }
                this.serviceState.setCheckHealthText("Internal HCheck: Not Responding");
                throw new JposException(108);
            }
            case 2: {
                if (this.isOnline()) {
                    this.serviceState.setCheckHealthText("External HCheck: Successful");
                    break;
                }
                this.serviceState.setCheckHealthText("External HCheck: Not Responding");
                throw new JposException(108);
            }
            case 3: {
                this.serviceState.setCheckHealthText("");
                throw new JposException(106);
            }
            default: {
                this.serviceState.setCheckHealthText("");
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "checkHealth()", "Exit");
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        Tracer.trace(4, className, "directIO(" + Integer.toString(n) + ", ...)", "Entry");
        Tracer.trace(4, className, "directIO()", "Exit");
    }

    public void release() throws JposException {
        Tracer.trace(4, className, "release", "Entry");
        this.serial4610Device.lock();
        Tracer.trace(4, className, "release", "Exit");
    }

    public DeviceServiceAbstraction getDeviceServiceAbstraction() {
        return this.dsAbstraction;
    }

    protected DeviceServiceState getDeviceServiceState() {
        return this.serviceState;
    }

    protected EventQueueManager getEventQueueManager() throws JposException {
        return this.dsAbstraction.getEventQueueManager();
    }

    protected final JposEntry getJposEntry() {
        return this.jposEntry;
    }

    protected final String getLogicalName() {
        return this.logicalName;
    }

    protected final EventCallbacks getEventCallbacks() {
        return this.eventCallbacks;
    }

    public synchronized boolean isOnline() {
        return this.serial4610Device.isOnline();
    }

    protected final Serial4610Device getSerial4610Device() {
        return this.serial4610Device;
    }
}

