/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import java.util.Enumeration;
import java.util.Vector;
import jpos.JposException;
import jpos.POSPrinterConst;

public class Serial4610PrintDataCompiler
extends PrintDataCompiler
implements POSPrinterConst {
    private static final String className = "Serial4610PrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;
    private PrintBitmapUtil bitmapUtil = null;
    private PrinterFont[] printerFonts = null;
    private PrinterFont printerFont = null;
    private boolean inverted = false;
    private Vector setBitmapDataVector = new Vector();
    protected int currentHorizontalScale = 1;
    protected int currentVerticalScale = 1;
    private int printerMode = 0;

    Serial4610PrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    public void validate(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        this.bitmapUtil = printBitmapUtil;
        this.printerFonts = printerFontArray;
        super.validate(n, string, n2);
    }

    public byte[] compile(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        this.bitmapUtil = printBitmapUtil;
        this.printerFonts = printerFontArray;
        return super.compile(n, string, n2);
    }

    public PrinterFont getSelectedPrinterFont() {
        return this.selectedPrinterFont;
    }

    protected boolean isInverted() {
        return this.inverted;
    }

    protected void setInverted(boolean bl) {
        this.inverted = bl;
    }

    protected PrintBitmapUtil getPrintBitmapUtil() {
        return this.bitmapUtil;
    }

    protected PrinterFont[] getPrinterFonts() {
        return this.printerFonts;
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getPrologueBytes()", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = this.getStation();
        String string = "";
        int n2 = 0;
        int n3 = -1;
        switch (n) {
            case 1: {
                string = "JrnLineChars";
                n2 = this.getServiceState().getJrnLineChars();
                break;
            }
            case 2: {
                string = "RecLineChars";
                n2 = this.getServiceState().getRecLineChars();
                break;
            }
            case 4: {
                string = "SlpLineChars";
                n2 = this.getServiceState().getSlpLineChars();
                break;
            }
            default: {
                throw new JposException(111);
            }
        }
        Tracer.trace(4, className, "getPrologueBytes()", string + " == " + n2);
        int n4 = 0;
        while (n4 < printerFontArray.length) {
            if (printerFontArray[n4].station == n) {
                if (printerFontArray[n4].lineChars == n2) {
                    n3 = n4;
                    break;
                }
                if (printerFontArray[n4].lineChars > n2 && (n3 == -1 || printerFontArray[n3].lineChars > printerFontArray[n4].lineChars)) {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (n3 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n3];
        block5 : switch (n) {
            case 4: {
                if (this.selectedPrinterFont.diWidth == 0) {
                    byteBuffer.append(27).append(36).append(0).append(0);
                } else if (this.selectedPrinterFont.fontType == 2) {
                    byteBuffer.append(27).append(36).append(0).append(72);
                } else {
                    byteBuffer.append(27).append(36).append(0).append(90);
                }
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using spread font");
                        break block5;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using normal font");
                        break block5;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                        break block5;
                    }
                    case 5: {
                        byteBuffer.append(27).append(82).append(6);
                        break block5;
                    }
                }
                Tracer.trace(4, className, "getPrologueBytes()", "non-supported font");
                throw new JposException(106);
            }
            case 2: {
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(5);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using spread font");
                        break block5;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using normal font");
                        break block5;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                        break block5;
                    }
                    case 4: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(1, false);
                        this.setPrinterMode(2, true);
                        Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                        break block5;
                    }
                }
                Tracer.trace(4, className, "getPrologueBytes()", "non-supported font");
                throw new JposException(106);
            }
            default: {
                Tracer.trace(4, className, "getPrologueBytes()", "non-supported station");
                throw new JposException(106);
            }
        }
        byteBuffer.append(27).append(33).append(this.getPrinterMode());
        switch (this.getRotation()) {
            case 257: {
                this.reverseText();
                this.setInverted(true);
                this.setPrinterMode(64, true);
                byteBuffer.append(27).append(33).append(this.getPrinterMode());
                break;
            }
            case 258: {
                this.reverseLines();
                this.setInverted(false);
                this.setPrinterMode(64, false);
                byteBuffer.append(27).append(33).append(this.getPrinterMode());
                byteBuffer.append(27).append(99).append(48).append(8);
                break;
            }
            case 259: {
                this.reverseText();
                this.reverseLines();
                this.setInverted(true);
                this.setPrinterMode(64, true);
                byteBuffer.append(27).append(33).append(this.getPrinterMode());
                break;
            }
            default: {
                this.setInverted(false);
                this.setPrinterMode(64, false);
                byteBuffer.append(27).append(33).append(this.getPrinterMode());
            }
        }
        Tracer.trace(4, className, "getPrologueBytes()", "Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getNewlineBytes() {
        return new byte[]{13, 10};
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        if (this.getStation() != 2) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return new byte[0];
        }
        byte[] byArray = this.getFeedAndPaperCutBytes(n);
        byte[] byArray2 = this.getFireStampBytes();
        int n2 = byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray3[n3] = n3 < byArray.length ? byArray[n3] : byArray2[n3 - byArray.length];
            ++n3;
        }
        return byArray3;
    }

    protected byte[] getFireStampBytes() throws PrintDataParseException, JposException {
        return this.getPrintBitmapBytes(1, -1);
    }

    protected byte[] getPrintBitmapBytes(int n, int n2) throws PrintDataParseException, JposException {
        byte by;
        byte[] byArray = new byte[]{};
        SetBitmapData setBitmapData = this.getSetBitmapData(this.getStation(), n);
        if (setBitmapData == null) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return byArray;
        }
        switch (setBitmapData.getAlignment()) {
            case -2: {
                by = 1;
                break;
            }
            case -3: {
                by = 2;
                break;
            }
            default: {
                by = 0;
            }
        }
        try {
            byArray = by != 0 ? new byte[]{27, 97, by, 29, 47, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10, 27, 97, 0} : new byte[]{29, 47, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10};
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        return byArray;
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        this.setPrinterMode(252, false);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    public void updateSetBitmapData(SetBitmapData setBitmapData) {
        int n = setBitmapData.getStation();
        int n2 = setBitmapData.getBitmapNumber();
        Vector vector = this.setBitmapDataVector;
        synchronized (vector) {
            SetBitmapData setBitmapData2 = this.getSetBitmapData(n, n2);
            if (setBitmapData2 != null) {
                this.setBitmapDataVector.removeElement(setBitmapData2);
            }
            if (setBitmapData.getFileName().length() > 0) {
                this.setBitmapDataVector.addElement(setBitmapData);
            }
        }
    }

    public SetBitmapData getSetBitmapData(int n, int n2) {
        Vector vector = this.setBitmapDataVector;
        synchronized (vector) {
            Enumeration enumeration = this.setBitmapDataVector.elements();
            while (enumeration.hasMoreElements()) {
                SetBitmapData setBitmapData = (SetBitmapData)enumeration.nextElement();
                if (setBitmapData.getStation() != n || setBitmapData.getBitmapNumber() != n2) continue;
                SetBitmapData setBitmapData2 = setBitmapData;
                return setBitmapData2;
            }
        }
        return null;
    }

    protected byte[] getDeviceEscapeSequenceBytes(String string, int n) throws PrintDataParseException, JposException {
        int n2;
        int n3;
        block29: {
            String string2 = new String("Illegal device escape sequence at index " + n);
            n3 = n;
            try {
                block1 : switch (string.charAt(n3++)) {
                    case '\u001b': {
                        switch (string.charAt(n3++)) {
                            case ',': 
                            case '.': 
                            case '1': 
                            case '2': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case ':': 
                            case '@': 
                            case 'I': 
                            case 'N': 
                            case 'R': 
                            case 'i': 
                            case 'm': 
                            case 'q': 
                            case 'u': 
                            case 'v': 
                            case 'x': 
                            case 'z': 
                            case '{': {
                                break;
                            }
                            case '\u0000': {
                                n2 = string.charAt(n3++);
                                if ((n2 == 32 || n2 == 64 || n2 == 128) && (n2 = (int)string.charAt(n3++)) == 0) break;
                                if (this.isValidating()) {
                                    throw new JposException(111, string2);
                                }
                                throw new PrintDataParseException();
                            }
                            case '\u0007': 
                            case '$': 
                            case '4': 
                            case '\\': 
                            case 'f': {
                                n2 = string.charAt(n3++);
                                n2 = string.charAt(n3++);
                                break;
                            }
                            case ' ': 
                            case '!': 
                            case '\"': 
                            case '#': 
                            case '%': 
                            case ')': 
                            case '+': 
                            case '-': 
                            case '/': 
                            case '3': 
                            case '<': 
                            case 'C': 
                            case 'F': 
                            case 'G': 
                            case 'H': 
                            case 'J': 
                            case 'S': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case '_': 
                            case 'a': 
                            case 'd': 
                            case 'e': 
                            case 'h': 
                            case 'r': 
                            case 't': {
                                n2 = string.charAt(n3++);
                                break;
                            }
                            case 'c': {
                                n2 = string.charAt(n3++);
                                if (n2 == 30 || n2 == 31 || n2 == 34 || n2 == 35) {
                                    n2 = string.charAt(n3++);
                                    break;
                                }
                                if (this.isValidating()) {
                                    throw new JposException(111, string2);
                                }
                                throw new PrintDataParseException();
                            }
                            default: {
                                if (this.isValidating()) {
                                    throw new JposException(111, string2);
                                }
                                throw new PrintDataParseException();
                            }
                        }
                    }
                    case '\u001d': {
                        switch (string.charAt(n3++)) {
                            case '!': 
                            case ';': 
                            case 'H': 
                            case 'Q': 
                            case 'T': 
                            case 'f': 
                            case 'h': 
                            case 'w': {
                                n2 = string.charAt(n3++);
                                break block1;
                            }
                            case 'I': {
                                n2 = string.charAt(n3++);
                                if (n2 != 1) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block29;
                            }
                            case 'R': {
                                n2 = string.charAt(n3++);
                                if (n2 != 0 && n2 != 1 || (n2 = (int)string.charAt(n3++)) < 0 || n2 > 144) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block29;
                            }
                            default: {
                                if (this.isValidating()) {
                                    throw new JposException(111, string2);
                                }
                                throw new PrintDataParseException();
                            }
                        }
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (this.isValidating()) {
                    throw new JposException(111, string2);
                }
                throw new PrintDataParseException();
            }
        }
        byte[] byArray = new byte[n3 - n];
        n2 = n;
        while (n2 < n3) {
            byArray[n2 - n] = (byte)string.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    protected byte[] getPaperCutBytes(int n) throws PrintDataParseException, JposException {
        if (this.getStation() != 2) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return new byte[0];
        }
        switch (n) {
            case 100: {
                return new byte[]{27, 109};
            }
            case 0: {
                return new byte[0];
            }
        }
        if (this.isValidating()) {
            throw new JposException(106);
        }
        return new byte[]{27, 109};
    }

    protected byte[] getFeedAndPaperCutBytes(int n) throws PrintDataParseException, JposException {
        if (this.getStation() != 2) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return new byte[0];
        }
        byte by = (byte)this.getServiceState().getRecLinesToPaperCut();
        switch (n) {
            case 100: {
                return new byte[]{27, 100, by, 27, 109};
            }
            case 0: {
                return new byte[]{27, 100, by};
            }
        }
        if (this.isValidating()) {
            throw new JposException(106);
        }
        return new byte[]{27, 100, by, 27, 109};
    }

    protected byte[] getBoldBytes() throws PrintDataParseException, JposException {
        this.setPrinterMode(8, true);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getUnderlineBytes() throws PrintDataParseException, JposException {
        if (this.isInverted()) {
            this.setPrinterMode(4, true);
        } else {
            this.setPrinterMode(128, true);
        }
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getUnderlineBytes(int n) throws PrintDataParseException, JposException {
        switch (n) {
            case 0: {
                return new byte[0];
            }
            case 1: {
                return this.getUnderlineBytes();
            }
        }
        if (this.isValidating()) {
            throw new JposException(106, "Illegal underline thickness");
        }
        if (n < 0) {
            return new byte[0];
        }
        return this.getUnderlineBytes();
    }

    protected byte[] getReverseVideoBytes() throws PrintDataParseException, JposException {
        this.setPrinterMode(64, true);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getSingleWideSingleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        this.setPrinterMode(48, false);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getDoubleWideBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        this.setPrinterMode(32, true);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getDoubleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        this.setPrinterMode(16, true);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected byte[] getDoubleWideDoubleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        this.setPrinterMode(48, true);
        return new byte[]{27, 33, this.getPrinterMode()};
    }

    protected final byte getPrinterMode() {
        return (byte)this.printerMode;
    }

    protected final void setPrinterMode(int n, boolean bl) {
        this.printerMode = bl ? (this.printerMode |= n) : (this.printerMode &= ~n);
    }
}

