/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrintRawModeInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrinterRead;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.poss.POSPrinter4689POSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSSPOSPrinterServiceImp;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class POSPrinter4689Imp
extends POSSPOSPrinterServiceImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4689Imp";
    private POSPrinter4689POSSPrintDataCompiler printDataCompiler = null;

    protected POSPrinter4689Imp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter4689POSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        Tracer.trace(4, className, "open()", "Exit");
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    void doDirectIOFlipCheck() throws JposException {
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
    }

    void doDirectIOPrintDownloadedMessage(int n) throws JposException {
        this.printDataCompiler.setLogo(1, "");
        this.printDataCompiler.setLogo(2, "");
    }

    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace(4, className, "processRotatePrint()", "Entry");
        super.processRotatePrint(rotatePrintData);
        block0 : switch (rotatePrintData.getStation()) {
            case 2: {
                switch (rotatePrintData.getRotation()) {
                    case 257: {
                        this.setRecLineSpacing(15);
                        break block0;
                    }
                    case 1: {
                        this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
                    }
                }
            }
        }
        Tracer.trace(4, className, "processRotatePrint()", "Exit");
    }

    public void checkMode(int n, int n2) throws JposException {
        if (n2 == 16) {
            return;
        }
        throw new JposException(106);
    }

    public void clearBitmaps() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.bitmapIndex = 1;
        }
    }

    public void clearMessages() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.messageIndex = 1;
        }
    }

    public void downloadData(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "downloadData(" + n + ", " + string + ", " + n2 + ", " + n3 + ")", "Entry");
        int n4 = string.indexOf("\u001bF");
        if (n4 > 0) {
            try {
                string = new String(string.substring(0, n4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[string.length()];
        int n5 = 0;
        while (n5 < byArray.length) {
            byArray[n5] = (byte)string.charAt(n5);
            ++n5;
        }
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0), new PosArg("printAlignment", 0)};
            this.posDevice.ioctl(302, posArgArray);
            PosArg[] posArgArray2 = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 8), new PosArg("printAlignment", 1)};
            this.posDevice.ioctl(305, posArgArray2);
            this.posDevice.write(byArray);
            this.posDevice.ioctl(305, posArgArray);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace(4, className, "downloadData()", "Exit");
    }

    public void downloadData(int n, byte[] byArray, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "downloadData(" + n + ", " + n2 + ", " + n3 + ")", "Entry");
        PosArg[] posArgArray = new PosArg[1];
        try {
            int n4 = 0;
            while (true) {
                byArray[n4] = byArray[n4 + 3];
                ++n4;
            }
        }
        catch (Exception exception) {
            try {
                posArgArray[0] = new PosArg("printMode", 16);
                this.posDevice.ioctl(305, posArgArray);
                this.posDevice.write(byArray, 7632);
                posArgArray[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (Exception exception2) {
                posArgArray[0] = new PosArg("printMode", 1);
                try {
                    this.posDevice.ioctl(305, posArgArray);
                }
                catch (PosException posException) {
                    // empty catch block
                }
                if (exception2 instanceof PosException) {
                    throw new JposException(111, exception2.getMessage(), exception2);
                }
                if (exception2 instanceof JposException) {
                    throw new JposException(((JposException)((Object)exception2)).getErrorCode());
                }
                throw new JposException(111);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
            Tracer.trace(4, className, "downloadData()", "Exit");
            return;
        }
    }

    public int getStationMaxBitmapHeight(int n) {
        return 144;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        return this.getNextByteForThermal(printBitmapImageInfo);
    }

    public void processPrintBarCode(PrintBarCodeData printBarCodeData) throws JposException {
        throw new JposException(111);
    }

    void doDirectIOSetStamp(String string) throws JposException {
        this.serviceState.setCapRecBitmap(true);
        int n = this.serviceState.getRecLineWidth();
        if (this.serviceState.getMapMode() != 1) {
            n = this.convertToDots(n, 2);
        }
        SetBitmapData setBitmapData = new SetBitmapData(1, 2, string, -11, -1, null);
        this.printBitmapUtil.validateBitmap(setBitmapData, 16, n);
        this.processSetBitmap(setBitmapData);
        this.serviceState.setCapRecBitmap(false);
    }

    public int getForcedBitmapHeight() {
        return 144;
    }

    public int getForcedBitmapWidth() {
        return 424;
    }

    protected int getDefaultCodePage() throws JposException {
        return 932;
    }

    protected int getCodePage() throws JposException {
        return 932;
    }

    protected void setCodePage(int n) throws JposException {
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = null;
        printerFontArray = new PrinterFont[]{new PrinterFont(2, 32, 576, 1, 0, 32), new PrinterFont(1, 32, 474, 1, 0, 32)};
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    short getNextByteForThermal(PrintBitmapImageInfo printBitmapImageInfo) {
        int n = 0;
        if (printBitmapImageInfo.row >= printBitmapImageInfo.height) {
            n = 0;
            printBitmapImageInfo.col += 8L;
            if (printBitmapImageInfo.col >= printBitmapImageInfo.width) {
                if (printBitmapImageInfo.row % 8L == 7L) {
                    printBitmapImageInfo.done = true;
                } else {
                    printBitmapImageInfo.col = 0L;
                    ++printBitmapImageInfo.row;
                }
            }
        } else {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = printBitmapImageInfo.pixels[(int)(printBitmapImageInfo.row * printBitmapImageInfo.width + printBitmapImageInfo.col)];
                n3 = n3 == -1 ? 1 : 0;
                n = n << 1 | n3;
                ++printBitmapImageInfo.col;
                if (printBitmapImageInfo.col == printBitmapImageInfo.width) {
                    n <<= 7 - n2;
                    n2 = 8;
                    if (printBitmapImageInfo.row == printBitmapImageInfo.height - 1L && printBitmapImageInfo.row % 8L == 7L) {
                        printBitmapImageInfo.done = true;
                    } else {
                        printBitmapImageInfo.col = 0L;
                        ++printBitmapImageInfo.row;
                    }
                }
                ++n2;
            }
        }
        return (short)n;
    }

    public byte[] getBitmapHeader(int n, int n2) {
        return null;
    }

    public int getMicronsPerStep(int n) {
        return 353;
    }

    public int getDotsPerInchHigh(int n) {
        return 205;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        return 205;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        return 2000;
    }

    public int getWriteBufferSize() {
        return 8192;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        return 7732;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        return 0;
    }

    public boolean requiresLinefeed(int n) {
        return n != 2;
    }

    void doDirectIODownloadPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIODownloadNonPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOHeadMovement(int n) throws JposException {
        throw new JposException(106);
    }

    void doSelectResidentCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectUserDefinedCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectCodePage(int n) throws JposException {
        throw new JposException(106);
    }

    void doEraseUserDefinedCharacterSet(int n) throws JposException {
        throw new JposException(106);
    }

    void doPrintInRawMode(DirectIOPrintRawModeInfo directIOPrintRawModeInfo) throws JposException {
        throw new JposException(106);
    }

    void doPrinterRead(DirectIOPrinterRead directIOPrinterRead) throws JposException {
        throw new JposException(106);
    }
}

