/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.poss.POSSImpFactory;
import com.ibm.poss.Device;
import com.ibm.poss.Errno;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosSubsystem;
import java.util.Enumeration;
import java.util.Hashtable;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.services.EventCallbacks;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class POSSDeviceServiceImp
implements DeviceServiceImp,
ServiceInstanceImp,
Device,
Errno,
PosDef,
JposConst {
    private static boolean trace = false;
    private static boolean debug = false;
    private static final boolean assert = true;
    private DeviceServiceAbstraction dsAbstraction = null;
    private DeviceServiceState serviceState = null;
    private String logicalName = null;
    private EventCallbacks eventCallbacks = null;
    private Hashtable posResourceHashtable = null;
    private PosArg[] posOpenArgs = null;
    private PosDevice posDevice = new PosDevice();
    private int posNdeviceNumber = -1;
    private int posNslotNumber = -1;
    private int posNportNumber = -1;
    private JposEntry jposEntry = null;

    protected POSSDeviceServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.POSSDeviceServiceImp");
        }
        if (deviceServiceAbstraction == null) {
            throw new JposException(111, "POSSDeviceServiceImp::POSSDeviceServiceImp: dsAbstraction == null");
        }
        this.dsAbstraction = deviceServiceAbstraction;
        this.serviceState = deviceServiceAbstraction.getDeviceServiceState();
        this.jposEntry = this.serviceState.getJposEntryInfo().getJposEntry();
        this.logicalName = this.serviceState.getJposEntryInfo().getLogicalName();
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.POSSDeviceServiceImp");
        }
    }

    public synchronized void deleteImp() throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.deleteImp");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.deleteImp");
        }
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.createImp");
        }
        ServiceInstanceImp serviceInstanceImp = POSSImpFactory.createImp(deviceServiceAbstraction);
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.createImp");
        }
        return serviceInstanceImp;
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.setDeviceEnabled");
        }
        try {
            if (bl) {
                if (!this.isAcquired()) {
                    this.posDevice.ioctl(301);
                }
                this.posDevice.ioctl(306);
            } else if (this.serviceState.getDeviceEnabled()) {
                this.posDevice.ioctl(303);
                if (!this.serviceState.getClaimed()) {
                    this.posDevice.ioctl(304);
                }
            }
        }
        catch (PosException posException) {
            if (trace) {
                posException.printStackTrace();
            }
            switch (posException.getErrorCode()) {
                case 307: 
                case 317: 
                case 326: 
                case 328: {
                    throw new JposException(108, posException.getMessage(), (Exception)posException);
                }
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        catch (Exception exception) {
            throw new JposException(111, "JPOS_E_FAILURE", exception);
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.setDeviceEnabled");
        }
    }

    public void setFreezeEvents(boolean bl) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.freezeEvents");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.freezeEvents");
        }
    }

    public void setPowerNotify(int n) throws JposException {
    }

    public void claim(int n) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.claim");
        }
        try {
            if (!this.isAcquired()) {
                this.posDevice.ioctl(301);
            }
        }
        catch (PosException posException) {
            if (trace) {
                posException.printStackTrace();
            }
            switch (posException.getErrorCode()) {
                case 317: {
                    throw new JposException(108);
                }
                case 307: 
                case 326: 
                case 328: {
                    throw new JposException(108, posException.getMessage(), (Exception)posException);
                }
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        catch (Exception exception) {
            if (trace) {
                exception.printStackTrace();
            }
            throw new JposException(111, "JPOS_E_FAILURE", exception);
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.claim");
        }
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.open");
        }
        String string2 = string;
        if (string.length() > 30) {
            string2 = string.substring(0, 30);
        }
        this.eventCallbacks = eventCallbacks;
        this.posOpenArgs = null;
        if (this.jposEntry != null) {
            Hashtable hashtable = this.getPosResourceHashtable();
            String string3 = "";
            Enumeration enumeration = null;
            String[] stringArray = new String[]{"posN", string2 + ".posN"};
            int n = 0;
            while (n < stringArray.length) {
                enumeration = this.jposEntry.getPropertyNames();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(stringArray[n])) continue;
                    hashtable.put(string3.substring(stringArray[n].length(), string3.length()), this.jposEntry.getPropertyValue(string3));
                }
                ++n;
            }
            hashtable.put("compositeDevice", new Integer(this.isCompositeDevice() ? 1 : 0));
            hashtable.put("lockableDevice", new Integer(this.isLockableDevice() ? 1 : 0));
            hashtable.put("shareableDevice", new Integer(this.isShareableDevice() ? 1 : 0));
            this.confirmPosResources(hashtable);
            enumeration = hashtable.keys();
            this.posOpenArgs = new PosArg[hashtable.size()];
            Object object = null;
            int n2 = 0;
            while (n2 < this.posOpenArgs.length) {
                this.posOpenArgs[n2] = new PosArg();
                this.posOpenArgs[n2].setName((String)enumeration.nextElement());
                object = hashtable.get(this.posOpenArgs[n2].getName());
                if (object instanceof Integer) {
                    this.posOpenArgs[n2].setValue((Integer)object);
                } else if (object instanceof String) {
                    String string4 = (String)object;
                    try {
                        int n3 = Integer.decode(string4);
                        this.posOpenArgs[n2].setValue(n3);
                    }
                    catch (Exception exception) {
                        this.posOpenArgs[n2].setValue(string4);
                    }
                } else if (object instanceof StringBuffer) {
                    this.posOpenArgs[n2].setValue((StringBuffer)object);
                } else if (object.getClass().getName().equals("[B")) {
                    this.posOpenArgs[n2].setValue((byte[])object);
                } else {
                    this.posOpenArgs[n2].setValue(-1);
                }
                ++n2;
            }
            try {
                this.posNdeviceNumber = Integer.decode((String)hashtable.get("deviceNumber"));
            }
            catch (Exception exception) {
                this.posNdeviceNumber = -1;
            }
            try {
                this.posNslotNumber = Integer.decode((String)hashtable.get("slotNumber"));
            }
            catch (Exception exception) {
                this.posNslotNumber = -1;
            }
            try {
                this.posNportNumber = Integer.decode((String)hashtable.get("portNumber"));
            }
            catch (Exception exception) {
                this.posNportNumber = -1;
            }
        }
        try {
            this.posDevice.open(string2, this.getPOSSDeviceClass(), this.posOpenArgs);
        }
        catch (PosException posException) {
            if (trace) {
                posException.printStackTrace();
            }
            switch (posException.getErrorCode()) {
                case 307: 
                case 317: 
                case 326: 
                case 328: {
                    throw new JposException(108, posException.getMessage(), (Exception)posException);
                }
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.open");
        }
    }

    public void close() throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.close");
        }
        if (this.posDevice.isOpened()) {
            try {
                this.posDevice.close();
            }
            catch (Exception exception) {
                throw new JposException(111, "JPOS_E_FAILURE", exception);
            }
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.close");
        }
    }

    public void checkHealth(int n) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.checkHealth");
        }
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        switch (n) {
            case 1: 
            case 2: {
                try {
                    Thread.sleep(2000L);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        switch (n) {
            case 1: {
                if (this.isOnline()) {
                    deviceServiceState.setCheckHealthText("Internal HCheck: Successful");
                    break;
                }
                deviceServiceState.setCheckHealthText("Internal HCheck: Not Responding");
                throw new JposException(108);
            }
            case 2: {
                if (this.isOnline()) {
                    deviceServiceState.setCheckHealthText("External HCheck: Successful");
                    break;
                }
                deviceServiceState.setCheckHealthText("External HCheck: Not Responding");
                throw new JposException(108);
            }
            case 3: {
                deviceServiceState.setCheckHealthText("");
                throw new JposException(106);
            }
            default: {
                deviceServiceState.setCheckHealthText("");
                throw new JposException(106);
            }
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.checkHealth");
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.directIO");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.directIO");
        }
    }

    public void release() throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.release");
        }
        if (this.isShareableDevice() && this.serviceState.getDeviceEnabled()) {
            return;
        }
        try {
            this.posDevice.ioctl(304);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        catch (Exception exception) {
            throw new JposException(111, exception.getMessage(), exception);
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.release");
        }
    }

    public DeviceServiceAbstraction getDeviceServiceAbstraction() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getDeviceAbstraction");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getDeviceAbstraction");
        }
        return this.dsAbstraction;
    }

    protected DeviceServiceState getDeviceServiceState() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getDeviceServiceState");
        }
        DeviceServiceState deviceServiceState = this.dsAbstraction.getDeviceServiceState();
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getDeviceServiceState");
        }
        return deviceServiceState;
    }

    protected EventQueueManager getEventQueueManager() throws JposException {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getEventQueueManager");
        }
        EventQueueManager eventQueueManager = this.dsAbstraction.getEventQueueManager();
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getEventQueueManager");
        }
        return eventQueueManager;
    }

    protected abstract String getPOSSDeviceClass();

    protected Hashtable getPosResourceHashtable() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getPosResourceHashtable");
        }
        if (this.posResourceHashtable == null) {
            this.posResourceHashtable = new Hashtable();
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getPosResourceHashtable");
        }
        return this.posResourceHashtable;
    }

    protected void confirmPosResources(Hashtable hashtable) {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.confirmPosResources");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.confirmPosResources");
        }
    }

    protected boolean isCompositeDevice() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isCompositeDevice");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isCompositeDevice");
        }
        return false;
    }

    protected boolean isLockableDevice() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isLockableDevice");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isLockableDevice");
        }
        return false;
    }

    protected boolean isShareableDevice() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isShareableDevice");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isShareableDevice");
        }
        return false;
    }

    public final boolean isOnline() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isOnline");
        }
        boolean bl = PosSubsystem.isDeviceOnline(this.posNdeviceNumber, this.posNslotNumber, this.posNportNumber);
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isOnline");
        }
        return bl;
    }

    protected final boolean isPosOpen() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isPosOpen");
        }
        boolean bl = this.posDevice.isOpened();
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isPosOpen");
        }
        return bl;
    }

    protected final boolean isAcquired() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.isAcquired");
        }
        boolean bl = this.posDevice.isAcquired();
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.isAcquired");
        }
        return bl;
    }

    protected final JposEntry getJposEntry() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getJposEntry");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getJposEntry");
        }
        return this.jposEntry;
    }

    protected final String getLogicalName() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getLogicalName");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getLogicalName");
        }
        return this.logicalName;
    }

    protected final EventCallbacks getEventCallbacks() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getEventCallbacks");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getEventCallbacks");
        }
        return this.eventCallbacks;
    }

    protected final PosDevice getPosDevice() {
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.getPosDevice");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.getPosDevice");
        }
        return this.posDevice;
    }

    static {
        if (!System.getProperty("TracePosSubsystem", "false").equals("false")) {
            trace = true;
        }
        if (!System.getProperty("DebugPosSubsystem", "false").equals("false")) {
            debug = true;
            trace = true;
        }
        if (trace) {
            System.err.println("--> Entry: POSSDeviceServiceImp.static");
        }
        if (trace) {
            System.err.println("<-- Exit : POSSDeviceServiceImp.static");
        }
    }
}

