/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.HardTotalsServiceImp;
import com.ibm.jpos.services.HardTotalsServiceState;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.InternalMessage;
import com.ibm.jpos.util.InternalMessageImp;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import java.util.Enumeration;
import java.util.Vector;
import jpos.JposException;
import jpos.services.EventCallbacks;

public abstract class POSSHardTotalsServiceImp
extends POSSDeviceServiceImp
implements HardTotalsServiceImp,
InternalMessage {
    public static final String USB_VPD_RESOURCE_NAME = "uSBVitalProductData";
    public static final int USB_VPD_START_ADDRESS_OFFSET = 19544;
    public static final int USB_VPD_LENGTH = 128;
    private boolean erase = true;
    private boolean timerExpired = false;
    private HardTotalsServiceState htState;
    private int persistLen = 9;
    private int returnHandle = 0;
    private static InternalMessageImp postal = null;
    private MessageSignature messobj = null;
    private PosDevice posDevice;
    private Debug debug = new Debug(false);
    private Vector claimedHandles = null;
    private int NVRamSize = -1;
    private short ChunkSize = (short)1000;
    private int lastChunk = -1;
    private static final int CRC = 4;
    private static final int QUICK_CLAIM_CONST = 1023;
    private static byte[] IObytes = null;
    private static Vector htfsVector = null;
    Timer timer = this.makeTimer();
    private static final String className = "POSSHardTotalsServiceImp";

    public POSSHardTotalsServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    protected String getPOSSDeviceClass() {
        return "PosNvram";
    }

    protected boolean isShareableDevice() {
        return true;
    }

    public void claim(int n) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = (HardTotalsServiceState)this.getDeviceServiceState();
        if (hardTotalsServiceState.getClaimed()) {
            return;
        }
        Exception exception = null;
        this.timerExpired = false;
        this.timer.reset();
        while (!this.timerExpired) {
            try {
                if (htfsVector != null) {
                    this.checkFileClaimAll();
                } else {
                    boolean bl = hardTotalsServiceState.getDeviceEnabled();
                    this.setDeviceEnabled(true);
                    this.setTotalsSize();
                    this.getPersistentFile();
                    this.setDeviceEnabled(bl);
                }
                DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(hardTotalsServiceState.getServiceKey());
                if (this.getDeviceServiceAbstraction() == deviceService || deviceService == null) {
                    super.claim(99000);
                    hardTotalsServiceState.setClaimed(true);
                    break;
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!this.timer.getStarted() && !this.timerExpired && n != -1 && n != 0) {
                this.timer.setTime(n);
                this.timer.start();
            }
            if (n == 0) {
                this.timerExpired = true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.timer.stop();
        if (this.timerExpired && !hardTotalsServiceState.getClaimed()) {
            throw new JposException(112, String.valueOf(112), exception);
        }
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        JposEntryInfo jposEntryInfo = this.getDeviceServiceState().getJposEntryInfo();
        if (jposEntryInfo.hasPropertyWithName("posNnvramMode")) {
            jposEntryInfo.getJposEntry().removeProperty("posNnvramMode");
        }
        int n = this.getProperty("posNportNumber");
        int n2 = this.getProperty("posNslotNumber");
        int n3 = this.getProperty("posNdeviceNumber");
        if (jposEntryInfo.hasPropertyWithName("debugOn") || System.getProperty("debugOn") != null) {
            this.debug.on();
        } else {
            this.debug.off();
        }
        Tracer.trace(4, className, "open", "Version 4/14/2000");
        super.open(string, eventCallbacks);
        this.claimedHandles = new Vector();
        if (postal == null) {
            postal = new InternalMessageImp();
        }
        if (this.messobj == null) {
            this.messobj = new MessageSignature(n2, n, n3);
        }
        postal.addMessageListener(this);
        this.messobj.setData(null);
        Tracer.trace(4, className, "open", "Sending from open");
        postal.sendMessage(this.messobj, this);
        Tracer.trace(4, className, "open", "post-Sending from open");
        this.htState = (HardTotalsServiceState)this.getDeviceServiceState();
        this.posDevice = this.getPosDevice();
    }

    public void close() throws JposException {
        try {
            Enumeration enumeration = this.claimedHandles.elements();
            Tracer.trace(4, className, "close", "claimed handle count " + this.claimedHandles.size());
            while (enumeration.hasMoreElements()) {
                ((HardTotalsFileSys)enumeration.nextElement()).setFileClaimed(false);
            }
            postal.removeMessageListener(this);
            Vector vector = htfsVector;
            synchronized (vector) {
                if (postal.getListenerSize() <= 0) {
                    htfsVector.removeAllElements();
                    htfsVector = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public void release() throws JposException {
        super.release();
        this.htState.setClaimed(false);
    }

    private int getProperty(String string) {
        JposEntryInfo jposEntryInfo = this.getDeviceServiceState().getJposEntryInfo();
        int n = 0;
        String string2 = (String)jposEntryInfo.getPropertyValue(string);
        if (string2 != null) {
            n = Integer.decode(string2);
        }
        return n;
    }

    private void readUSBVPD(int[] nArray, Object object) throws JposException {
        if (nArray == null || nArray.length < 128) {
            throw new JposException(106, "directIO.data parameter is null or not big enough");
        }
        int n = 302;
        byte[] byArray = new byte[128];
        PosArg[] posArgArray = new PosArg[]{new PosArg(USB_VPD_RESOURCE_NAME, byArray)};
        try {
            this.getPosDevice().ioctl(n, posArgArray, posArgArray.length);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2];
            ++n2;
        }
    }

    private void writeUSBVPD(int[] nArray, Object object) throws JposException {
        if (nArray == null || nArray.length < 128) {
            throw new JposException(106, "directIO.data parameter is null or not big enough");
        }
        int n = 305;
        byte[] byArray = new byte[128];
        int n2 = 0;
        while (n2 < nArray.length) {
            byArray[n2] = (byte)nArray[n2];
            ++n2;
        }
        PosArg[] posArgArray = new PosArg[]{new PosArg(USB_VPD_RESOURCE_NAME, byArray)};
        try {
            this.getPosDevice().ioctl(n, posArgArray, posArgArray.length);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        switch (n) {
            case 0: {
                this.readUSBVPD(nArray, object);
                break;
            }
            case 1: {
                this.writeUSBVPD(nArray, object);
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void beginTrans() throws JposException {
        throw new JposException(106);
    }

    public void claimFile(int n, int n2) throws JposException {
        HardTotalsFileSys hardTotalsFileSys = null;
        hardTotalsFileSys = this.getFile(n);
        hardTotalsFileSys.isAssociate(this);
        if (this.claimedHandles.contains(hardTotalsFileSys)) {
            return;
        }
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        Exception exception = null;
        this.timerExpired = false;
        Timer timer = this.makeTimer();
        while (!this.timerExpired) {
            try {
                if (!this.fileClaimedByOther(n, null)) {
                    DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(this.htState.getServiceKey());
                    if (this.getDeviceServiceAbstraction() == deviceService || deviceService == null) {
                        this.setFileClaim(n, true);
                    }
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!timer.getStarted() && !this.timerExpired && n2 != -1 && n2 != 0) {
                timer.setTime(n2);
                timer.start();
            }
            if (n2 == 0) {
                this.timerExpired = true;
            }
            if (hardTotalsFileSys.getFileClaimed() && this.claimedHandles.contains(hardTotalsFileSys)) {
                timer = null;
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        timer = null;
        if (this.timerExpired && !this.claimedHandles.contains(hardTotalsFileSys)) {
            throw new JposException(112, String.valueOf(112), exception);
        }
    }

    public void commitTrans() throws JposException {
        throw new JposException(106);
    }

    public void create(String string, int[] nArray, int n, boolean bl) throws JposException {
        Tracer.trace(4, className, "create", "\"" + string + "\" of size" + n);
        HardTotalsFileSys hardTotalsFileSys = null;
        try {
            hardTotalsFileSys = this.getFilebyname(string);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        if (hardTotalsFileSys != null) {
            throw new JposException(110);
        }
        if (this.htState.getCapSingleFile() && (this.htState.getNumberOfFiles() > 0 || !string.equals(""))) {
            throw new JposException(106);
        }
        int n2 = this.htState.getFreeData();
        if (n > n2) {
            throw new JposException(114, 201);
        }
        if (this.htState.getNumberOfFiles() == 0) {
            this.returnHandle = 0;
        }
        nArray[0] = ++this.returnHandle;
        this.newFile(string, n, nArray[0]);
        this.messobj.setData(n);
        postal.sendMessage(this.messobj, this);
        this.htState.setFreeData(n2 -= n);
        this.htState.setNumberOfFiles(1 + this.htState.getNumberOfFiles());
        if (this.erase) {
            this.getFile(nArray[0]).addAssociate(this);
            try {
                this.setAll(this.returnHandle, (byte)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Tracer.trace(4, className, "create", "flush");
            this.setPersistentFile();
        }
    }

    public void delete(String string) throws JposException {
        Tracer.trace(4, className, "delete", "\"" + string + "\"");
        HardTotalsFileSys hardTotalsFileSys = this.getFilebyname(string);
        hardTotalsFileSys.setFileClaimed(true);
        this.htState.setFreeData(this.htState.getFreeData() + hardTotalsFileSys.size);
        this.htState.setNumberOfFiles(this.htState.getNumberOfFiles() - 1);
        this.messobj.setData(-hardTotalsFileSys.size);
        postal.sendMessage(this.messobj, this);
        this.remove(hardTotalsFileSys);
        this.setPersistentFile();
        Tracer.trace(4, className, "delete", "Delete Successful");
    }

    public void find(String string, int[] nArray, int[] nArray2) throws JposException {
        Tracer.trace(4, className, "find", "\"" + string + "\"");
        HardTotalsFileSys hardTotalsFileSys = this.getFilebyname(string);
        if (hardTotalsFileSys == null) {
            throw new JposException(109);
        }
        nArray[0] = hardTotalsFileSys.getHandle();
        nArray2[0] = hardTotalsFileSys.getSize();
        hardTotalsFileSys.addAssociate(this);
    }

    public void findByIndex(int n, String[] stringArray) throws JposException {
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (n >= htfsVector.size()) {
            throw new JposException(106);
        }
        stringArray[0] = ((HardTotalsFileSys)htfsVector.elementAt(n)).getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(int n, byte[] byArray, int n2, int n3) throws JposException {
        int n4;
        int n5;
        boolean bl = false;
        if (!this.htState.getClaimed()) {
            try {
                this.claim(1023);
            }
            catch (Exception exception) {
                throw new JposException(111, "Failed claim");
            }
            bl = true;
        }
        HardTotalsFileSys hardTotalsFileSys = null;
        if (n != -1) {
            hardTotalsFileSys = this.getFile(n);
            if (hardTotalsFileSys == null) {
                if (!bl) throw new JposException(106);
                this.release();
                throw new JposException(106);
            }
            hardTotalsFileSys.isAssociate(this);
            n5 = hardTotalsFileSys.getSize();
            n4 = hardTotalsFileSys.getStart();
        } else {
            n5 = this.htState.getTotalsSize();
            n4 = 0;
        }
        Tracer.trace(4, className, "read", " " + byArray.length + " " + n3 + " " + n4 + " " + n2 + " " + n5);
        if (byArray.length < n3 || n4 + n2 + n3 > n5) {
            if (!bl) throw new JposException(106);
            this.release();
            throw new JposException(106);
        }
        int n6 = 0;
        try {
            block17: {
                try {
                    if (n3 > this.ChunkSize) {
                        if (IObytes == null) {
                            IObytes = new byte[this.ChunkSize];
                        }
                        byte[] byArray2 = IObytes;
                        synchronized (byArray2) {
                            int n7 = this.ChunkSize;
                            int n8 = 0;
                            while (true) {
                                if (n3 <= 0) {
                                    break block17;
                                }
                                int n9 = n8 * this.ChunkSize + n2 + n4;
                                n6 = this.ChunkIO(IObytes, n9, this.ChunkSize, hardTotalsFileSys, true);
                                System.arraycopy(IObytes, 0, byArray, n8 * this.ChunkSize, n7);
                                n7 = (n3 -= n7) > this.ChunkSize ? (int)this.ChunkSize : n3;
                                ++n8;
                            }
                        }
                    }
                    n6 = this.ChunkIO(byArray, n2 + n4, n3, hardTotalsFileSys, true);
                }
                catch (PosException posException) {
                    this.thrower(posException);
                    Object var16_17 = null;
                    if (!bl) return;
                    this.release();
                    return;
                }
            }
            Object var16_16 = null;
            if (!bl) return;
            this.release();
            return;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (!bl) throw throwable;
            this.release();
            throw throwable;
        }
    }

    public void recalculateValidationData(int n) throws JposException {
        throw new JposException(106);
    }

    public void releaseFile(int n) throws JposException {
        try {
            HardTotalsFileSys hardTotalsFileSys = this.getFile(n);
            int n2 = this.claimedHandles.indexOf(hardTotalsFileSys);
            if (n2 == -1) {
                throw new JposException(106);
            }
            this.setFileClaim(n, false);
        }
        catch (JposException jposException) {
            if (jposException.getErrorCode() != 106) {
                throw new JposException(106, jposException.getErrorCodeExtended(), "", jposException.getOrigException());
            }
            throw jposException;
        }
    }

    public void rename(int n, String string) throws JposException {
        if (this.htState.getCapSingleFile()) {
            throw new JposException(106);
        }
        HardTotalsFileSys hardTotalsFileSys = null;
        hardTotalsFileSys = this.getFile(n);
        hardTotalsFileSys.isAssociate(this);
        if (hardTotalsFileSys == null) {
            throw new JposException(106);
        }
        HardTotalsFileSys hardTotalsFileSys2 = null;
        try {
            hardTotalsFileSys2 = this.getFilebyname(string);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        if (hardTotalsFileSys2 != null) {
            throw new JposException(110);
        }
        hardTotalsFileSys.setName(string);
    }

    public void rollback() throws JposException {
        throw new JposException(106);
    }

    public void setAll(int n, byte by) throws JposException {
        Tracer.trace(4, className, "setAll", "Entry");
        HardTotalsFileSys hardTotalsFileSys = null;
        boolean bl = false;
        if (!this.htState.getClaimed()) {
            try {
                this.claim(1023);
            }
            catch (Exception exception) {
                throw new JposException(111, "Failed claim");
            }
            bl = true;
        }
        hardTotalsFileSys = this.getFile(n);
        hardTotalsFileSys.isAssociate(this);
        if (hardTotalsFileSys == null && n != 0) {
            if (bl) {
                this.release();
            }
            throw new JposException(106);
        }
        int n2 = 0;
        n2 = n == 0 ? this.htState.getTotalsSize() : hardTotalsFileSys.getSize();
        int n3 = n2 > this.ChunkSize ? (int)this.ChunkSize : n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = by;
            ++n4;
        }
        n4 = hardTotalsFileSys == null ? 0 : hardTotalsFileSys.getStart();
        while (0 < n2) {
            try {
                this.ChunkIO(byArray, n4, n3, hardTotalsFileSys, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n4 += n3;
            if (n3 <= (n2 -= n3)) continue;
            int n5 = n3 = n2 >= this.ChunkSize ? (int)this.ChunkSize : n2;
        }
        if (bl) {
            this.release();
        }
    }

    public void validateData(int n) throws JposException {
        throw new JposException(106);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int n, byte[] byArray, int n2, int n3) throws JposException {
        int n4;
        int n5;
        int n6 = this.htState.getTotalsSize();
        int n7 = 0;
        boolean bl = false;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        if (!this.htState.getClaimed()) {
            try {
                this.claim(1023);
            }
            catch (Exception exception) {
                throw new JposException(111, "Failed claim");
            }
            bl = true;
        }
        HardTotalsFileSys hardTotalsFileSys = null;
        if (n != -1) {
            hardTotalsFileSys = this.getFile(n);
            if (hardTotalsFileSys == null) {
                if (!bl) throw new JposException(106);
                this.release();
                throw new JposException(106);
            }
            hardTotalsFileSys.isAssociate(this);
            n5 = hardTotalsFileSys.getSize();
            n4 = hardTotalsFileSys.getStart();
        } else {
            n5 = n6;
            n4 = 0;
        }
        if (n == 0) {
            n5 -= this.calculatePersist();
        }
        if (n4 + n2 + n3 > n5 || n2 < n4) {
            if (!bl) throw new JposException(106);
            this.release();
            throw new JposException(106);
        }
        try {
            block19: {
                try {
                    if (n3 > this.ChunkSize) {
                        if (IObytes == null) {
                            IObytes = new byte[this.ChunkSize];
                        }
                        byte[] byArray2 = IObytes;
                        synchronized (byArray2) {
                            int n8 = this.ChunkSize;
                            int n9 = 0;
                            while (true) {
                                if (n3 <= 0) {
                                    break block19;
                                }
                                int n10 = n9 * this.ChunkSize + n2 + n4;
                                System.arraycopy(byArray, n9 * this.ChunkSize, IObytes, 0, n8);
                                n7 = this.ChunkIO(IObytes, n10, n8, hardTotalsFileSys, false);
                                n8 = (n3 -= n8) > this.ChunkSize ? (int)this.ChunkSize : n3;
                                ++n9;
                            }
                        }
                    }
                    n7 = this.ChunkIO(byArray, n2 + n4, n3, hardTotalsFileSys, false);
                }
                catch (PosException posException) {
                    this.thrower(posException);
                    Object var17_18 = null;
                    if (!bl) return;
                    this.release();
                    return;
                }
            }
            Object var17_17 = null;
            if (!bl) return;
            this.release();
            return;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (!bl) throw throwable;
            this.release();
            throw throwable;
        }
    }

    public void setTotalsSize() throws JposException {
        PosArg[] posArgArray = new PosArg[1];
        int n = this.getNVRamSize() - this.calculatePersist() - (this.getChunkDump() + 4);
        this.htState.setTotalsSize(n);
        this.htState.setFreeData(n);
        if (this.lastChunk == -1) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            nArray[0] = 0;
            nArray2[0] = this.ChunkSize - 1;
            nArray3[0] = 0;
            Tracer.trace(4, className, "setTotalsSize", String.valueOf(this.getNVRamSize()) + " " + String.valueOf(this.getChunkDump()));
            this.ChunkCalc(nArray, nArray2, nArray3, n - 1);
            Tracer.trace(4, className, "setTotalsSize", "final c " + nArray3[0]);
            this.lastChunk = nArray3[0];
        }
    }

    public void getPersistentFile() {
        block17: {
            boolean bl;
            block16: {
                bl = false;
                try {
                    if (htfsVector != null) {
                        Tracer.trace(4, className, "getPersistentFile", "htfsVector already exists - getPersistentFile()");
                        int n = 0;
                        while (htfsVector.size() > n) {
                            HardTotalsFileSys hardTotalsFileSys = (HardTotalsFileSys)htfsVector.elementAt(n);
                            this.htState.setFreeData(this.htState.getFreeData() - hardTotalsFileSys.size);
                            this.htState.setNumberOfFiles(this.htState.getNumberOfFiles() + 1);
                            ++n;
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    return;
                }
                try {
                    Tracer.trace(4, className, "getPersistentFile", "htfsVector doesn't already exists - getPersistentFile()");
                    if (htfsVector == null) {
                        htfsVector = new Vector();
                    }
                    if (!this.htState.getClaimed()) {
                        try {
                            this.claim(1023);
                        }
                        catch (Exception exception) {
                            throw new JposException(111, "Failed claim");
                        }
                        bl = true;
                    }
                    this.persistLen = this.calculatePersist();
                    Tracer.trace(4, className, "getPersistentFile", "Persistlen = " + this.persistLen);
                    byte[] byArray = new byte[this.persistLen];
                    this.setCursor(this.getNVRamSize() - this.persistLen, false);
                    this.ChunkIn(byArray, this.persistLen, false);
                    String string = new String(byArray);
                    int n = string.indexOf(13);
                    if (n > -1) {
                        string = n == 0 ? "\r" : string.substring(0, n);
                    }
                    new Integer(0);
                    int n2 = Integer.parseInt(string, 16);
                    int[] nArray = new int[1];
                    int n3 = n2 = n2 < 0 ? 0 : n2;
                    if (n < 0) break block16;
                    this.erase = false;
                    Tracer.trace(4, className, "getPersistentFile", "gp Size " + n2);
                    try {
                        this.create("", nArray, n2, false);
                    }
                    catch (Exception exception) {
                        Tracer.trace(4, className, "getPersistentFile", "\tCreate Failed???");
                    }
                    this.erase = true;
                }
                catch (Exception exception) {
                    if (!this.debug.isOn()) break block16;
                    exception.printStackTrace();
                }
            }
            try {
                if (bl) {
                    this.release();
                }
                this.messobj.setData(htfsVector);
                postal.sendMessage(this.messobj, this);
            }
            catch (Exception exception) {
                if (!this.debug.isOn()) break block17;
                exception.printStackTrace();
            }
        }
    }

    private void setPersistentFile() {
        Tracer.trace(4, className, "Set Persistent File", "Entry");
        boolean bl = false;
        try {
            byte[] byArray = new byte[5];
            if (!this.htState.getClaimed()) {
                try {
                    this.claim(1023);
                }
                catch (Exception exception) {
                    throw new JposException(111, "Failed claim");
                }
                bl = true;
            }
            if (this.htState.getNumberOfFiles() > 0) {
                int bl2 = ((HardTotalsFileSys)htfsVector.elementAt(0)).getSize();
                new Integer(0);
                String n = Integer.toHexString(bl2);
                byArray = new byte[n.length() + 1];
                System.arraycopy(n.getBytes(), 0, byArray, 0, n.length());
                Tracer.trace(4, className, "setPersistentFile", "Persistlen = " + this.persistLen);
                if (n.length() < this.calculatePersist()) {
                    byArray[n.length()] = 13;
                }
            } else {
                byArray[0] = 13;
            }
            boolean exception2 = this.htState.getDeviceEnabled();
            this.htState.setDeviceEnabled(true);
            int n = this.persistLen;
            this.persistLen = 0;
            Tracer.trace(4, className, "setPersistentFile", this.htState.getTotalsSize() + "Set Pers");
            this.setCursor(this.getNVRamSize() - n, false);
            this.ChunkOut(byArray, byArray.length);
            int n2 = 0;
            while (n2 < byArray.length) {
                this.persistLen = n;
                ++n2;
            }
            if (bl) {
                this.release();
            }
            this.htState.setDeviceEnabled(exception2);
            Tracer.trace(4, className, "setPersistentFile", "Set Per successful???");
        }
        catch (Exception exception) {
            if (this.debug.isOn()) {
                exception.printStackTrace();
            }
            try {
                if (bl) {
                    this.release();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Tracer.trace(4, className, "setPersistentFile", "Set per end");
            return;
        }
    }

    public void messageSent(Object object) {
        MessageSignature messageSignature = (MessageSignature)object;
        if (messageSignature.sign == this.messobj.sign) {
            try {
                Tracer.trace(4, className, "messageSent", "Certified mail");
                if (messageSignature.getObject() == null) {
                    if (htfsVector != null) {
                        Tracer.trace(4, className, "messageSent", "Send out reply to new vector request. size =" + htfsVector.size());
                        this.messobj.setData(htfsVector);
                        postal.sendMessage(this.messobj, this);
                    }
                    return;
                }
                if (messageSignature.getObject() instanceof Vector) {
                    Object object2 = messageSignature.getObject();
                    Tracer.trace(4, className, "messageSent", "Need to refresh Vector?");
                    if (htfsVector != null) {
                        return;
                    }
                    Tracer.trace(4, className, "messageSent", "messsageSent method" + htfsVector.size());
                    this.setPersistentFile();
                    htfsVector = (Vector)object2;
                    Tracer.trace(4, className, "messageSent", "Set new Vector. size=" + htfsVector.size());
                } else {
                    Tracer.trace(4, className, "messageSent", "calc datum messageSent():");
                    int n = messageSignature.getData();
                    this.htState.setFreeData(this.htState.getFreeData() - n);
                    this.htState.setNumberOfFiles(this.htState.getNumberOfFiles() - (n > 0 ? -1 : 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HardTotalsFileSys getFile(int n) throws JposException {
        int n2 = 0;
        while (n2 < htfsVector.size()) {
            if (((HardTotalsFileSys)htfsVector.elementAt(n2)).getHandle() == n) {
                return (HardTotalsFileSys)htfsVector.elementAt(n2);
            }
            ++n2;
        }
        throw new JposException(109);
    }

    public HardTotalsFileSys getFilebyname(String string) throws JposException {
        Tracer.trace(4, className, "messageSent", "Vector size = " + htfsVector.size());
        int n = 0;
        while (n < htfsVector.size()) {
            if (string.equals(((HardTotalsFileSys)htfsVector.elementAt(n)).getName())) {
                return (HardTotalsFileSys)htfsVector.elementAt(n);
            }
            ++n;
        }
        throw new JposException(109);
    }

    public void checkFileClaimAll() throws JposException {
        boolean bl = true;
        Enumeration enumeration = htfsVector.elements();
        bl = true;
        while (enumeration.hasMoreElements()) {
            HardTotalsFileSys hardTotalsFileSys = (HardTotalsFileSys)enumeration.nextElement();
            bl = this.fileClaimedByOther(hardTotalsFileSys.getHandle(), null);
            if (!bl) continue;
            throw new JposException(102);
        }
    }

    public boolean fileClaimedByOther(int n, String string) throws JposException {
        HardTotalsFileSys hardTotalsFileSys = null;
        hardTotalsFileSys = n < 0 ? this.getFilebyname(string) : this.getFile(n);
        if (this.claimedHandles.contains(hardTotalsFileSys)) {
            return false;
        }
        return hardTotalsFileSys.getFileClaimed();
    }

    public void setFileClaim(int n, boolean bl) throws JposException {
        HardTotalsFileSys hardTotalsFileSys = null;
        boolean bl2 = false;
        hardTotalsFileSys = this.getFile(n);
        if (hardTotalsFileSys == null) {
            throw new JposException(109);
        }
        if (hardTotalsFileSys.getFileClaimed() && !this.claimedHandles.contains(hardTotalsFileSys)) {
            throw new JposException(102);
        }
        if (bl) {
            hardTotalsFileSys.setFileClaimed(true);
            this.claimedHandles.addElement(hardTotalsFileSys);
        } else {
            hardTotalsFileSys.setFileClaimed(false);
            this.claimedHandles.removeElement(hardTotalsFileSys);
        }
    }

    public HardTotalsFileSys newFile(String string, int n, int n2) {
        HardTotalsFileSys hardTotalsFileSys;
        int n3 = 0;
        int n4 = 0;
        while (n4 < htfsVector.size()) {
            hardTotalsFileSys = (HardTotalsFileSys)htfsVector.elementAt(n4);
            if (n3 < hardTotalsFileSys.getStart() + hardTotalsFileSys.size) {
                n3 = hardTotalsFileSys.getStart() + hardTotalsFileSys.size;
            }
            ++n4;
        }
        hardTotalsFileSys = new HardTotalsFileSys(string, n, n3, n2, this);
        htfsVector.addElement(hardTotalsFileSys);
        return hardTotalsFileSys;
    }

    public void remove(HardTotalsFileSys hardTotalsFileSys) {
        if (htfsVector != null) {
            htfsVector.removeElement(hardTotalsFileSys);
        }
    }

    private int getChunkDump() throws JposException {
        int n = this.getNVRamSize() % this.ChunkSize;
        if (n > 0) {
            n = (this.getNVRamSize() - n) / this.ChunkSize;
            ++n;
        } else {
            n = this.getNVRamSize() / this.ChunkSize;
        }
        return n * 4;
    }

    private int ChunkIO(byte[] byArray, int n, int n2, HardTotalsFileSys hardTotalsFileSys, boolean bl) throws PosException {
        int n3;
        block19: {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int n4;
            block18: {
                n4 = this.ChunkSize;
                n3 = 0;
                n += hardTotalsFileSys == null ? 0 : hardTotalsFileSys.getStart();
                nArray3 = new int[]{0};
                nArray2 = new int[1];
                nArray = new int[1];
                nArray2[0] = 0;
                nArray[0] = n4;
                n = this.ChunkCalc(nArray2, nArray, nArray3, n);
                try {
                    if (nArray3[0] >= this.lastChunk) {
                        n4 = this.NVRamSize - nArray2[0];
                        nArray[0] = nArray2[0] + (n4 -= this.calculatePersist() + 4);
                        Tracer.trace(4, className, "ChunkIO", n4 + " endc " + nArray[0]);
                    }
                }
                catch (Exception exception) {
                    if (!this.debug.isOn()) break block18;
                    exception.printStackTrace();
                }
            }
            try {
                this.setCursor(nArray2[0], false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl2 = n + n2 >= nArray[0];
            int n5 = n + n2 - nArray[0];
            if (bl) {
                Tracer.trace(4, className, "ChunkIO", "Read");
                try {
                    String string;
                    byte[] byArray2 = new byte[n4];
                    n3 = this.ChunkIn(byArray2, 0, false);
                    if (bl2) {
                        System.arraycopy(byArray2, byArray2.length - (n2 - n5), byArray, 0, n2 - n5);
                        nArray3[0] = nArray3[0] + 1;
                        Tracer.trace(4, className, "ChunkIO", "Read Split");
                        nArray2[0] = nArray2[0] + (n4 + 4);
                        nArray[0] = nArray2[0] + n4;
                        this.setCursor(nArray2[0], false);
                        if (this.debug.isOn()) {
                            string = new String(byArray);
                        }
                        n3 += this.ChunkIn(byArray2, 0, false);
                        System.arraycopy(byArray2, 0, byArray, n2 - n5, n5);
                    } else {
                        int n6 = n - nArray2[0];
                        n6 = n6 > 0 ? n6 : 0;
                        System.arraycopy(byArray2, n6, byArray, 0, n2);
                    }
                    if (this.debug.isOn()) {
                        string = new String(byArray);
                    }
                    break block19;
                }
                catch (Exception exception) {
                    if (this.debug.isOn()) {
                        exception.printStackTrace();
                    }
                    break block19;
                }
            }
            Tracer.trace(4, className, "ChunkIO", "Write");
            byte[] byArray3 = new byte[n4];
            try {
                try {
                    this.ChunkIn(byArray3, nArray2[0], true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n7 = n - nArray2[0];
                n7 = n7 > 0 ? n7 : 0;
                Tracer.trace(4, className, "ChunkIO", n7 + " " + bl2 + " " + n2 + " " + n5);
                System.arraycopy(byArray, 0, byArray3, n7, bl2 ? n2 - n5 : n2);
                n3 = this.ChunkOut(byArray3, byArray3.length);
                if (bl2) {
                    Tracer.trace(4, className, "ChunkIO", "Write Split");
                    System.arraycopy(byArray, n2 - n5, byArray3, 0, n5);
                    this.ChunkIO(byArray3, n4 * (nArray3[0] + 1), n5, null, false);
                }
            }
            catch (Exception exception) {
                if (!this.debug.isOn()) break block19;
                exception.printStackTrace();
            }
        }
        return n3;
    }

    private int ChunkIn(byte[] byArray, int n, boolean bl) throws PosException, JposException {
        int n2 = 0;
        this.posDevice.read(byArray);
        if (this.debug.isOn()) {
            String string = new String(byArray);
        }
        if (bl) {
            this.setCursor(n, false);
        }
        return n2;
    }

    private int ChunkOut(byte[] byArray, int n) throws PosException, JposException {
        Tracer.trace(4, className, "ChunkOut", "Entry");
        int n2 = 0;
        Tracer.trace(4, className, "ChunkOut", "len ");
        String string = new String(byArray);
        n2 = this.posDevice.write(byArray, n);
        Tracer.trace(4, className, "ChunkOut", "output " + string);
        Tracer.trace(4, className, "ChunkOut", "Wrote " + String.valueOf(n2));
        return n2;
    }

    private int ChunkCalc(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        Tracer.trace(4, className, ">ChunkCalc ", "");
        Tracer.trace(4, className, "ChunkCalc", String.valueOf(nArray[0]) + " " + String.valueOf(nArray2[0]) + " " + String.valueOf(nArray3[0]) + " " + String.valueOf(n));
        if (n > this.ChunkSize - 1) {
            n += n / this.ChunkSize * 4;
        }
        nArray[0] = 0;
        nArray3[0] = 0;
        nArray2[0] = this.ChunkSize;
        while (n < nArray[0] || n >= nArray2[0]) {
            nArray3[0] = nArray3[0] + 1;
            nArray[0] = nArray[0] + (this.ChunkSize + 4);
            nArray2[0] = nArray[0] + this.ChunkSize;
        }
        Tracer.trace(4, className, "<ChunkCalc ", "");
        Tracer.trace(4, className, "ChunkCalc", String.valueOf(nArray[0]) + " " + String.valueOf(nArray2[0]) + " " + String.valueOf(nArray3[0]) + " " + String.valueOf(n));
        return n;
    }

    private int calculatePersist() throws JposException {
        boolean bl = false;
        boolean bl2 = false;
        return Integer.toHexString(this.getNVRamSize()).length() + 5;
    }

    private void setCursor(int n, boolean bl) throws JposException {
        PosArg[] posArgArray = new PosArg[]{new PosArg("nvramCursor", n)};
        Tracer.trace(4, className, "Setting cursor ", "");
        try {
            this.posDevice.ioctl(305, posArgArray, posArgArray.length);
            boolean bl2 = false;
        }
        catch (PosException posException) {
            if (bl) {
                this.release();
            }
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
    }

    private void thrower(PosException posException) throws JposException {
        int n = posException.getErrorCode();
        switch (n) {
            case 4102: 
            case 4105: 
            case 4106: {
                throw new JposException(106);
            }
            case 317: {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
        }
        throw new JposException(111, posException.getMessage(), (Exception)posException);
    }

    private Timer makeTimer() {
        return new Timer(new Timerable(){

            public void timerExpired() {
                POSSHardTotalsServiceImp.this.timerExpired = true;
            }
        });
    }

    private int getNVRamSize() throws JposException {
        if (this.NVRamSize > 0) {
            return this.NVRamSize;
        }
        PosArg[] posArgArray = new PosArg[]{new PosArg("nvramSize", -1)};
        try {
            this.posDevice.ioctl(302, posArgArray, posArgArray.length);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        this.NVRamSize = (Integer)posArgArray[0].getValue();
        return this.NVRamSize;
    }

    private class HardTotalsFileSys {
        private String name;
        private boolean fileClaimed = false;
        public int size;
        private int start;
        private int handle;
        private Vector associates;

        HardTotalsFileSys(String string, int n, int n2, int n3, Object object) {
            this.name = new String(string);
            this.size = n;
            this.start = n2;
            this.handle = n3;
            this.associates = new Vector(4, 1);
        }

        public void addAssociate(Object object) {
            this.associates.addElement(object);
            Tracer.trace(4, POSSHardTotalsServiceImp.className, "add Assoc", "");
        }

        public void isAssociate(Object object) throws JposException {
            int n = this.associates.indexOf(object, 0);
            if (n == -1) {
                throw new JposException(106);
            }
        }

        public synchronized int getStart() {
            return this.start;
        }

        public synchronized int getSize() {
            return this.size;
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized int getHandle() {
            return this.handle;
        }

        public synchronized boolean getFileClaimed() {
            return this.fileClaimed;
        }

        public synchronized void setFileClaimed(boolean bl) {
            this.fileClaimed = bl;
        }

        public synchronized void setName(String string) {
            this.name = string;
        }
    }

    private class MessageSignature {
        int sign;
        Object data;

        public void setData(int n) {
            this.data = new Integer(n);
        }

        public void setData(Object object) {
            this.data = object;
        }

        public int getData() {
            return this.data == null ? 0 : (Integer)this.data;
        }

        public Object getObject() {
            return this.data;
        }

        public MessageSignature(int n, int n2, int n3) {
            this.sign = n + n2 * 1000 + n3 * 1000000;
        }
    }
}

