/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.MSRParsedData;
import com.ibm.jpos.services.MSRServiceImp;
import com.ibm.jpos.services.MSRServiceState;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSMSRDataParser;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Errno;
import com.ibm.poss.Msr;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosMsrDataHdr;
import com.ibm.poss.PosmMsrDataAvailListener;
import java.io.ByteArrayInputStream;
import jpos.JposException;
import jpos.MSRConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public class POSSMSRServiceImp
extends POSSDeviceServiceImp
implements MSRServiceImp,
Errno,
PosDef,
Msr {
    private MSRServiceState serviceState = null;
    private Object eventSource = null;
    private PosDevice posDevice = null;
    private static final char TRACKTYPE_A = 'A';
    private static final char TRACKTYPE_B = 'B';
    private static final char TRACKTYPE_C = 'C';
    private static final int TRACKENCODING_4BIT = 4;
    private static final int TRACKENCODING_6BIT = 6;
    private static final int TRACKENCODING_7BIT = 7;
    private static final String className = "POSSMSRServiceImp";

    protected POSSMSRServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "POSSMSRServiceImp()", "Entry");
        this.posDevice = this.getPosDevice();
        this.posDevice.setPosmMsrDataAvailListener(new PosDeviceListener());
        Tracer.trace(4, className, className, "Exit");
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void setDecodeData(boolean bl) throws JposException {
    }

    public void setErrorReportingType(int n) throws JposException {
    }

    public void setParseDecodeData(boolean bl) throws JposException {
    }

    public void setTracksToRead(int n) throws JposException {
    }

    public void setTransmitSentinels(boolean bl) throws JposException {
        Tracer.trace(4, className, "setTransmitSentinels() : ", "Entry");
        if (!bl) {
            this.serviceState.setTransmitSentinels(bl);
        } else if (this.serviceState.getCapTransmitSentinels()) {
            this.serviceState.setTransmitSentinels(bl);
        } else {
            Tracer.trace(4, className, "setTransmitSentinels() : ", "setTransmitSentinels Error");
            throw new JposException(106);
        }
        Tracer.trace(4, className, "setTransmitSentinels() : ", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        super.open(string, eventCallbacks);
        Tracer.trace(4, className, "open()", "Entry");
        this.serviceState = (MSRServiceState)this.getDeviceServiceState();
        this.eventSource = eventCallbacks.getEventSource();
        Tracer.trace(4, className, "open()", "Exit");
    }

    public synchronized void close() throws JposException {
        super.close();
        Tracer.trace(4, className, "close()", "Entry");
        this.serviceState = null;
        this.eventSource = null;
        Tracer.trace(4, className, "close()", "Exit");
    }

    public void clearInput() throws JposException {
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.posDevice.setPosmMsrDataAvailListener(null);
    }

    protected String getPOSSDeviceClass() {
        return "PosMsr";
    }

    protected final boolean isLockableDevice() {
        return true;
    }

    private class POSSMSREventContainer
    implements JposEventContainer,
    MSRConst,
    MSRParsedData {
        ErrorEvent errorEvent;
        private char track1Type;
        private int track1Encoding;
        private int track2Encoding;
        private int track3Encoding;
        private POSSMSRDataParser msrDataParser;
        private JposEvent jposEvent;
        private int errorReportingType;
        private String accountNumber;
        private String expirationDate;
        private String firstName;
        private String middleInitial;
        private String serviceCode;
        private String suffix;
        private String surname;
        private String title;
        private byte[] track1Data;
        private byte[] track1DiscretionaryData;
        private byte[] track2Data;
        private byte[] track2DiscretionaryData;
        private byte[] track3Data;
        private byte[] trackJData;

        public void prepareToFire() {
            Tracer.trace(4, "POSSMSREventContainer", "prepareToFire()", "Entry");
            if (!(this.jposEvent instanceof ErrorEvent) || this.errorReportingType != 0) {
                try {
                    POSSMSRServiceImp.this.serviceState.setAccountNumber(this.accountNumber);
                    POSSMSRServiceImp.this.serviceState.setExpirationDate(this.expirationDate);
                    POSSMSRServiceImp.this.serviceState.setFirstName(this.firstName);
                    POSSMSRServiceImp.this.serviceState.setMiddleInitial(this.middleInitial);
                    POSSMSRServiceImp.this.serviceState.setServiceCode(this.serviceCode);
                    POSSMSRServiceImp.this.serviceState.setSuffix(this.suffix);
                    POSSMSRServiceImp.this.serviceState.setSurname(this.surname);
                    POSSMSRServiceImp.this.serviceState.setTitle(this.title);
                    POSSMSRServiceImp.this.serviceState.setTrack1Data(this.track1Data);
                    POSSMSRServiceImp.this.serviceState.setTrack1DiscretionaryData(this.track1DiscretionaryData);
                    POSSMSRServiceImp.this.serviceState.setTrack2Data(this.track2Data);
                    POSSMSRServiceImp.this.serviceState.setTrack2DiscretionaryData(this.track2DiscretionaryData);
                    POSSMSRServiceImp.this.serviceState.setTrack3Data(this.track3Data);
                    POSSMSRServiceImp.this.serviceState.setTrack4Data(this.trackJData);
                }
                catch (Exception exception) {
                    Tracer.trace(4, "POSSMSREventContainer", "prepareToFire()", "Caught Exception setting tracks");
                }
            }
            Tracer.trace(4, "POSSMSREventContainer", "prepareToFire()", "Exit");
        }

        public void doneFiring() {
            Tracer.trace(4, "POSSMSREventContainer", "doneFiring()" + this.errorEvent.getErrorResponse(), "Entry");
            switch (this.errorEvent.getErrorResponse()) {
                case 11: {
                    break;
                }
                case 13: {
                    if (this.errorEvent.getErrorLocus() != 2) break;
                    try {
                        POSSMSRServiceImp.this.clearInput();
                        POSSMSRServiceImp.this.serviceState.setState(2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 12: {
                    try {
                        POSSMSRServiceImp.this.serviceState.setState(2);
                        POSSMSRServiceImp.this.clearInput();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Tracer.trace(4, "POSSMSREventContainer", "doneFiring()", "Exit");
        }

        public JposEvent getJposEvent() {
            return this.jposEvent;
        }

        /*
         * Loose catch block
         */
        public POSSMSREventContainer(short n) {
            block115: {
                this.track1Type = (char)67;
                this.track1Encoding = 6;
                this.track2Encoding = 4;
                this.track3Encoding = 4;
                this.msrDataParser = null;
                this.jposEvent = null;
                this.errorReportingType = 0;
                this.accountNumber = "";
                this.expirationDate = "";
                this.firstName = "";
                this.middleInitial = "";
                this.serviceCode = "";
                this.suffix = "";
                this.surname = "";
                this.title = "";
                this.track1Data = new byte[0];
                this.track1DiscretionaryData = new byte[0];
                this.track2Data = new byte[0];
                this.track2DiscretionaryData = new byte[0];
                this.track3Data = new byte[0];
                this.trackJData = new byte[0];
                int n2 = 2;
                int n3 = 12;
                int n4 = 0;
                short s = 0;
                short s2 = 0;
                int n5 = 0;
                int n6 = 0;
                try {
                    block111: {
                        int n7;
                        int n8;
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Entry");
                        this.errorReportingType = POSSMSRServiceImp.this.serviceState.getErrorReportingType();
                        if (this.errorReportingType == 1) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "errorReportingType = MSR_ERT_TRACK");
                        } else {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "errorReportingType = MSR_ERT_CARD");
                        }
                        switch (POSSMSRServiceImp.this.serviceState.getTracksToRead()) {
                            case 1: {
                                n5 = 1;
                                break;
                            }
                            case 2: {
                                n5 = 2;
                                break;
                            }
                            case 4: {
                                n5 = 4;
                                break;
                            }
                            case 3: {
                                n5 = 3;
                                break;
                            }
                            case 5: {
                                n5 = 5;
                                break;
                            }
                            case 6: {
                                n5 = 6;
                                break;
                            }
                            case 7: {
                                n5 = 7;
                                break;
                            }
                            case 8: {
                                n5 = 8;
                                break;
                            }
                            case 9: {
                                n5 = 9;
                                break;
                            }
                            case 10: {
                                n5 = 10;
                                break;
                            }
                            case 12: {
                                n5 = 12;
                                break;
                            }
                            case 11: {
                                n5 = 11;
                                break;
                            }
                            case 13: {
                                n5 = 13;
                                break;
                            }
                            case 14: {
                                n5 = 14;
                                break;
                            }
                            case 15: {
                                n5 = 15;
                            }
                        }
                        byte[] byArray = new byte[n];
                        try {
                            POSSMSRServiceImp.this.posDevice.read(byArray);
                        }
                        catch (PosException posException) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "PosException when reading Buffer");
                        }
                        PosMsrDataHdr posMsrDataHdr = null;
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "countAvail = " + n);
                        int n9 = 0;
                        while (n9 < n) {
                            posMsrDataHdr = new PosMsrDataHdr(byArray, n9);
                            n4 = posMsrDataHdr.getTrack();
                            s = posMsrDataHdr.getLength();
                            s2 = posMsrDataHdr.getFlags();
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "The track is " + n4);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "TrackLength is : " + s);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "tracksRequested is : " + n5);
                            switch (n4) {
                                case 1: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track PosTRACK_1 found");
                                    break;
                                }
                                case 2: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track PosTRACK_2 found");
                                    break;
                                }
                                case 4: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track PosTRACK_3 found");
                                    break;
                                }
                                case 8: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track PosTRACK_J found");
                                }
                            }
                            if ((n4 & n5) != 0) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Tracks are equals");
                                if ((s2 & 1) == 0) {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "No error on track");
                                    if (s > 0) {
                                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "trackLength is bigger than 0");
                                        switch (n4) {
                                            case 1: {
                                                this.track1Data = new byte[s];
                                                System.arraycopy(byArray, n9 + 8, this.track1Data, 0, s);
                                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track1 copied");
                                                break;
                                            }
                                            case 2: {
                                                this.track2Data = new byte[s];
                                                System.arraycopy(byArray, n9 + 8, this.track2Data, 0, s);
                                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track2 copied");
                                                break;
                                            }
                                            case 4: {
                                                this.track3Data = new byte[s];
                                                System.arraycopy(byArray, n9 + 8, this.track3Data, 0, s);
                                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track3 copied");
                                                break;
                                            }
                                            case 8: {
                                                this.trackJData = new byte[s];
                                                System.arraycopy(byArray, n9 + 8, this.trackJData, 0, s);
                                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track4 copied");
                                            }
                                        }
                                    } else {
                                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "trackLength was smaller than 0");
                                    }
                                } else {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Error on requested track");
                                    switch (n4) {
                                        case 1: {
                                            n6 |= 0x6F;
                                            break;
                                        }
                                        case 2: {
                                            n6 |= 0x6F00;
                                            break;
                                        }
                                        case 4: {
                                            n6 |= 0x6F0000;
                                            break;
                                        }
                                        case 8: {
                                            n6 |= 0x6F000000;
                                        }
                                    }
                                }
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track processed");
                            } else {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Found tracks and tracksRequested were not equals");
                            }
                            n9 += 8 + s;
                        }
                        if (n6 != 0) {
                            if (this.errorReportingType == 0) {
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                                if (this.track1Data.length != 0) {
                                    this.track1Data = new byte[0];
                                }
                                if (this.track2Data.length != 0) {
                                    this.track2Data = new byte[0];
                                }
                                if (this.track3Data.length != 0) {
                                    this.track3Data = new byte[0];
                                }
                                if (this.trackJData.length != 0) {
                                    this.trackJData = new byte[0];
                                }
                            } else {
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 114, n6, 2, 12);
                            }
                        }
                        if (this.jposEvent == null && this.track1Data.length == 0 && this.track2Data.length == 0 && this.track3Data.length == 0 && this.trackJData.length == 0) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "FAILURE, something was 0 or null");
                            if (this.errorReportingType != 0 && this.errorReportingType != 1) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Error with tracks and no data exists");
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                            }
                        }
                        if (this.track1Data.length > 0) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Identify format for track1");
                            block44 : switch (this.track1Data[0]) {
                                case 33: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "track1 is Type A");
                                    this.track1Type = (char)65;
                                    n8 = this.track1Data.length - 1;
                                    while (n8 >= 0) {
                                        if ((this.track1Data[n8] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block44;
                                        }
                                        --n8;
                                    }
                                    break;
                                }
                                case 34: {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track1 is Type B");
                                    this.track1Type = (char)66;
                                    n7 = this.track1Data.length - 1;
                                    while (n7 >= 0) {
                                        if ((this.track1Data[n7] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block44;
                                        }
                                        --n7;
                                    }
                                    break;
                                }
                                default: {
                                    this.track1Type = (char)67;
                                }
                            }
                        }
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track1 type was identified");
                        if (POSSMSRServiceImp.this.serviceState.getDecodeData()) {
                            int n10;
                            int n11;
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Decoding track1Data with length : " + this.track1Data.length);
                            if (this.track1Data.length > 0) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Starting track1 decoding");
                                this.track1Encoding = 6;
                                n8 = 0;
                                n7 = this.track1Data.length;
                                while (n8 < n7) {
                                    if ((this.track1Data[n8] & 0xC0) != 0) {
                                        this.track1Encoding = 7;
                                        break;
                                    }
                                    ++n8;
                                }
                                if (this.track1Encoding == 6 && this.track1Data[0] != 33 && this.track1Data[0] != 34) {
                                    this.track1Encoding = 7;
                                }
                                if (this.track1Encoding == 6) {
                                    n11 = 0;
                                    n10 = this.track1Data.length;
                                    while (n11 < n10) {
                                        int n12 = n11++;
                                        this.track1Data[n12] = (byte)(this.track1Data[n12] + 32);
                                    }
                                }
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track1 decoded");
                            }
                            this.track2Encoding = 4;
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Starting track2 decoding");
                            n8 = 0;
                            n7 = this.track2Data.length;
                            while (n8 < n7) {
                                if ((this.track2Data[n8] & 0xF0) != 0) {
                                    this.track2Encoding = 7;
                                    break;
                                }
                                ++n8;
                            }
                            if (this.track2Encoding == 4) {
                                n11 = 0;
                                n10 = this.track2Data.length;
                                while (n11 < n10) {
                                    int n13 = n11++;
                                    this.track2Data[n13] = (byte)(this.track2Data[n13] + 48);
                                }
                            }
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "track2 decoded");
                            if (this.track3Data.length > 0) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Starting track3 decoding");
                                this.track3Encoding = 4;
                                n11 = 0;
                                n10 = this.track3Data.length;
                                while (n11 < n10) {
                                    if ((this.track3Data[n11] & 0xF0) != 0) {
                                        this.track3Encoding = 7;
                                        break;
                                    }
                                    ++n11;
                                }
                                if (this.track3Encoding == 4) {
                                    int n14 = 0;
                                    int n15 = this.track3Data.length;
                                    while (n14 < n15) {
                                        int n16 = n14++;
                                        this.track3Data[n16] = (byte)(this.track3Data[n16] + 48);
                                    }
                                }
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "track3 decoded");
                            }
                        }
                        if (POSSMSRServiceImp.this.serviceState.getParseDecodeData()) {
                            if (this.track1Data.length > 0) {
                                this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track1Data));
                                this.msrDataParser.start(1, this);
                            }
                            if (this.track2Data.length > 0) {
                                if (this.msrDataParser == null) {
                                    this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track2Data));
                                } else {
                                    this.msrDataParser.ReInit(new ByteArrayInputStream(this.track2Data));
                                }
                                this.msrDataParser.start(2, this);
                            }
                        }
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Track data was parsed");
                        if (this.jposEvent != null) break block111;
                        n8 = 0;
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "No errors detected");
                        n8 |= this.track1Data.length & 0xFF;
                        n8 |= this.track2Data.length << 8 & 0xFF00;
                        n8 |= this.track3Data.length << 16 & 0xFF0000;
                        this.jposEvent = new DataEvent(POSSMSRServiceImp.this.eventSource, n8 |= this.trackJData.length << 24 & 0xFF000000);
                    }
                    Object var22_21 = null;
                }
                catch (Throwable throwable) {
                    Object var22_23 = null;
                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Clean system");
                    MSRServiceState mSRServiceState = POSSMSRServiceImp.this.serviceState;
                    synchronized (mSRServiceState) {
                        if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                            try {
                                POSSMSRServiceImp.this.posDevice.ioctl(306);
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device was unlocked");
                            }
                            catch (PosException posException) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problem when unlocking device");
                            }
                            POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device enabled");
                        } else {
                            try {
                                POSSMSRServiceImp.this.posDevice.ioctl(303);
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "No problem at all finished");
                            }
                            catch (PosException posException) {
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problems when locking device");
                            }
                            POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device disable");
                        }
                    }
                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "FAILURE! Exit");
                    this.errorEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, n2, n3);
                    throw throwable;
                }
                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Clean system");
                MSRServiceState mSRServiceState = POSSMSRServiceImp.this.serviceState;
                synchronized (mSRServiceState) {
                    if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                        try {
                            POSSMSRServiceImp.this.posDevice.ioctl(306);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device was unlocked");
                        }
                        catch (PosException posException) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problem when unlocking device");
                        }
                        POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device enabled");
                    } else {
                        try {
                            POSSMSRServiceImp.this.posDevice.ioctl(303);
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "No problem at all finished");
                        }
                        catch (PosException posException) {
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problems when locking device");
                        }
                        POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device disable");
                    }
                }
                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "FAILURE! Exit");
                this.errorEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, n2, n3);
                {
                    break block115;
                    catch (Exception exception) {
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "There was an error");
                        this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                        if (this.errorReportingType == 0) {
                            this.track1Data = new byte[0];
                            this.track2Data = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                            this.accountNumber = "";
                            this.expirationDate = "";
                            this.firstName = "";
                            this.middleInitial = "";
                            this.serviceCode = "";
                            this.suffix = "";
                            this.surname = "";
                            this.title = "";
                            this.track1Data = new byte[0];
                            this.track1DiscretionaryData = new byte[0];
                            this.track2Data = new byte[0];
                            this.track2DiscretionaryData = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                            Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Fields were reset");
                        }
                        Object var22_22 = null;
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Clean system");
                        MSRServiceState mSRServiceState2 = POSSMSRServiceImp.this.serviceState;
                        synchronized (mSRServiceState2) {
                            if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                                try {
                                    POSSMSRServiceImp.this.posDevice.ioctl(306);
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device was unlocked");
                                }
                                catch (PosException posException) {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problem when unlocking device");
                                }
                                POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device enabled");
                            } else {
                                try {
                                    POSSMSRServiceImp.this.posDevice.ioctl(303);
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "No problem at all finished");
                                }
                                catch (PosException posException) {
                                    Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Problems when locking device");
                                }
                                POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                                Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "Device disable");
                            }
                        }
                        Tracer.trace(4, "POSSMSREventContainer", "POSSMSREventContainer()", "FAILURE! Exit");
                        this.errorEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, n2, n3);
                    }
                }
            }
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getExpirationDate() {
            return this.expirationDate;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleInitial() {
            return this.middleInitial;
        }

        public String getServiceCode() {
            return this.serviceCode;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getSurname() {
            return this.surname;
        }

        public String getTitle() {
            return this.title;
        }

        public byte[] getTrack1DiscretionaryData() {
            return this.track1DiscretionaryData;
        }

        public byte[] getTrack2DiscretionaryData() {
            return this.track2DiscretionaryData;
        }

        public void setAccountNumber(String string) {
            this.accountNumber = string;
        }

        public void setExpirationDate(String string) {
            this.expirationDate = string;
        }

        public void setFirstName(String string) {
            this.firstName = string;
        }

        public void setMiddleInitial(String string) {
            this.middleInitial = string;
        }

        public void setServiceCode(String string) {
            this.serviceCode = string;
        }

        public void setSuffix(String string) {
            this.suffix = string;
        }

        public void setSurname(String string) {
            this.surname = string;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setTrack1DiscretionaryData(byte[] byArray) {
            this.track1DiscretionaryData = byArray;
        }

        public void setTrack2DiscretionaryData(byte[] byArray) {
            this.track2DiscretionaryData = byArray;
        }
    }

    private class PosDeviceListener
    implements PosmMsrDataAvailListener {
        private PosDeviceListener() {
        }

        public void posmMsrDataAvail(short s) {
            Tracer.trace(4, "PosDeviceListener", "posmMSRDataAvail()", "Entry");
            if (POSSMSRServiceImp.this.serviceState.getDeviceEnabled()) {
                try {
                    POSSMSRServiceImp.this.getEventQueueManager().postEvent(new POSSMSREventContainer(s));
                }
                catch (Exception exception) {
                    Tracer.trace(4, "PosDeviceListener", "posmMSRDataAvail()", "Caught Exception on EventQueueManager");
                    try {
                        Tracer.trace(4, "PosDeviceListener", "PosDeviceListener()", "Unlock device");
                        POSSMSRServiceImp.this.posDevice.ioctl(306);
                    }
                    catch (PosException posException) {
                        Tracer.trace(4, "PosDeviceListener", "PosDeviceListener()", "Error when unlocking device");
                    }
                }
            } else {
                byte[] byArray = new byte[s];
                try {
                    POSSMSRServiceImp.this.posDevice.read(byArray);
                }
                catch (PosException posException) {
                    Tracer.trace(4, "PosDeviceListener", "PosDeviceListener()", "Error when reading buffer");
                }
            }
            Tracer.trace(4, "PosDeviceListener", "PosDeviceListener()", "Exit");
        }
    }
}

