/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.Tracer;

public final class Semaphore {
    private boolean value;
    private boolean doTrace = false;
    private String name = "";
    private long sem_num;
    private static String className = "Semaphore";
    private static long currentSemNum = 0L;

    public Semaphore() {
        this(false, false, "");
    }

    public Semaphore(boolean bl) {
        this(bl, false, "");
    }

    public Semaphore(boolean bl, boolean bl2, String string) {
        this.value = bl;
        this.doTrace = bl2;
        this.name = string;
        if (this.doTrace) {
            this.sem_num = ++currentSemNum;
            Tracer.trace(3, className, "Semaphore", " Sem " + string + this.sem_num + " is created. Init to " + bl);
        }
    }

    public Semaphore(boolean bl, boolean bl2) {
        this(bl, bl2, "");
    }

    public synchronized int waitForSet() {
        int n = 0;
        if (this.doTrace) {
            Tracer.trace(3, className, "Semaphore", "waitForSet " + this.name + this.sem_num);
        }
        while (!this.value) {
            try {
                if (this.doTrace) {
                    Tracer.trace(3, className, "Semaphore", " Sem " + this.name + this.sem_num + " waiting forever");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " finished waiting forever");
        }
        return n;
    }

    public synchronized int waitForSet(long l) {
        int n = 0;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "waitForSet(" + l + ") " + this.name + this.sem_num);
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " waiting " + l + " millisecs.");
        }
        try {
            if (!this.value) {
                if (this.doTrace) {
                    Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is false, waiting " + l + " millisecs.");
                }
                this.wait(l);
            } else if (this.doTrace) {
                Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is set, not waiting.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " finished waiting " + l + " millisecs.");
        }
        if (!this.value) {
            n = 112;
            if (this.doTrace) {
                Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is false, returning " + n);
            }
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "waitForSet(" + l + ") exit rc = " + n);
        }
        return n;
    }

    public synchronized void set() {
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Set sem " + this.name + this.sem_num);
        }
        this.value = true;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Sem " + this.name + this.sem_num + " is " + this.value + ", notifiying");
        }
        this.notify();
    }

    public synchronized void reset() {
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Reset sem " + this.name + this.sem_num);
        }
        this.value = false;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Sem " + this.name + this.sem_num + " is " + this.value + ", notifiying");
        }
        this.notify();
    }

    public boolean isOn() {
        return this.value;
    }

    public boolean isOff() {
        return !this.value;
    }
}

