/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services;

import br.com.auttar.clientservices.model.CancelTransaction;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.Payment;
import br.com.auttar.clientservices.model.PaymentResult;
import br.com.auttar.clientservices.model.SearchCheckout;
import br.com.auttar.clientservices.model.TaxReceiptRequest;
import br.com.auttar.clientservices.services.BaseListenerService;
import br.com.auttar.clientservices.services.CheckoutListener;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.PaymentListener;
import br.com.auttar.clientservices.services.PaymentRequestListener;
import br.com.auttar.clientservices.services.PaymentResultListener;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.clientservices.services.TaxReceiptListener;
import java.util.ArrayList;
import java.util.List;

public class BaseService
implements BaseListenerService {
    private List<PaymentRequestListener> paymentRequestListeners;
    private List<PaymentResultListener> paymentResultListeners;
    private List<CheckoutListener> checkoutRequestListeners;
    private List<TaxReceiptListener> taxReceiptListeners;
    private List<PaymentListener> paymentListeners;
    private Configuration configuration;

    public BaseService(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void addPaymentRequestListener(PaymentRequestListener paymentRequestListener) {
        if (paymentRequestListener != null) {
            if (this.paymentRequestListeners == null) {
                this.paymentRequestListeners = new ArrayList<PaymentRequestListener>();
            }
            this.paymentRequestListeners.add(paymentRequestListener);
        }
    }

    @Override
    public void removePaymentRequestListener(PaymentRequestListener paymentRequestListener) {
        if (this.paymentRequestListeners != null) {
            this.paymentRequestListeners.remove(paymentRequestListener);
        }
    }

    protected void firePaymenteRequestListener(SessionMessage sessionMessage, Checkout checkout) {
        if (this.paymentRequestListeners != null) {
            for (PaymentRequestListener listener : this.paymentRequestListeners) {
                listener.onGetPayment(sessionMessage, checkout);
            }
        }
    }

    @Override
    public void addPaymentResultListener(PaymentResultListener listener) {
        if (listener != null) {
            if (this.paymentResultListeners == null) {
                this.paymentResultListeners = new ArrayList<PaymentResultListener>();
            }
            this.paymentResultListeners.add(listener);
        }
    }

    @Override
    public void removePaymentResultListener(PaymentResultListener listener) {
        if (this.paymentResultListeners != null) {
            this.paymentResultListeners.remove(listener);
        }
    }

    protected void firePaymenteResultListener(SessionMessage sessionMessage, PaymentResult paymentResult) {
        if (this.paymentResultListeners != null) {
            for (PaymentResultListener listener : this.paymentResultListeners) {
                listener.onPaymentResult(sessionMessage, paymentResult);
            }
        }
    }

    @Override
    public void addCheckoutListener(CheckoutListener listener) {
        if (listener != null) {
            if (this.checkoutRequestListeners == null) {
                this.checkoutRequestListeners = new ArrayList<CheckoutListener>();
            }
            this.checkoutRequestListeners.add(listener);
        }
    }

    @Override
    public void removeCheckoutListener(CheckoutListener listener) {
        if (this.checkoutRequestListeners != null) {
            this.checkoutRequestListeners.remove(listener);
        }
    }

    protected void fireCheckoutListener(SessionMessage sessionMessage, SearchCheckout searchCheckout) {
        if (this.checkoutRequestListeners != null) {
            for (CheckoutListener listener : this.checkoutRequestListeners) {
                listener.onGetCheckout(sessionMessage, searchCheckout);
            }
        }
    }

    protected void fireCheckoutStartPaymentListener(SessionMessage sessionMessage, Checkout checkout) {
        if (this.checkoutRequestListeners != null) {
            for (CheckoutListener listener : this.checkoutRequestListeners) {
                listener.onPostStartPayment(sessionMessage, checkout);
            }
        }
    }

    protected void fireCheckoutCancelPaymentListener(SessionMessage sessionMessage, Checkout checkout) {
        if (this.checkoutRequestListeners != null) {
            for (CheckoutListener listener : this.checkoutRequestListeners) {
                listener.onPostCancelPayment(sessionMessage, checkout);
            }
        }
    }

    @Override
    public void addTaxReceiptListener(TaxReceiptListener listener) {
        if (listener != null) {
            if (this.taxReceiptListeners == null) {
                this.taxReceiptListeners = new ArrayList<TaxReceiptListener>();
            }
            this.taxReceiptListeners.add(listener);
        }
    }

    @Override
    public void removeTaxReceiptListener(TaxReceiptListener listener) {
        if (this.taxReceiptListeners != null) {
            this.taxReceiptListeners.remove(listener);
        }
    }

    protected void fireTaxReceiptListener(SessionMessage sessionMessage, TaxReceiptRequest taxReceiptRequest) {
        if (this.taxReceiptListeners != null) {
            for (TaxReceiptListener listener : this.taxReceiptListeners) {
                if (sessionMessage.getType() == SessionMessageType.get_tax_receipt) {
                    listener.onGetTaxReceipt(sessionMessage, taxReceiptRequest);
                    continue;
                }
                if (sessionMessage.getType() != SessionMessageType.post_tax_receipt_generate) continue;
                listener.onTaxReceiptGenerate(sessionMessage, taxReceiptRequest);
            }
        }
    }

    @Override
    public void addPaymentListener(PaymentListener listener) {
        if (this.paymentListeners == null) {
            this.paymentListeners = new ArrayList<PaymentListener>();
        }
        this.paymentListeners.add(listener);
    }

    @Override
    public void removePaymentListener(PaymentListener listener) {
        if (this.paymentListeners != null) {
            this.paymentListeners.remove(listener);
        }
    }

    protected void firePaymentListerner(SessionMessage sessionMessage, Payment payment) {
        if (this.paymentListeners != null) {
            for (PaymentListener listener : this.paymentListeners) {
                listener.onPayment(sessionMessage, payment);
            }
        }
    }

    protected void fireCancelTransactionListerner(SessionMessage sessionMessage, CancelTransaction cancelTransaction) {
        if (this.paymentListeners != null) {
            for (PaymentListener listener : this.paymentListeners) {
                listener.onCancelTransaction(sessionMessage, cancelTransaction);
            }
        }
    }
}

