/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.http;

import br.com.auttar.clientservices.model.SettingsModel;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.ampq.ClientAMQPPublisherService;
import br.com.auttar.clientservices.util.builder.CashSettingsBuilder;
import br.com.auttar.clientservices.util.builder.HttpExchangeBuilder;
import br.com.auttar.clientservices.util.builder.PropertiesBuilder;
import br.com.auttar.clientservices.util.builder.SettingsModelBuilder;
import br.com.auttar.clientservices.util.config.CashSettingsService;
import br.com.auttar.clientservices.util.config.ConfigurationService;
import br.com.auttar.framework.http.HttpResponse;
import br.com.auttar.framework.http.HttpResponseBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpHandlerForSettings
implements HttpHandler {
    private ClientAMQPPublisherService clientAMQPPublisherService;
    private Configuration configuration = null;
    private Log logger = LogFactory.getLog(HttpHandlerForSettings.class);

    public HttpHandlerForSettings(Configuration configuration) {
        this.clientAMQPPublisherService = new ClientAMQPPublisherService(configuration);
        this.setConfiguration(configuration);
    }

    public void connect() throws Exception {
        this.clientAMQPPublisherService.startUp();
    }

    public void disconnect() throws Exception {
        this.clientAMQPPublisherService.endUp();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        HttpResponse httpResponse = null;
        try {
            String request = HttpExchangeBuilder.requestBodyAsString(t);
            this.publisherToQueueFromJsonAndConfiguration(request);
            httpResponse = HttpResponseBuilder.buildCreated();
        }
        catch (JsonParseException e) {
            this.logger.error((Object)e.getMessage());
            httpResponse = HttpResponseBuilder.buildBadRequest(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)("Error when handling the http request: " + e.getMessage()));
            httpResponse = HttpResponseBuilder.build(e);
        }
        String response = httpResponse.toJson();
        t.sendResponseHeaders(httpResponse.getStatus(), response.getBytes().length);
        this.logger.info((Object)("response: " + response));
        OutputStream os = t.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }

    public void publisherToQueueFromPropertiesAndConfiguration(Properties properties) throws Exception {
        SettingsModel settings = SettingsModelBuilder.buildFromPropertiesAndConfiguration(properties, this.getConfiguration());
        this.publisherToQueue(settings);
    }

    public void publisherToQueueFromJsonAndConfiguration(String request) throws Exception {
        SettingsModel settings = SettingsModelBuilder.buildFromJsonAndConfiguration(request, this.getConfiguration());
        this.publisherToQueue(settings);
    }

    public void publisherToQueue(SettingsModel settings) throws Exception {
        this.logger.info((Object)("request: " + settings.toJsonString()));
        String responseQueue = "";
        Integer statusQueue = 0;
        File configurationFile = new File("clientservices-http.properties");
        Properties properties = PropertiesBuilder.buildFromSettingsModel(settings, configurationFile);
        ConfigurationService configurationService = new ConfigurationService(configurationFile);
        configurationService.save(properties);
        responseQueue = this.clientAMQPPublisherService.postGet("", "post.settings_automation", settings.toJsonString());
        if (responseQueue != null) {
            JsonObject responseQueueJsonObject = new JsonParser().parse(responseQueue).getAsJsonObject();
            statusQueue = Integer.parseInt(responseQueueJsonObject.get("status").toString());
        }
        File cashSettingsForExceptionFile = new File("cash_settings_for_exception.properties");
        if (statusQueue < 200 || statusQueue > 299) {
            Properties cashSettings = CashSettingsBuilder.buildFromSettingsModel(settings);
            CashSettingsService cashSettingsService = new CashSettingsService(cashSettingsForExceptionFile);
            cashSettingsService.save(cashSettings);
        } else if (cashSettingsForExceptionFile.exists()) {
            cashSettingsForExceptionFile.delete();
        }
    }
}

