/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.os.DefaultUsbDeviceOsImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.ibm.jusb.os.windows.WindowsControlRequest;
import com.ibm.jusb.os.windows.WindowsDeviceProxy;
import com.ibm.jusb.os.windows.WindowsRequest;
import com.ibm.jusb.os.windows.WindowsSetConfigurationRequest;
import com.ibm.jusb.os.windows.WindowsSetInterfaceRequest;
import java.util.List;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbPlatformException;
import javax.usb.util.UsbUtil;

class WindowsDeviceOsImp
extends DefaultUsbDeviceOsImp
implements UsbDeviceOsImp {
    private UsbDeviceImp usbDeviceImp = null;
    private WindowsDeviceProxy windowsDeviceProxy = null;

    public WindowsDeviceOsImp(UsbDeviceImp device, WindowsDeviceProxy proxy) {
        this.setUsbDeviceImp(device);
        this.setWindowsDeviceProxy(proxy);
    }

    public void asyncSubmit(UsbControlIrpImp usbControlIrpImp) throws UsbException {
        WindowsControlRequest request = null;
        request = usbControlIrpImp.isSetConfiguration() ? new WindowsSetConfigurationRequest() : (usbControlIrpImp.isSetInterface() ? new WindowsSetInterfaceRequest() : new WindowsControlRequest());
        ((WindowsControlRequest)request).setUsbIrpImp(usbControlIrpImp);
        this.submit(request);
    }

    public UsbDeviceImp getUsbDeviceImp() {
        return this.usbDeviceImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsDeviceProxy getWindowsDeviceProxy() throws UsbException {
        if (this.windowsDeviceProxy != null) {
            WindowsDeviceProxy windowsDeviceProxy = this.windowsDeviceProxy;
            synchronized (windowsDeviceProxy) {
                if (!this.windowsDeviceProxy.isRunning()) {
                    this.windowsDeviceProxy.start();
                }
            }
        } else {
            throw new UsbException();
        }
        return this.windowsDeviceProxy;
    }

    public void setUsbDeviceImp(UsbDeviceImp device) {
        this.usbDeviceImp = device;
    }

    public void setWindowsDeviceProxy(WindowsDeviceProxy proxy) {
        this.windowsDeviceProxy = proxy;
    }

    protected void checkUnclaimedInterface(UsbControlIrpImp irp) throws UsbPlatformException {
        UsbInterface iface;
        if (64 == (byte)(0x60 & irp.bmRequestType())) {
            return;
        }
        if (1 == (byte)(0x1F & irp.bmRequestType())) {
            byte ifacenum = (byte)irp.wIndex();
            iface = this.interfaceNumberToUsbInterface(ifacenum);
            String iStr = "0x" + UsbUtil.toHexString((byte)ifacenum);
            if (null == iface) {
                IllegalArgumentException iaE = new IllegalArgumentException("No active interface with number " + iStr);
                throw new UsbPlatformException("Request with recipient interface " + iStr + ", but no such interface in current active configuration", (Exception)iaE);
            }
            if (!iface.isClaimed()) {
                UsbNotClaimedException uncE = new UsbNotClaimedException("Interface " + iStr + " is not claimed");
                throw new UsbPlatformException("Request with recipient interface " + iStr + ", but interface is not claimed", (Exception)uncE);
            }
        }
        if (2 == (byte)(0x1F & irp.bmRequestType())) {
            byte epNum = (byte)irp.wIndex();
            if (0 == epNum) {
                return;
            }
            iface = this.endpointAddressToUsbInterface(epNum);
            String eStr = "0x" + UsbUtil.toHexString((byte)epNum);
            if (null == iface) {
                IllegalArgumentException iaE = new IllegalArgumentException("No active enpoint with address " + eStr);
                throw new UsbPlatformException("Request with recipient endpoint " + eStr + ", but no such endpoint in current active configuration and interfaces", (Exception)iaE);
            }
            if (!iface.isClaimed()) {
                String iStr = "0x" + UsbUtil.toHexString((byte)iface.getUsbInterfaceDescriptor().bInterfaceNumber());
                UsbNotClaimedException uncE = new UsbNotClaimedException("Interface " + iStr + ", which owns endpoint " + eStr + ", is not claimed");
                throw new UsbPlatformException("Request with recipient endpoint " + eStr + " which belongs to interface " + iStr + ", but interface is not claimed", (Exception)uncE);
            }
        }
    }

    protected UsbInterface endpointAddressToUsbInterface(byte addr) {
        List ifaces = this.getUsbDeviceImp().getActiveUsbConfiguration().getUsbInterfaces();
        for (int i = 0; i < ifaces.size(); ++i) {
            UsbInterface iface = (UsbInterface)ifaces.get(i);
            List eps = iface.getUsbEndpoints();
            for (int e = 0; e < eps.size(); ++e) {
                UsbEndpoint ep = (UsbEndpoint)eps.get(e);
                if (ep.getUsbEndpointDescriptor().bEndpointAddress() != addr) continue;
                return iface;
            }
        }
        return null;
    }

    protected UsbInterface interfaceNumberToUsbInterface(byte num) {
        return this.getUsbDeviceImp().getActiveUsbConfiguration().getUsbInterface(num);
    }

    void cancel(WindowsRequest request) {
        try {
            this.getWindowsDeviceProxy().cancel(request);
        }
        catch (UsbException uE) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void submit(WindowsRequest request) throws UsbException {
        this.getWindowsDeviceProxy().submit(request);
    }

    public void releaseWindowsDeviceProxy() {
        this.windowsDeviceProxy = null;
    }
}

