/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.ByteArrayCollector;
import com.ibm.jutil.patterns.factory.AbstractPoolFactory;
import com.ibm.jutil.patterns.factory.AbstractRecyclableObject;
import com.ibm.jutil.patterns.factory.RecyclableObject;
import com.ibm.jutil.patterns.factory.RecycleFactory;
import com.ibm.jutil.patterns.factory.RecycleFactoryException;
import com.ibm.jutil.tracing.Tracing;
import java.util.ConcurrentModificationException;

public class ByteBuffer
extends AbstractRecyclableObject {
    protected byte[] byteArray;
    protected int byteCount = 0;
    protected int capacityIncrement;
    protected int startIndex = 0;
    boolean recycled = false;
    private static final ByteBufferFactory factory = new ByteBufferFactory(new RecycleFactory.CreateMethod(){

        public RecyclableObject newRecyclableObject(RecycleFactory recycleFactory) {
            return new ByteBuffer(recycleFactory);
        }

        public RecyclableObject newRecyclableObject(RecyclableObject.CtorArg[] ctorArgs, RecycleFactory recycleFactory) throws RecycleFactoryException {
            throw new RecycleFactoryException("Parameters not supported");
        }
    });

    public ByteBuffer() {
        this(16, 16);
    }

    public ByteBuffer(int initialCapacity, int capacityIncrement) {
        this(ByteBuffer.getByteBufferFactory());
        this.byteArray = ByteArrayCollector.getCollector().getArray(initialCapacity);
        this.byteCount = 0;
        this.capacityIncrement = capacityIncrement;
        this.startIndex = 0;
        this.recycled = false;
    }

    public ByteBuffer(int initialCapacity) {
        this(initialCapacity, 16);
    }

    public ByteBuffer(RecycleFactory recycleFactory) {
        super(recycleFactory);
        if (null == this.byteArray) {
            int initialCapacity = 16;
            try {
                initialCapacity = ((ByteBufferFactory)recycleFactory).getInitialCapacity();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.byteArray = ByteArrayCollector.getCollector().getArray(initialCapacity);
            this.byteCount = 0;
            this.capacityIncrement = 16;
            this.startIndex = 0;
            this.recycled = false;
        }
    }

    public ByteBuffer(byte[] initArray) {
        this(16, 16);
        ByteArrayCollector.getCollector().collect(this.byteArray);
        this.byteArray = initArray;
        this.setByteCount(this.byteArray.length, false);
        this.recycled = false;
    }

    public byte[] replace(byte[] x) {
        byte[] old = this.byteArray;
        this.byteArray = x;
        this.byteCount = x.length;
        return old;
    }

    public void setByteCount(int size, boolean clear) {
        if (size > this.byteArray.length) {
            byte[] newByteArray = ByteArrayCollector.getCollector().getArray(size);
            if (clear) {
                System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
            }
            ByteArrayCollector.getCollector().collect(this.byteArray);
            this.byteArray = newByteArray;
        }
        if (clear) {
            for (int i = this.byteCount; i < size; ++i) {
                this.byteArray[i] = 0;
            }
        }
        this.byteCount = size;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public void setStartIndex(int start) {
        this.startIndex = start;
        if (this.startIndex >= this.byteArray.length) {
            this.setByteCount(this.startIndex + this.capacityIncrement, true);
        }
        this.byteCount = this.startIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public ByteBuffer append(byte[] bytes) {
        if (this.byteCount + bytes.length > this.byteArray.length) {
            int xsize = this.byteCount + bytes.length + this.capacityIncrement;
            byte[] newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
            ByteArrayCollector.getCollector().collect(this.byteArray);
            this.byteArray = newByteArray;
        }
        System.arraycopy(bytes, 0, this.byteArray, this.byteCount, bytes.length);
        this.byteCount += bytes.length;
        return this;
    }

    public ByteBuffer append(byte[] bytes, int beginIndex, int count) {
        block3: {
            if (this.byteCount + count > this.byteArray.length) {
                int xsize = this.byteCount + count + this.capacityIncrement;
                byte[] newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
                System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
                ByteArrayCollector.getCollector().collect(this.byteArray);
                this.byteArray = newByteArray;
            }
            try {
                System.arraycopy(bytes, beginIndex, this.byteArray, this.byteCount, count);
            }
            catch (Exception aa) {
                if (!Tracing.isOn()) break block3;
                Tracing.println("ERROR " + String.valueOf(bytes.length) + "," + String.valueOf(beginIndex) + "," + String.valueOf(this.byteArray.length) + "," + String.valueOf(this.byteCount) + "," + String.valueOf(count));
            }
        }
        this.byteCount += count;
        return this;
    }

    public ByteBuffer append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteBuffer insert(byte b, int index) {
        byte[] newByteArray;
        if (index < this.byteCount) {
            int xsize = this.byteCount + 1;
            if (xsize > this.byteArray.length) {
                xsize += this.capacityIncrement;
            }
            newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.byteArray, 0, newByteArray, 0, index);
            newByteArray[index] = b;
            System.arraycopy(this.byteArray, index, newByteArray, index + 1, this.byteCount - index);
            ByteArrayCollector.getCollector().collect(this.byteArray);
            ++this.byteCount;
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.byteArray = newByteArray;
        return this;
    }

    public ByteBuffer append(byte b) {
        if (this.byteCount + 1 > this.byteArray.length) {
            int xsize = this.byteCount + 1 + this.capacityIncrement;
            byte[] newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
            ByteArrayCollector.getCollector().collect(this.byteArray);
            this.byteArray = newByteArray;
        }
        this.byteArray[this.byteCount++] = b;
        return this;
    }

    public ByteBuffer append(ByteBuffer buf) {
        if (this.byteCount + buf.getByteCount() > this.byteArray.length) {
            int xsize = this.byteCount + buf.getByteCount() + this.capacityIncrement;
            byte[] newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
            ByteArrayCollector.getCollector().collect(this.byteArray);
            this.byteArray = newByteArray;
        }
        System.arraycopy(buf.byteArray, 0, this.byteArray, this.byteCount, buf.getByteCount());
        this.byteCount += buf.getByteCount();
        return this;
    }

    public byte[] getBytes() {
        byte[] newByteArray = ByteArrayCollector.getCollector().getArray(this.byteCount);
        System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
        return newByteArray;
    }

    public byte[] getBytesRef() {
        return this.byteArray;
    }

    public void reset() {
        this.byteCount = this.startIndex;
    }

    public byte byteAt(int index) {
        if (index < this.byteCount) {
            return this.byteArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ByteBuffer copy(byte[] fromArray, int fromIndex, int toIndex, int count) {
        if (toIndex + count + 1 > this.byteArray.length) {
            int xsize = toIndex + count + 1 + this.capacityIncrement;
            byte[] newByteArray = ByteArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.byteArray, 0, newByteArray, 0, this.byteCount);
            ByteArrayCollector.getCollector().collect(this.byteArray);
            this.byteArray = newByteArray;
        }
        System.arraycopy(fromArray, fromIndex, this.byteArray, toIndex, count);
        this.byteCount = toIndex + count > this.byteCount ? toIndex + count : this.byteCount;
        return this;
    }

    public ByteBuffer setByte(byte byteValue, int index) {
        if (index >= this.byteCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.byteArray[index] = byteValue;
        return this;
    }

    public void clean() {
        this.reset();
    }

    public void recycle() {
        if (null == this.getRecycleFactory()) {
            return;
        }
        super.recycle();
        this.recycled = true;
    }

    public static synchronized ByteBufferFactory getByteBufferFactory() {
        return factory;
    }

    public static class ByteBufferFactory
    extends AbstractPoolFactory {
        int initialCap = 16;

        public ByteBufferFactory(RecycleFactory.CreateMethod cm) {
            super(cm, 1, 0, 1.0f);
        }

        public int getInitialCapacity() {
            return this.initialCap;
        }

        public void setInitialCapacity(int cap) {
            this.initialCap = cap;
        }

        public ByteBuffer createByteBuffer() {
            ByteBuffer ret = null;
            while (ret == null) {
                try {
                    ret = (ByteBuffer)super.takeFromPool();
                }
                catch (ConcurrentModificationException cme) {
                    Tracing.print(cme);
                }
            }
            return ret;
        }

        public ByteBuffer createByteBuffer(int initialSize) {
            this.initialCap = initialSize;
            return this.createByteBuffer();
        }
    }
}

