/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.BooleanMonitor;
import com.ibm.jutil.DefaultProperties;
import com.ibm.jutil.JUtilProperties;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public abstract class Collector {
    private static Tracer cTracer = TracerFactory.getInstance().createTracer("Collector");
    private BooleanMonitor dirty;
    private Hashtable htable = new Hashtable(10);
    private Thread janitor = null;
    private JUtilProperties props = null;
    public static Integer WAIT_TIME = null;
    public static final String CLEAN_PROPERTY = "com.ibm.jutil.cleantime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collector() {
        this.dirty = new BooleanMonitor(false);
        this.janitor = new Thread(new Cleanup(this.dirty));
        this.janitor.start();
        String string = CLEAN_PROPERTY;
        synchronized (CLEAN_PROPERTY) {
            if (this.props == null) {
                this.props = new DefaultProperties();
                this.props.loadProperties();
                if (this.props.isPropertyDefined(CLEAN_PROPERTY)) {
                    try {
                        WAIT_TIME = new Integer(this.props.getIntProperty(CLEAN_PROPERTY));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (null == WAIT_TIME) {
                WAIT_TIME = new Integer(4200);
            }
            return;
        }
    }

    public Object getObject(int size) {
        try {
            Storage item;
            Integer key = new Integer(size);
            if (this.htable.containsKey(key) && (item = (Storage)this.htable.get(key)).getIndexSize() == size) {
                return item.getObject();
            }
        }
        catch (Exception e) {
            cTracer.print(e);
        }
        return this.makeNew(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Object b, int len) {
        this.dirty.set(true);
        if (len == 0) {
            return;
        }
        Hashtable hashtable = this.htable;
        synchronized (hashtable) {
            Integer key = new Integer(len);
            Storage item = null;
            if (this.htable.containsKey(key)) {
                item = (Storage)this.htable.get(key);
                item.add(b);
                return;
            }
            this.htable.put(key, this.newStorage(len, b));
        }
    }

    public int total() {
        int t = 0;
        Enumeration en = this.htable.elements();
        while (en.hasMoreElements()) {
            Storage item = (Storage)en.nextElement();
            t += item.getStoreCnt();
        }
        return t;
    }

    public void reset() {
        this.htable.clear();
    }

    public boolean isEmpty() {
        return this.htable.isEmpty();
    }

    protected abstract Storage newStorage(int var1, Object var2);

    protected abstract Object makeNew(int var1);

    protected class Cleanup
    implements Runnable {
        private List list = null;
        private BooleanMonitor clean;
        public static final int STANDARD = 2;

        Cleanup(BooleanMonitor clean) {
            this.clean = clean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(WAIT_TIME.intValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.clean.waitForTrue(-1);
                    this.clean.set(false);
                    Hashtable e = Collector.this.htable;
                    synchronized (e) {
                        Enumeration en = Collector.this.htable.elements();
                        while (en.hasMoreElements()) {
                            Storage item = (Storage)en.nextElement();
                            if (2 > item.getUseCnt()) {
                                Collector.this.htable.remove(new Integer(item.getIndexSize()));
                            }
                            item.resetUseCnt();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    protected abstract class Storage
    implements Comparator {
        private List list = new ArrayList(5);
        private int index;
        private short useCnt;

        Storage(int i, Object iObject) {
            this.index = i;
            this.list.add(iObject);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.getIndexSize() * 7);
            for (int i = 0; i < this.list.size(); ++i) {
                sb.append(" ").append(this.list.get(i)).append(" ");
            }
            return sb.toString();
        }

        public int getIndexSize() {
            return this.index;
        }

        public synchronized void add(Object o) {
            if (!this.list.contains(o)) {
                this.list.add(o);
            }
        }

        public abstract Object makeNew(int var1);

        public synchronized Object getObject() {
            if (0 >= this.list.size()) {
                return this.makeNew(this.index);
            }
            this.useCnt = (short)(this.useCnt + 1);
            Object anc = this.list.remove(0);
            return anc;
        }

        public void resetUseCnt() {
            this.useCnt = 0;
        }

        public int getUseCnt() {
            return this.useCnt;
        }

        public int getStoreCnt() {
            return this.list.size();
        }

        public int compare(Object o1, Object o2) {
            Storage s1 = (Storage)o1;
            Storage s2 = (Storage)o2;
            if (s1.getIndexSize() > s2.getIndexSize()) {
                return 1;
            }
            if (s1.getIndexSize() < s2.getIndexSize()) {
                return -1;
            }
            return 0;
        }
    }
}

