/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.AbstractLogStore;
import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogEntryFactory;
import com.ibm.jutil.logging.LogStore;
import java.util.Vector;

public abstract class AbstractLogger
implements Runnable {
    protected LogStore logStore = null;
    protected LogEntryFactory logFactory = null;
    private Vector entries = new Vector();
    private Thread logStoreThread = new Thread(this);
    private Object wakeup = new Object();
    private boolean saveLog = false;
    private boolean logSaved = false;
    private boolean errorSaving = false;
    private Exception errorException = null;
    private boolean running = true;
    private static String terminalID = "Terminal X";

    protected AbstractLogger() {
        this.initFromProperties();
        this.logStoreThread.start();
        this.logStoreThread.setName("AbstractLogger");
    }

    protected abstract void initFromProperties();

    public static void setTerminalID(String s) {
        terminalID = s;
    }

    public static String getTerminalID() {
        return terminalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(LogEntry entry) {
        this.entries.addElement(entry);
        if (this.entries.size() == 1) {
            Object object = this.wakeup;
            synchronized (object) {
                this.wakeup.notifyAll();
            }
        }
        if (!this.entries.isEmpty()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                this.logStore.add((LogEntry)this.entries.elementAt(i));
            }
            this.entries.removeAllElements();
        }
        this.logSaved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        this.saveLog = true;
        Object object = this.wakeup;
        synchronized (object) {
            this.wakeup.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            while (this.running && (this.entries.isEmpty() || !this.saveLog)) {
                Object object = this.wakeup;
                synchronized (object) {
                    try {
                        this.wakeup.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.running) break;
            if (!this.entries.isEmpty()) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    this.logStore.add((LogEntry)this.entries.elementAt(i));
                }
                this.entries.removeAllElements();
            }
            if (!this.saveLog) continue;
            try {
                this.logStore.flush();
                this.errorSaving = false;
                this.errorException = null;
            }
            catch (Exception e) {
                this.errorSaving = true;
                this.errorException = e;
            }
            this.saveLog = false;
            this.logSaved = !this.errorSaving;
        }
        this.logStore.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        this.running = false;
        Object object = this.wakeup;
        synchronized (object) {
            this.wakeup.notifyAll();
        }
    }

    public boolean isLogSaved() {
        return this.logSaved;
    }

    public boolean isErrorSaving() {
        return this.errorSaving;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isRunning() {
        return this.running;
    }

    public LogEntryFactory getLogEntryFactory() {
        return this.logFactory;
    }

    protected LogStore getLogStore() {
        return this.logStore;
    }

    protected AbstractLogStore getAbstractLogStore() {
        return (AbstractLogStore)this.logStore;
    }

    protected int getQueueSize() {
        return this.entries.size();
    }
}

