/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.DefaultUtilProperties;
import com.ibm.jutil.logging.AbstractLogStore;
import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogStore;
import com.ibm.jutil.logging.LoggerProperties;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.net.SocketAppender;

public class Log4jLogStore
extends AbstractLogStore
implements LogStore {
    private String logFileName;
    private String filePath;
    private String fileName;
    private String fileExt;
    private String configureFileName;
    private DefaultUtilProperties utilProperties;
    private File dir = null;
    private Appender appender;
    private Layout layout;
    private Logger log4jRootLogger;
    private Logger log4jLogger;
    private String hostName;
    private String hostIP;
    private String hostPort;
    private String remoteLogging;
    private boolean isRemoteLogging;
    private int hostPortNumber;
    private SocketAppender socketAppender;

    public void flush() {
        while (this.queue.size() > 0) {
            LogEntry entry = (LogEntry)this.queue.remove(0);
            String propertyName = "log4j.logger." + entry.getCategory();
            if (this.utilProperties.isPropertyDefined(propertyName)) {
                this.log4jLogger = Logger.getLogger((String)entry.getCategory());
                this.logFileName = this.getFileNameFromLogger(this.log4jLogger);
                if (this.isRemoteLogging) {
                    this.log4jLogger.addAppender((Appender)this.socketAppender);
                }
            } else {
                this.createLogger(entry.getCategory());
            }
            this.doLog(entry);
        }
        this.addFlag = false;
        this.flushFlag = true;
    }

    public void init() {
        this.initFromProperties();
        if (this.dir == null) {
            try {
                this.dir = new File(this.filePath);
                this.dir.mkdirs();
            }
            catch (Exception e) {
                System.err.println("Could not create " + this.filePath);
            }
        }
        if (this.configureFileName == null) {
            System.err.println("com.ibm.jutil.logging.default.Log4jLogStore.ConfigureFileName property not found, please add it to your Log.properties");
        } else {
            this.utilProperties = new DefaultUtilProperties(this.configureFileName);
            this.utilProperties.loadProperties();
            if (!this.utilProperties.isLoaded()) {
                this.utilProperties.loadPropertiesByName("log4jConfiguration.properties");
                this.utilProperties.storeProperties("Log4j Configuration File", this.configureFileName);
            }
            String configureFileNameBK = this.configureFileName.substring(0, this.configureFileName.lastIndexOf(".")) + ".bk";
            Enumeration names = this.utilProperties.getPropertyNames();
            while (names.hasMoreElements()) {
                String propName = (String)names.nextElement();
                String propValue = this.utilProperties.getStringProperty(propName);
                this.utilProperties.addProperty(propName, propValue);
            }
            this.utilProperties.storeProperties("Log4j properties", configureFileNameBK);
            PropertyConfigurator.configure((String)configureFileNameBK);
        }
    }

    public void close() {
        this.flush();
        if (this.isRemoteLogging) {
            this.socketAppender.close();
        }
    }

    protected String getTextFileName() {
        return this.logFileName;
    }

    protected String getPriorityName(int priorNumber) {
        String priorName = new String("");
        switch (priorNumber) {
            case 1: {
                priorName = "DEBUG";
                return priorName;
            }
            case 2: {
                priorName = "INFO";
                return priorName;
            }
            case 3: {
                priorName = "WARN";
                return priorName;
            }
            case 4: {
                priorName = "ERROR";
                return priorName;
            }
            case 5: {
                priorName = "FATAL";
                return priorName;
            }
        }
        return priorName;
    }

    protected void createLogger(String loggerName) {
        this.logFileName = this.filePath + File.separator + loggerName + this.fileExt;
        this.layout = new PatternLayout("%m%n");
        try {
            if (this.appender == null) {
                this.appender = new FileAppender(this.layout, this.logFileName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log4jLogger = Logger.getLogger((String)loggerName);
        if (this.isRemoteLogging) {
            this.log4jLogger.addAppender((Appender)this.socketAppender);
        } else {
            this.log4jLogger.addAppender(this.appender);
        }
    }

    protected String getFileNameFromLogger(Logger logger) {
        if (this.isRemoteLogging) {
            return null;
        }
        String fileName = new String("");
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            this.appender = (Appender)appenders.nextElement();
            if (!(this.appender instanceof FileAppender)) continue;
            FileAppender append = (FileAppender)this.appender;
            fileName = append.getFile();
        }
        return fileName;
    }

    protected void doLog(LogEntry entry) {
        switch (entry.getPriority()) {
            case 1: {
                this.log4jLogger.debug((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
                return;
            }
            case 2: {
                this.log4jLogger.info((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
                return;
            }
            case 3: {
                this.log4jLogger.warn((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
                return;
            }
            case 4: {
                this.log4jLogger.error((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
                return;
            }
            case 5: {
                this.log4jLogger.fatal((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
                return;
            }
        }
        this.log4jLogger.error((Object)("ID: " + entry.getIndex() + " MESSAGE: " + entry.getMessage()));
    }

    private void initFromProperties() {
        block7: {
            LoggerProperties.load();
            this.filePath = LoggerProperties.getProperty("com.ibm.jutil.logging.Log4jLogStore.LogFilePath", "com.ibm.jutil.logging.default.Log4jLogStore.LogFilePath");
            this.fileName = LoggerProperties.getProperty("com.ibm.jutil.logging.Log4jLogStore.LogFileName", "com.ibm.jutil.logging.default.Log4jLogStore.LogFileName");
            this.fileExt = LoggerProperties.getProperty("com.ibm.jutil.logging.Log4jLogStore.LogTextFileNameExt", "com.ibm.jutil.logging.default.Log4jLogStore.LogTextFileNameExt");
            this.configureFileName = LoggerProperties.getProperty("com.ibm.jutil.logging.default.Log4jLogStore.ConfigureFileName");
            if (this.filePath == null) {
                this.filePath = System.getProperties().getProperty("user.home") + "/.ibmjpos/logging";
            }
            this.logFileName = this.filePath + File.separator + this.fileName + this.fileExt;
            this.hostName = LoggerProperties.getProperty("com.ibm.jutil.logging.LogServerHostName", "com.ibm.jutil.logging.LogServerHostName");
            this.hostIP = LoggerProperties.getProperty("com.ibm.jutil.logging.LogServerIP", "com.ibm.jutil.logging.LogServerIP");
            this.hostPort = LoggerProperties.getProperty("com.ibm.jutil.logging.LogServerPort", "com.ibm.jutil.logging.LogServerPort");
            this.remoteLogging = LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingToRemoteServer", "com.ibm.jutil.logging.LoggingToRemoteServer");
            if (this.remoteLogging != null && (this.remoteLogging.compareToIgnoreCase("TRUE") == 0 || this.remoteLogging.compareToIgnoreCase("ON") == 0)) {
                this.isRemoteLogging = true;
                if (this.hostPort != null) {
                    this.hostPortNumber = Integer.valueOf(this.hostPort);
                }
                try {
                    if (this.hostIP != null && this.hostIP.compareToIgnoreCase("127.0.0.1") == 0) {
                        this.socketAppender = new SocketAppender(InetAddress.getLocalHost(), this.hostPortNumber);
                        break block7;
                    }
                    this.socketAppender = new SocketAppender(this.hostName, this.hostPortNumber);
                }
                catch (UnknownHostException unknownHostException) {}
            } else {
                this.isRemoteLogging = false;
                this.hostPortNumber = -1;
            }
        }
    }
}

