/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.DefaultUtilProperties;
import java.io.File;
import java.util.Properties;

public class LoggerProperties {
    private static boolean loaded = false;
    private static Properties props = new Properties();
    private static DefaultUtilProperties utilProperties;

    public static boolean isLoaded() {
        return loaded;
    }

    public static String getProperty(String property) {
        String propValue = props.getProperty(property);
        if (propValue != null && propValue.startsWith("<home>")) {
            String home = System.getProperties().getProperty("user.home");
            propValue = home + propValue.substring(propValue.lastIndexOf(">") + 1, propValue.length());
        }
        return propValue;
    }

    public static String getProperty(String property, String defKey) {
        String propValue = props.getProperty(property, props.getProperty(defKey));
        if (propValue != null && propValue.startsWith("<home>")) {
            String home = System.getProperties().getProperty("user.home");
            propValue = home + File.separator + propValue.substring(propValue.lastIndexOf(">") + 1, propValue.length());
        }
        return propValue;
    }

    public static void setProperty(String property, String value) {
        props.setProperty(property, value);
    }

    public static void load() {
        String resName = "Log.properties";
        LoggerProperties.load(resName);
        if (!loaded) {
            LoggerProperties.load("Log.properties");
            if (!loaded) {
                LoggerProperties.generateLogProperties();
            }
            LoggerProperties.saveProperties("Logging Properties", resName);
        }
        props = utilProperties.getProperties();
    }

    public static void load(String filename) {
        utilProperties = new DefaultUtilProperties(filename);
        utilProperties.loadProperties();
        loaded = utilProperties.isLoaded();
    }

    private static void generateLogProperties() {
        utilProperties.addProperty("com.ibm.jutil.logging.LogEntryName", "com.ibm.jutil.logging.DefaultLogEntry");
        utilProperties.addProperty("com.ibm.jutil.logging.LogEntryFactoryName", "com.ibm.jutil.logging.DefaultLogEntryFactory");
        utilProperties.addProperty("com.ibm.jutil.logging.LogEntryFactory.initialStackSize", "8");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreName", "com.ibm.jutil.logging.Log4jLogStore");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.stdout", "1");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.stderr", "2");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.file", "4");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.serial", "8");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.socket", "16");
        utilProperties.addProperty("com.ibm.jutil.logging.LogStoreMethodMask.multifile", "32");
        utilProperties.addProperty("com.ibm.jutil.logging.default.LogEntryFactoryName", "com.ibm.jutil.logging.DefaultLogEntry");
        utilProperties.addProperty("com.ibm.jutil.logging.default.LogEntryFactoryName", "com.ibm.jutil.logging.DefaultLogEntryFactory");
        utilProperties.addProperty("com.ibm.jutil.logging.default.LogStoreName", "com.ibm.jutil.logging.DefaultLogStore");
        utilProperties.addProperty("com.ibm.jutil.logging.default.Logger.Threshold", "10");
        utilProperties.addProperty("com.ibm.jutil.logging.JDKLogStore.LogFilePath", System.getProperties().getProperty("user.home") + File.separator + ".ibmjpos/logging");
        utilProperties.addProperty("com.ibm.jutil.logging.JDKLogStore.LogFileName", "jTuxLog");
        utilProperties.addProperty("com.ibm.jutil.logging.JDKLogStore.LogTextFileNameExt", ".log");
        utilProperties.addProperty("com.ibm.jutil.logging.JDKLogStore.LogSerFileNameExt", ".ser");
        utilProperties.addProperty("com.ibm.jutil.logging.default.Log4jLogStore.LogFilePath", System.getProperties().getProperty("user.home") + "/.ibmjpos/logging");
        utilProperties.addProperty("com.ibm.jutil.logging.default.Log4jLogStore.LogFileName", "jTuxLog");
        utilProperties.addProperty("com.ibm.jutil.logging.default.Log4jLogStore.LogTextFileNameExt", ".log");
        utilProperties.addProperty("com.ibm.jutil.logging.default.Log4jLogStore.ConfigureFileName", "log4jConfiguration.properties");
        utilProperties.addProperty("com.ibm.jutil.logging.LogServerHostName", "noHost");
        utilProperties.addProperty("com.ibm.jutil.logging.LogServerIP", "127.0.0.1");
        utilProperties.addProperty("com.ibm.jutil.logging.LogServerPort", "2053");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingToRemoteServer", "false");
        utilProperties.addProperty("com.ibm.jutil.logging.AllLoggingOff", "false");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingPrinter", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingScanner", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingLineDisplay", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingMSR", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingPOSKeyboard", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingKeylock", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingToneIndicator", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingCashDrawer", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingAllDevices", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingUniversalSerialBus", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingMICR", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LogAllPriorityAbove", "-1");
        utilProperties.addProperty("com.ibm.jutil.logging.LogAllPriorityBelow", "6");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingDEBUGPriority", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingINFOPriority", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingWARNPriority", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingERRORPriority", "true");
        utilProperties.addProperty("com.ibm.jutil.logging.LoggingFATALPriority", "true");
        loaded = true;
    }

    private static void saveProperties(String header, String fileName) {
        utilProperties.storeProperties(header, fileName);
    }

    protected static void clear() {
        props = new Properties();
        loaded = false;
    }
}

