/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.DefaultUtilProperties;
import com.ibm.jutil.UtilProperties;
import com.ibm.jutil.swing.PropertiesTableModel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DefaultPropertiesTableModel
extends AbstractTableModel
implements PropertiesTableModel {
    protected UtilProperties utilProp = null;
    protected Object[][] data;

    public DefaultPropertiesTableModel() {
        this.loadProperties("");
        this.fillTable();
    }

    public DefaultPropertiesTableModel(String propertiesName) throws FileNotFoundException {
        this.setProperties(propertiesName);
    }

    public void setProperties(String properties) throws FileNotFoundException {
        this.loadProperties(properties);
        if (!this.utilProp.isLoaded()) {
            throw new FileNotFoundException(properties);
        }
        this.fillTable();
    }

    public Properties getProperties() {
        return this.utilProp.getProperties();
    }

    public String getPropertiesFileName() {
        return this.utilProp.getLoadedPropFileName();
    }

    public void saveProperties() throws IOException {
        Properties prop = this.utilProp.getProperties();
        for (int count = 0; count < this.getRowCount(); ++count) {
            prop.put(this.getValueAt(count, 0), this.getValueAt(count, 1));
        }
        FileOutputStream fileOutput = new FileOutputStream(this.utilProp.getLoadedPropFileName());
        prop.store(fileOutput, "");
    }

    public int getColumnCount() {
        return PropertiesTableModel.names.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public String getColumnName(int column) {
        return PropertiesTableModel.names[column];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.data[row][column] = aValue;
    }

    protected void loadProperties(String fileName) {
        if (this.utilProp == null) {
            this.utilProp = new DefaultUtilProperties(fileName);
        }
        this.utilProp.loadPropertiesByName(fileName);
    }

    protected void fillTable() {
        Enumeration e = this.utilProp.getPropertyNames();
        Vector vector = new Vector();
        while (e.hasMoreElements()) {
            vector.addElement(e.nextElement());
        }
        this.data = new Object[vector.size()][PropertiesTableModel.names.length];
        for (int count = 0; count < this.data.length; ++count) {
            String currentKey = vector.elementAt(count).toString();
            this.data[count][0] = currentKey;
            this.data[count][1] = this.utilProp.getPropertyString(currentKey);
        }
    }
}

