/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXercesParser {
    private SAXParser saxParser = null;
    private XMLReader xmlReader = null;

    public AbstractXercesParser() throws SAXException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        this.initFactory((SAXParserFactory)factory);
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Could not create SAX parser.  ParserConfigurationException.message=" + e.getMessage());
        }
    }

    protected abstract void preParse() throws SAXException;

    protected abstract void postParse() throws SAXException;

    protected void initFactory(SAXParserFactory factory) {
        factory.setNamespaceAware(true);
        factory.setValidating(true);
    }

    protected XMLReader getXmlReader() {
        return this.xmlReader;
    }

    protected SAXParser getSaxParser() {
        return this.saxParser;
    }

    protected void initXMLReader(XMLReader xmlReader) throws SAXException {
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
    }

    protected void error(SAXParseException e) throws SAXException {
        String msg = "error.SAXParseException.message=" + e.getMessage();
        System.err.println(msg);
        throw new SAXException(msg);
    }

    protected void fatalError(SAXParseException e) throws SAXException {
        String msg = "fatalError.SAXParseException.message=" + e.getMessage();
        System.err.println(msg);
        throw new SAXException(msg);
    }

    protected void warning(SAXParseException e) throws SAXException {
        String msg = "warning.SAXParseException.message=" + e.getMessage();
        System.err.println(msg);
    }

    protected void startDocument() throws SAXException {
    }

    protected void endDocument() throws SAXException {
    }

    protected void characters(char[] chars, int start, int length) throws SAXException {
    }

    protected void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
    }

    protected void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this.preParse();
        DefaultContentHandler contentHandler = new DefaultContentHandler();
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        this.xmlReader = this.saxParser.getXMLReader();
        this.initXMLReader(this.xmlReader);
        this.xmlReader.setContentHandler(contentHandler);
        this.xmlReader.setErrorHandler(errorHandler);
        this.xmlReader.parse(new InputSource(reader));
        this.postParse();
    }

    protected class DefaultContentHandler
    extends DefaultHandler {
        protected DefaultContentHandler() {
        }

        public void startDocument() throws SAXException {
            AbstractXercesParser.this.startDocument();
        }

        public void endDocument() throws SAXException {
            AbstractXercesParser.this.endDocument();
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            AbstractXercesParser.this.characters(chars, start, length);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            AbstractXercesParser.this.startElement(namespaceURI, localName, qName, attributes);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            AbstractXercesParser.this.endElement(namespaceURI, localName, qName);
        }
    }

    protected class DefaultErrorHandler
    extends DefaultHandler {
        protected DefaultErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            AbstractXercesParser.this.error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            AbstractXercesParser.this.fatalError(e);
        }

        public void warning(SAXParseException e) throws SAXException {
            AbstractXercesParser.this.warning(e);
        }
    }
}

