/*
 * Decompiled with CFR 0.152.
 */
package com.auttar.atualizador.service;

import com.auttar.atualizador.common.constant.Atualizador;
import com.auttar.atualizador.common.file.EcReader;
import com.auttar.atualizador.common.regex.RegexValidator;
import com.auttar.atualizador.util.file.FileUtil;
import com.auttar.atualizador.util.logger.LoggerManager;
import com.auttar.atualizador.util.logger.config.ILogger;
import com.auttar.atualizador.util.string.StringUtil;
import com.auttar.atualizador.util.xml.XmlReader;
import com.auttar.atualizador.util.xml.config.Parameter;
import java.io.File;
import java.io.FileOutputStream;

public class ServicoDeAtualizacao {
    private ILogger logger = LoggerManager.get("com.auttar.atualizador.service.ServicoDeAtualizacao");

    public void manager(String terminal, String versao) throws Exception {
        terminal = this.validaTerminal(terminal);
        this.validaVersao(versao);
        if (this.isAtualizadorHabilitado()) {
            this.logger.info("Inicio da configuracao do Atualizador");
            this.configurarTerminal(terminal);
            this.configurarVersao(versao);
            this.logger.info("Fim da configuracao do Atualizador");
        } else {
            if (FileUtil.doesItExist(Atualizador.PATH_CTFCLIENT_INFO_FILE)) {
                FileUtil.remove(Atualizador.PATH_CTFCLIENT_INFO_FILE);
            }
            if (FileUtil.doesItExist(Atualizador.PATH_CTFCLIENT_VERSION_FILE)) {
                FileUtil.remove(Atualizador.PATH_CTFCLIENT_VERSION_FILE);
            }
            this.logger.warn("O atualizador encontra-se desabilitado!");
        }
    }

    private boolean isAtualizadorHabilitado() throws Exception {
        Parameter parameter = XmlReader.get("atualizador", "habilitado");
        boolean atualizadorHabilitado = false;
        if (parameter != null && !StringUtil.isEmpty(parameter.getContent()) && (parameter.getContent().equalsIgnoreCase("true") || parameter.getContent().equalsIgnoreCase("false"))) {
            atualizadorHabilitado = Boolean.valueOf(parameter.getContent());
        }
        return atualizadorHabilitado;
    }

    private String validaTerminalDoXmlDeInstalacao() throws Exception {
        String terminal = EcReader.getEC();
        if (StringUtil.isEmpty(terminal) || terminal.equals("")) {
            throw new Exception("Numero do terminal nao informado no arquivo de configuracao: " + com.auttar.atualizador.common.constant.File.CTFCLIENT_CONFIG_FILE + "...");
        }
        return terminal;
    }

    private String validaTerminal(String terminal) throws Exception {
        if (StringUtil.isEmpty(terminal) || terminal.equals("")) {
            this.logger.log("INFO", "Numero do terminal nao informado. Lendo numero do terminal a partir do arquivo de configuracao: " + com.auttar.atualizador.common.constant.File.CTFCLIENT_CONFIG_FILE + "...");
            terminal = this.validaTerminalDoXmlDeInstalacao();
        }
        if (!RegexValidator.validate("[0-9a-zA-Z]{12}", terminal)) {
            throw new Exception("O Nnmero do terminal " + terminal + " deve ser composto de letras, numeros e tamanho 12!");
        }
        return terminal;
    }

    private void validaVersao(String versao) throws Exception {
        if (StringUtil.isEmpty(versao)) {
            throw new Exception("Versao do CTFClient nao informada!");
        }
        if (!RegexValidator.validate("^(?:[0-9a-zA-Z])*$", versao)) {
            throw new Exception("A versao " + versao + " deve conter apenas letras e numeros!");
        }
    }

    private void configurarTerminal(String terminal) throws Exception {
        String root_path = System.getenv("CTFCLIENT_HOME") + File.separator;
        FileOutputStream identification_file = new FileOutputStream(root_path + "ctfclient_info.ini");
        String identification_line = "terminal_id=" + terminal;
        identification_file.write(identification_line.getBytes());
        identification_file.close();
        this.logger.debug("Terminal " + terminal + " configurado.");
        this.logger.info("Terminal configurado no arquivo: " + root_path + "ctfclient_info.ini");
    }

    private void configurarVersao(String versao) throws Exception {
        String root_path = System.getenv("CTFCLIENT_HOME") + File.separator;
        FileOutputStream version_file = new FileOutputStream(root_path + "VERSION.G7T");
        String version_line = "TEL_VERSION=\"" + versao + "\"";
        version_file.write(version_line.getBytes());
        version_file.close();
        this.logger.debug("Versao " + versao + " configurada.");
        this.logger.info("Versao configurada no arquivo: " + root_path + "VERSION.G7T");
    }
}

