/*
 * Decompiled with CFR 0.152.
 */
package com.auttar.atualizador.util.xml;

import com.auttar.atualizador.common.constant.File;
import com.auttar.atualizador.util.logger.LoggerManager;
import com.auttar.atualizador.util.logger.config.ILogger;
import com.auttar.atualizador.util.string.StringUtil;
import com.auttar.atualizador.util.xml.config.Config;
import com.auttar.atualizador.util.xml.config.Parameter;
import com.auttar.atualizador.util.xml.config.ParameterSet;

public class XmlReader {
    private static ILogger logger = LoggerManager.get("com.auttar.atualizador.util.xml.XmlReader");

    public static Parameter get(String parameterSet, String parameter) throws Exception {
        if (StringUtil.isEmpty(parameterSet)) {
            throw new Exception("Objeto do arquivo de configuracao nao informado: " + parameterSet);
        }
        if (StringUtil.isEmpty(parameter)) {
            throw new Exception("Atributo do arquivo de configuracao nao informado: " + parameter);
        }
        try {
            return XmlReader.getConfiguracao().getParameterSet(parameterSet).getParameter(parameter);
        }
        catch (Exception e) {
            logger.log("INFO", e.getMessage());
            return null;
        }
    }

    public static Parameter get(String parameter) throws Exception {
        if (StringUtil.isEmpty(parameter)) {
            throw new Exception("Atributo do arquivo de configuracao nao informado: " + parameter);
        }
        try {
            return XmlReader.getConfiguracao().getParameter(parameter);
        }
        catch (Exception e) {
            logger.log("INFO", e.getMessage());
            return null;
        }
    }

    public static ParameterSet getConfiguracao() throws Exception {
        try {
            Config config = Config.getConfig(File.CTFCLIENT_CONFIG_FILE);
            return config.getParameterSet("configCTFClient");
        }
        catch (Exception e) {
            logger.error("Arquivo de configuracao nao encontrado");
            e.printStackTrace();
            throw e;
        }
    }
}

