/*
 * Decompiled with CFR 0.152.
 */
package com.auttar.atualizador.util.xml.config;

import com.auttar.atualizador.util.xml.config.ConfigWithThisFilenameExistsException;
import com.auttar.atualizador.util.xml.config.ParameterSet;
import com.auttar.atualizador.util.xml.config.ParseConfigException;
import com.auttar.atualizador.util.xml.config.StructureConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Config
extends ParameterSet {
    private static Hashtable configStore;
    private Document jdom;
    private String filename;

    private Config() {
        super("configuration_file");
    }

    private Config(String filename) throws FileNotFoundException, SecurityException, ParseConfigException, StructureConfigException {
        super("configuration_file");
        this.filename = filename;
        try {
            SAXBuilder builder = new SAXBuilder();
            this.jdom = builder.build(Config.getInputStream(filename));
        }
        catch (JDOMException e) {
            throw new ParseConfigException(e);
        }
        catch (IOException e) {
            throw new FileNotFoundException("IOException gerado pelo JDOM");
        }
        try {
            this.jdomElement = this.jdom.getRootElement();
            if (!this.jdomElement.getName().equals("configuration_file")) {
                throw new StructureConfigException("'" + filename + "' has invalid root element: '" + this.jdom.getRootElement().getName() + "'. Should be: '" + "configuration_file" + "'.");
            }
        }
        catch (IllegalStateException e) {
            throw new StructureConfigException("'" + filename + "' DOM has no root element.");
        }
    }

    public static synchronized Config getConfig(String filename) throws FileNotFoundException, SecurityException, ParseConfigException, StructureConfigException {
        Config.initConfigStore();
        if (configStore.containsKey(filename)) {
            return (Config)configStore.get(filename);
        }
        Config newconf = new Config(filename);
        configStore.put(filename, newconf);
        return newconf;
    }

    public static synchronized Config getBlankConfig(String filename) throws ConfigWithThisFilenameExistsException, SecurityException, IOException, ParseConfigException, StructureConfigException {
        Config.initConfigStore();
        if (configStore.containsKey(filename)) {
            throw new ConfigWithThisFilenameExistsException(filename);
        }
        FileOutputStream outf = new FileOutputStream(filename);
        Document newjdom = new Document(new Element("configuration_file"));
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        out.output(newjdom, (OutputStream)outf);
        outf.close();
        return Config.getConfig(filename);
    }

    private static synchronized void initConfigStore() {
        if (configStore == null) {
            configStore = new Hashtable();
        }
    }

    public void setFilename(String newFilename) throws ConfigWithThisFilenameExistsException {
        if (configStore.containsKey(newFilename)) {
            throw new ConfigWithThisFilenameExistsException(newFilename);
        }
        configStore.remove(this.filename);
        this.filename = newFilename;
        configStore.put(newFilename, this);
    }

    public synchronized void save() throws SecurityException, IOException {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        FileOutputStream outf = new FileOutputStream(this.filename);
        out.output(this.jdom, (OutputStream)outf);
        outf.close();
    }

    @Override
    protected String getIdentity() {
        return "file::" + this.filename;
    }

    public static InputStream getInputStream(String fileName) {
        InputStream is = null;
        try {
            File file = new File(fileName);
            is = file.getClass().getResourceAsStream(fileName);
        }
        catch (Exception file) {
            // empty catch block
        }
        if (is == null) {
            try {
                is = new FileInputStream(fileName);
            }
            catch (Exception file) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (is == null) {
            try {
                is = ClassLoader.getSystemResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/" + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("META-INF/" + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/META-INF/" + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("WEB-INF/classes/" + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/WEB-INF/classes/" + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is;
    }
}

