/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.event;

import com.ibm.jsio.event.SioDeviceDataEvent;
import com.ibm.jsio.event.SioDeviceErrorEvent;
import com.ibm.jsio.event.SioDeviceEvent;
import com.ibm.jsio.event.SioDeviceEventHelper;
import com.ibm.jsio.event.SioDeviceListener;
import com.ibm.jsio.event.SioDeviceStatusEvent;
import com.ibm.jutil.tasks.FifoScheduler;
import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultSioDeviceEventHelper
implements SioDeviceEventHelper {
    private List listeners = new ArrayList();
    private TaskScheduler taskScheduler = new FifoScheduler();

    public void fireDataEvent(SioDeviceDataEvent event) {
        this.taskScheduler.post((Task)new SioDeviceDataEventTask(event));
    }

    public void fireErrorEvent(SioDeviceErrorEvent event) {
        this.taskScheduler.post((Task)new SioDeviceErrorEventTask(event));
    }

    public void fireStatusEvent(SioDeviceStatusEvent event) {
        this.taskScheduler.post((Task)new SioDeviceStatusEventTask(event));
    }

    public synchronized void addSioDeviceListener(SioDeviceListener listener) {
        if (null != listener && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeSioDeviceListener(SioDeviceListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }

    private class SioDeviceStatusEventTask
    extends AbstractEventTask {
        SioDeviceStatusEventTask(SioDeviceStatusEvent event) {
            super(event);
        }

        protected void fireEvent(SioDeviceEvent event, SioDeviceListener listener) {
            listener.statusEventOccurred((SioDeviceStatusEvent)event);
        }
    }

    private class SioDeviceErrorEventTask
    extends AbstractEventTask {
        SioDeviceErrorEventTask(SioDeviceErrorEvent event) {
            super(event);
        }

        protected void fireEvent(SioDeviceEvent event, SioDeviceListener listener) {
            listener.errorEventOccurred((SioDeviceErrorEvent)event);
        }
    }

    private class SioDeviceDataEventTask
    extends AbstractEventTask {
        SioDeviceDataEventTask(SioDeviceDataEvent event) {
            super(event);
        }

        protected void fireEvent(SioDeviceEvent event, SioDeviceListener listener) {
            listener.dataEventOccurred((SioDeviceDataEvent)event);
        }
    }

    private abstract class AbstractEventTask
    implements Task {
        private SioDeviceEvent sioDeviceEvent = null;

        AbstractEventTask(SioDeviceEvent event) {
            this.sioDeviceEvent = event;
        }

        protected abstract void fireEvent(SioDeviceEvent var1, SioDeviceListener var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ArrayList listenersCopy = null;
            List list = DefaultSioDeviceEventHelper.this.listeners;
            synchronized (list) {
                listenersCopy = new ArrayList(DefaultSioDeviceEventHelper.this.listeners);
            }
            Iterator iterator = listenersCopy.iterator();
            while (iterator.hasNext()) {
                SioDeviceListener listener = (SioDeviceListener)iterator.next();
                this.fireEvent(this.sioDeviceEvent, listener);
            }
        }

        public Exception getException() {
            return null;
        }

        public boolean isExecuted() {
            return false;
        }

        public boolean isInException() {
            return false;
        }

        public String getName() {
            return "";
        }
    }
}

