/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.ctfclient.tools.devices.touchkeyboard;

import br.com.auttar.AuttarLogger;
import br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouch;
import com.csi.ctfclient.gui.TelaPrincipal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JFrame;

public class ConfiguraTecladoTouch {
    private static ConfiguraTecladoTouch configuraTecladoTouch = null;
    private AuttarLogger logger;
    private TouchKeyboard touchKeyboard = null;
    private boolean configurado = false;
    private TelaPrincipal frameCTFClient = null;
    private Dimension dimensionCTFClient = null;
    private Dimension dimensionTecladoTouch = new Dimension(648, 410);
    private boolean estadoInicialTeclado = true;
    private boolean estadoTeclado = false;
    private String css = "teclado_touch_ctfclient.css";
    private String layout = "TECLADO_NUMERICO";

    private ConfiguraTecladoTouch() {
        this.logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    }

    public static ConfiguraTecladoTouch getInstancia() {
        if (configuraTecladoTouch == null) {
            configuraTecladoTouch = new ConfiguraTecladoTouch();
        }
        return configuraTecladoTouch;
    }

    public void configurar(TecladoTouch tecladoTouch) {
        this.touchKeyboard = new TouchKeyboard();
        if (!this.isConfigurado()) {
            try {
                this.touchKeyboard.configure(new File("mapatecladoTouch.xml"), this.css, (JFrame)tecladoTouch.getFrame(), this.layout);
                ConfiguraTecladoTouch.getInstancia().setConfigurado(true);
                this.touchKeyboard.setLayout(this.layout);
                this.frameCTFClient = (TelaPrincipal)tecladoTouch.getFrame();
                this.touchKeyboard.setComponentFocus((Component)this.frameCTFClient);
                this.dimensionCTFClient = this.frameCTFClient.getSize();
                this.alteraEstadoTeclado();
                this.setConfigurado(true);
                MouseClick mouseClick = new MouseClick();
                this.frameCTFClient.addMouseListener(mouseClick);
                this.frameCTFClient.removeRecuperaFocoListener();
            }
            catch (KeyboardConfigException e) {
                this.logger.warn("nao foi possivel configurar o teclado touch no ctfclient: " + e.getMessage());
            }
        }
    }

    protected TouchKeyboard getTouchKeyboard() {
        return this.touchKeyboard;
    }

    protected boolean isConfigurado() {
        return this.configurado;
    }

    protected void setConfigurado(boolean configurado) {
        this.configurado = configurado;
    }

    protected void habilitaFrameTeclado() {
        if (this.estadoInicialTeclado) {
            this.frameCTFClient.setSize(this.dimensionTecladoTouch);
            this.estadoTeclado = true;
        } else {
            this.frameCTFClient.setSize(this.dimensionCTFClient);
            this.estadoTeclado = false;
        }
    }

    protected void desabilitaFrameTeclado() {
        this.frameCTFClient.setSize(this.dimensionCTFClient);
        this.estadoTeclado = false;
    }

    public void setTecladoVisivel(boolean tecladoVisivel) {
        this.estadoInicialTeclado = tecladoVisivel;
    }

    public void setCss(String nome) {
        this.css = nome;
    }

    protected String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
        if (this.touchKeyboard != null) {
            this.touchKeyboard.setLayout(layout);
        }
    }

    private void alteraEstadoTeclado() {
        if (this.estadoTeclado) {
            this.frameCTFClient.setSize(this.dimensionCTFClient);
            this.estadoTeclado = false;
        } else {
            this.frameCTFClient.setSize(this.dimensionTecladoTouch);
            this.estadoTeclado = true;
        }
    }

    class MouseClick
    implements MouseListener {
        MouseClick() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                ConfiguraTecladoTouch.this.alteraEstadoTeclado();
            }
        }
    }
}

