/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.model.constants;

import br.com.auttar.model.constants.CardApplicationTypeEnum;

public enum OperationEnum {
    OP_CONSULTA_GENERICA(1, null, null, null),
    OP_CONFIG(5, null, null, null),
    OP_CONFIRMACAO(6, null, null, null),
    OP_DESFAZIMENTO(7, null, null, null),
    OP_IMPRESSAO_TODOS_COMPROVANTES(10, null, null, null),
    OP_DESFAZIMENTO_TODAS_TRANS_NAO_CONSOLIDADA(11, null, null, null),
    OP_REIMPRESSAO_ULTIMO_COMPROVANTE(12, null, null, null),
    OP_REIMPRESSAO_PRIMEIRO_COMPROVANTE(14, null, null, null),
    OP_REIMPRESSAO_PROXIMO_COMPROVANTE(15, null, null, null),
    OP_CONFIRMACAO_CHEQUE(84, null, null, null),
    OP_DEBITO(101, null, "02", "OPERACAO DEBITO"),
    OP_DEB_PRE_DATADO(103, null, "02", null),
    OP_DEB_PARCELADO_SEM_PARC_AVISTA(104, null, "02", null),
    OP_DEB_PARCELADO_COM_PARC_AVISTA(105, null, "02", null),
    OP_DEB_VOUCHER(106, "6A", "02", "VOUCHER GENERICO"),
    OP_VOUCHER(107, "6A", null, "OPERACAO VOUCHER"),
    OP_DEB_CDC_COM_PARC_AVISTA(108, null, "02", null),
    OP_DEB_CDC_SEM_PARC_AVISTA(109, null, "02", null),
    OP_CONSULTA_CDC_COM_PARC_AVISTA(110, "5C", null, "OPERACAO CONSULTA CDC COM PARCELA A VISTA"),
    OP_CONSULTA_CDC_SEM_PARC_AVISTA(111, null, null, "OPERACAO CONSULTA CDC SEM PARCELA A VISTA"),
    OP_CREDITO(112, null, "01", "CREDITO GENERICO"),
    OP_CRED_PARC_SEM_JUROS(113, null, "01", "CREDITO GENERICO"),
    OP_CRED_PARC_COM_JUROS(114, null, "01", "CREDITO GENERICO"),
    OP_CRED_IATA(115, null, "01", "OPERACAO CREDITO IATA"),
    OP_CRED_IATA_SEM_JUROS(116, null, "01", null),
    OP_CRED_IATA_COM_JUROS(117, null, "01", null),
    OP_CONSULTA_FINANCIAMENTO_CREDITO(118, null, null, null),
    OP_PRE_AUT_CRED(119, null, "01", "OPERACAO PRE AUTORIZACAO"),
    OP_CRED_DIGITADO(120, null, "01", null, false),
    OP_CRED_DIGITADO_PARC_SEM_JUROS(121, null, "01", null, false),
    OP_CRED_DIGITADO_PARC_COM_JUROS(122, null, "01", null, false),
    OP_CRED_DIGITADO_IATA(123, null, "01", null, false),
    OP_CRED_DIGITADO_IATA_SEM_JUROS(124, null, "01", null, false),
    OP_CRED_DIGITADO_IATA_COM_JUROS(125, null, "01", null, false),
    OP_CONSULTA_CREDITO_DIGITADO(126, null, null, null, false),
    OP_PRE_AUT_CRED_DIGITADO(127, null, null, null, false),
    OP_CANCELAMENTO_GENERICO(128, null, null, "OPERACAO CANCELAMENTO"),
    OP_CONSULTA_CHEQUE(129, "16", null, "OPERACAO CONSULTA CHEQUE"),
    OP_CONSULTA_LIMITE_CHEQUE(130, null, null, null),
    OP_POS_CONSULTA_LIMITE_CHEQUE(131, null, null, null),
    OP_CONFIRMACAO_PRE_AUT(132, null, "01", "OPERACAO CONFIRMACAO PRE AUTORIZACAO"),
    OP_CONFIRMACAO_PRE_AUT_DIGITADO(133, null, null, null, false),
    OP_CANCELAMENTO_PRE_AUT(134, "3G", null, "OPERACAO CANCELAMENTO PRE-AUTORIZACAO"),
    OP_CONSULTA_CHEQUE_BANCO(135, null, null, null),
    OP_CONSULTA_CHEQUE_COMPLETA(136, null, null, null),
    OP_GARANTIA_CHEQUE(137, "17", null, "OPERACAO GARANTIA CHEQUE"),
    OP_GARANTIA_CHEQUE_COM_SENHA(138, null, null, null),
    OP_CONSULTA_AVS(139, "D6", null, "CONSULTA AVS"),
    OP_CASH_PRIVATE_LABEL_ROTATIVO_OU_PARC(140, "DD", null, "CASH PRIVATE LABEL"),
    OP_CONSULTA_CASH_PRIVATE_LABEL(141, "DE", null, "CONS CASH PRIVATE LABEL"),
    OP_CRED_PRIVATE_LABEL(142, null, "01", "OPERACAO CREDITO PRIVATE LABEL"),
    OP_CRED_PRIVATE_LABEL_DIGITADO(143, null, "01", "OPERACAO CREDITO PRIVATE LABEL", false),
    OP_CONSULTA_PRIVATE_LABEL(144, null, null, "OPERACAO CONSULTA CREDITO PRIVATE LABEL"),
    OP_CONSULTA_PRIVATE_LABEL_DIGITADO(145, null, null, "OPERACAO CONSULTA CREDITO PRIVATE LABEL", false),
    OP_AUT_IATA(146, null, "01", "OPERACAO AUTORIZACAO IATA"),
    OP_AUT_IATA_SEM_JUROS(147, null, null, null),
    OP_AUT_IATA_DIGITADO(149, null, null, null, false),
    OP_AUT_IATA_DIGITADO_SEM_JUROS(150, null, null, null, false),
    OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA(152, null, null, "OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO"),
    OP_PGTO_FICHA_COMPENSACAO(153, "E6", null, "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO"),
    OP_PGTO_CONVENIO_COM_CONSULTA(154, null, null, "OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO"),
    OP_PGTO_CONVENIO(155, "E7", null, "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO"),
    OP_ESTORNO_PAG(156, null, null, null),
    OP_REEMISSAO_COMPROVANTE_PAG(157, null, null, null),
    OP_CANCELAMENTO_CRED(158, null, null, null),
    OP_CANCELAMENTO_DEB(159, null, null, null),
    OP_CONSULTA_CREDITO(163, null, null, null),
    OP_CONFIRMACAO_PRE_AUT_SEM_JUROS(167, null, null, null),
    OP_CONFIRMACAO_PRE_AUT_COM_JUROS(168, null, null, null),
    OP_CONFIRMACAO_PRE_AUT_DIGITADO_SEM_JUROS(169, null, null, null, false),
    OP_CONFIRMACAO_PRE_AUT_DIGITADO_COM_JUROS(170, null, null, null, false),
    OP_CONSULTA_ANALITICA_SPC(172, null, null, null),
    OP_CONSULTA_VALORES_CREDITO_DIGITAL(173, "F4", null, "CONSULTA DE CREDITO DIGITAL"),
    OP_COMPRA_CREDITO_DIGITAL(174, "F5", null, "COMPRA DE CREDITO DIGITAL"),
    OP_PAG_CREDIARIO(175, null, null, null),
    OP_PAG_CREDIARIO_DIGITADO(176, null, null, null, false),
    OP_CANCELAMENTO_PAG_CREDIARIO(177, null, null, null),
    OP_CONSULTA_FICHA_COMPENSACAO(180, "E4", null, "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO"),
    OP_CONSULTA_CONVENIO(181, "E5", null, "OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO"),
    OP_CONSULTA_FATURA_CARTAO(182, "FA", null, "OPERACAO CONSULTA FATURA CARTAO"),
    OP_PAGAMENTO_FATURA_CARTAO(183, "FB", "01", "OPERACAO PAGAMENTO FATURA CARTAO"),
    OP_DESFAZIMENTO_TODAS_TRANS(191, null, null, null),
    OP_CONSULTA_CONVENIO_EMPRESA_EPHARMA(201, null, null, null),
    OP_VENDA_CONVENIO_EMPRESA_EPHARMA(202, null, null, null),
    OP_CANCELAMENTO_CONVENIO_EMPRESA_PBM(203, null, null, null),
    OP_CONSULTA_PBM(204, null, null, null),
    OP_VENDA_PBM(205, null, null, null),
    OP_CONSOLIDA_TRANSACAO(209, null, null, null),
    OP_FINALIZACAO_VENDA(215, null, null, null),
    OP_BAIXA_TECNICA_MANUAL(220, null, null, "OPERACAO BAIXA TECNICA MANUAL"),
    OP_ECO(221, null, null, "OPERACAO ECO"),
    OP_OUTRAS_TRANSACOES(222, "2R", null, "OUTRAS TRANSACOES"),
    OP_CREDITO_GENERICO(223, "12", "01", "CREDITO GENERICO"),
    OP_DEBITO_GENERICO(224, "10", "02", "DEBITO GENERICO"),
    OP_INICIO_DIA(225, null, null, "OPERACAO INICIO DIA"),
    OP_CONSULTA_CARTAO(226, null, null, "OPE CONSULTA CARTAO"),
    OP_BYPASS(227, null, null, "OPE BYPASS"),
    OP_REIMPRESSAO_OUTRO_COMPROVANTE(229, null, null, null),
    OP_CONSULTA_CONFIGURACAO(228, null, null, null),
    OP_PAGUE_CONTAS_FICHA_COMPENSACAO(230, null, null, null),
    OP_PAGUE_CONTAS_CONCECIONARIA(231, null, null, null),
    OP_CREDITO_CELULAR_AVISTA(232, "4J", null, "OPERACAO CREDITO CELULAR"),
    OP_CREDITO_CELULAR_PARC_LOJISTA(233, "4K", null, null),
    OP_CREDITO_CELULAR_PARC_ADMINISTRADORA(234, "4L", null, null),
    OP_COMPRA_VALE_GAS(235, null, null, "OPERACAO COMPRA VALE GAS"),
    OP_TROCO_SURPRESA(236, "F9", null, "OPERACAO TROCO SURPRESA"),
    OP_PARCELE_MAIS(238, "5G", null, "OPERACAO PARCELE MAIS"),
    OP_ESTATISTICA_MANUAL(239, null, null, "OPERACAO ESTATISTICA MANUAL"),
    OP_SAQUE_CREDITO(245, "3J", null, "OPE_SAQUE_CARTAO_CREDITO"),
    OP_SAQUE_DEBITO(246, "15", null, "OPE_SAQUE_CARTAO_DEBITO"),
    OP_SAQUE_TRANSFERENCIA_CREDITO(247, "3K", null, "OPE_SAQUE_TRANSFERENCIA_CREDITO"),
    OP_SIMULACAO_SAQUE_CREDITO(248, "3L", null, "OPE_SIMULACAO_SAQUE_CREDITO"),
    OP_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO(249, "3M", null, "OPE_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO"),
    OP_CONSULTA_SAQUE_DEBITO(250, "30", null, "OPE_CONSULTA_SALDO_DEBITO"),
    OP_CONSULTA_SAQUE_CREDITO(251, "3H", null, "OPE_CONSULTA_SALDO_CREDITO"),
    OP_RESGATE_FIDELIDADE(252, "3T", null, "OPE_RESGATE_FIDELIDADE"),
    OP_RECARGA_CARTAO_PREPAGO(253, "3R", "01", "OPE_RECARGA_CARTAO_PREPAGO"),
    OP_RESGATE_PREMIO(254, null, null, "OPERACAO RESGATE PREMIO"),
    OP_FUEL_CONTROL(255, null, null, "OPERACAO FUEL CONTROL"),
    OP_CONSULTA_DROGAO_COM_CARTAO(256, "3R", null, "OPERACAO CONSULTA DROGAO COM CARTAO"),
    OP_CONSULTA_DROGAO_COM_CPF(257, "3S", null, "OPERACAO CONSULTA DROGAO COM CPF", false),
    OP_PAGAMENTO_EMS_DROGAO(258, "3T", null, "OPERACAO PAGAMENTO DROGAO"),
    OP_INJECAO_MANUAL_CHAVE_DUKPT(259, "GA", null, "OPE_INJECAO_MANUAL_CHAVE_DUKPT"),
    OP_ATIVACAO_CARTAO_PREPAGO(260, "FG", "01", "OPE_ATIVACAO_CARTAO_PREPAGO"),
    OP_PRIMEIRA_COMPRA_FIAT(261, null, null, null),
    OP_RECARGA_CARTAO_PRESENTE(262, "E8", "01", "OPE_RECARGA_CARTAO_PRESENTE"),
    OP_CONSULTA_CARTAO_PRESENTE(263, "6B", null, "OPE_CONSULTA_CARTAO_PRESENTE"),
    OP_DEPOSITO_COM_DOCUMENTO(264, null, null, null),
    OP_CONSULTA_CONTA(266, null, null, null),
    OP_CREDIARIO_DE_DEBITO(267, "GB", "02", "OPE_DEBITO_CREDIARIO"),
    OP_SIMULACAO_CREDIARIO_DE_DEBITO(268, null, null, "OPE_SIMULACAO_CREDIARIO_DEBITO"),
    OP_CREDIARIO_DE_CREDITO(269, "1S", "01", "OPE_CREDITO_CREDIARIO"),
    OP_SIMULACAO_CREDIARIO_DE_CREDITO(270, "4F", "01", "OPE_SIMULACAO_CREDIARIO_CREDITO"),
    OP_TROCA_SENHA(271, null, null, "OPE_TROCA_SENHA"),
    OP_PRE_AUTORIZACAO_CARTAO_PREPAGO(272, null, null, null),
    OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO(273, null, null, null),
    OP_DESATIVACAO_CARTAO_PREPAGO(274, null, null, null),
    OP_VENDA_FASTPIN(275, null, null, null),
    OP_RETORNO_FASTPIN(276, null, null, null),
    OP_CARGA_PRODUTOS_PROMOCIONAIS(277, null, null, null),
    OP_DESCONTO_PRODUTOS_PROMOCIONAIS(278, null, null, "OPE_DESCONTO_PRODUTOS_PROMOCIONAIS"),
    OP_CONFIRMACAO_PRE_VENDA(279, null, null, "OPE_CONFIRMACAO_PRE_VENDA"),
    OP_CONFIRMACAO_NSU_CTF(280, "9Y", null, "OPE_CONFIRMACAO_NSU_CTF"),
    OP_DESFAZIMENTO_NSU_CTF(281, "9Z", null, "OPE_DESFAZIMENTO_NSU_CTF"),
    OP_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO(282, "6N", null, "OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO"),
    OP_CONSULTA_TELEFONE_CREDITO_DIGITAL(283, "FH", null, "CONSULTA TELEFONE CREDITO DIGITAL"),
    OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO(284, null, null, "OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO"),
    OP_ATUALIZACAO_CHIP(285, "5T", null, "OPE_ATUALIZACAO_CHIP"),
    OP_CAPTURA_CREDITO(286, "GD", null, "OPE_CAPTURA_CREDITO"),
    OP_AUTO(287, "5U", "02", "OPERACAO AUTO"),
    OP_AUTO_CONSULTA_SALDO(288, "7I", "02", "OPERACAO AUTO CONSULTA SALDO"),
    OP_DOTZ_ACUMULO(289, "6S", null, "OPE_DOTZ_ACUMULO"),
    OP_DOTZ_RESGATE(290, "2C", null, "OPE_DOTZ_RESGATE"),
    OP_DOTZ_CONSULTA_SALDO(291, "2B", null, "OPE_DOTZ_CONSULTA_SALDO"),
    OP_DOTZ_CONSULTA_EXTRATO(292, "6R", null, "OPE_DOTZ_CONSULTA_EXTRATO"),
    OP_ATIVACAO_CARTAO_PRESENTE(300, "GC", null, "OPE_ATIVACAO_CARTAO_PRESENTE"),
    OP_IDENTIFICACAO_CARTAO_ASSOCIADO(301, null, null, "OPE_IDENTIFICACAO_ASSOCIADO"),
    OP_IDENTIFICACAO_CARTAO_ASSOCIADO_DIGITADO(302, null, null, null, false),
    OP_VENDA_PBM_GETNET_AVISTA(303, null, null, null),
    OP_VENDA_PBM_GETNET_SEM_JUROS(304, null, null, null),
    OP_VENDA_PBM_GETNET_COM_JUROS(305, null, null, null),
    OP_EMISSAO_VALE_TROCA(307, "Y1", null, "OPE_EMISSAO_VALE_TROCA"),
    OP_RESGATE_VALE_TROCA(308, "Y2", null, "OPE_RESGATE_VALE_TROCA"),
    OP_CONSULTA_REIMPRESSAO_VALE_TROCA(309, "9B", null, "OPE_CONSULTA_REIMPRESSAO_VALE_TROCA"),
    OP_REIMPRESSAO_VALE_TROCA(310, "96", null, "OPE_REIMPRESSAO_VALE_TROCA"),
    OP_CONSULTA_GARANTIA_ESTENDIDA(311, "7C", null, "OPE_CONSULTA_GARANTIA_ESTENDIDA"),
    OP_CONSULTA_GARANTIA_ROUBO_FURTO(312, "7C", null, "OPE_CONSULTA_GARANTIA_ROUBO_FURTO"),
    OP_PAGAMENTO_GARANTIA_EXTENDIDA(313, "9C", null, "OPE_PAGAMENTO_GARANTIA_EXTENDIDA"),
    OP_PAGAMENTO_GARANTIA_ROUBO_FURTO(314, "9C", null, "OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO"),
    OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA(315, "EE", null, "OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA"),
    OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA(316, "F1", null, "OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA"),
    OP_CONSULTA_ASSOCIADO(317, "6B", null, "OPE_CONSULTA_ASSOCIADO"),
    OP_COMPRA_ASSOCIADO(318, "B1", null, "OPE_COMPRA_ASSOCIADO"),
    OP_CARGA_HABILITACAO_CARTAO_PRESENTE(319, "E8", null, "OPE_CARGA_HABILITACAO_CARTAO_PRESENTE"),
    OP_RESGATE_CARTAO_PRESENTE_SAA(320, "EA", null, "OPE_RESGATE_CARTAO_PRESENTE_SAA"),
    OP_CONSULTA_CARTAO_PRESENTE_SAA(321, "EC", null, "OPE_CONSULTA_CARTAO_PRESENTE_SAA"),
    OP_PRE_AUTORIZACAO_ADICIONAL(322, null, "01", "OP_PRE_AUTORIZACAO_ADICIONAL"),
    OP_CARGA_HABILITACAO_CUPONAGEM(323, "E8", null, "OPE_CARGA_HABILITACAO_CUPONAGEM"),
    OP_CONSULTA_CUPONAGEM(324, "EC", null, "OPE_CONSULTA_CUPONAGEM"),
    OP_RESGATE_CUPONAGEM(325, "EA", null, "OPE_RESGATE_CUPONAGEM"),
    OP_CRED_DIGITADO_PRIMEIRA_COMPRA(326, null, null, null, false),
    OP_CRED_DIGITADO_PRIMEIRA_COMPRA_PARC_S_JRS(327, null, null, null, false),
    OP_CRED_DIGITADO_PRIMEIRA_COMPRA_PARC_C_JRS(328, null, null, null, false),
    OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC(329, null, null, "OPE_CONSULTA_ESTABELECIMENTOS_MULTIEC"),
    OP_RESGATE_FACIL(330, "6T", null, "OPE_RESGATE_FACIL"),
    OP_RESGATE_FACIL_EXTRATO(331, "6U", null, "OPE_RESGATE_FACIL_EXTRATO"),
    OP_CONSULTA_FIDELIDADE_MILHAS(332, "6Y", null, "OPE_CONSULTA_FIDELIDADE_EM_MILHAS"),
    OP_RESGATE_FIDELIDADE_EM_MILHAS(999333, "6X", null, "OPE_RESGATE_FIDELIDADE_EM_MILHAS"),
    OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS(333, "6W", null, "OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS"),
    OP_RESERVA_FUEL_CONTROL(334, "6Z", null, "OPERACAO RESERVA FUEL CONTROL"),
    OP_CREDITO_4ALL(335, "4W", "01", "OPERACAO CREDITO 4ALL"),
    OP_DEBITO_4ALL(336, "4X", "02", "OPERACAO DEBITO 4ALL"),
    OP_CONSULTA_CARTAO_PREPAGO_DIGITAL(337, "GK", null, "OPERACAO CONSULTA PREPAGO DIGITAL"),
    OP_CARTAO_PREPAGO_DIGITAL(338, "GL", null, "OPERACAO PREPAGO DIGITAL"),
    OP_DEBITO_PAGAMENTO_CARNE(339, null, null, null),
    OP_DEPOSITO_COM_CARTAO(340, null, null, null),
    OP_EMPRESTIMO(341, null, null, null),
    OP_SIMULACAO_EMPRESTIMO(342, null, null, null),
    OP_PAGAMENTO_FATURA_CARTAO_CREDITO(343, "GR", "01", "OPE_CONTA_DIGITAL_PAGTO_FATURA"),
    OP_PAGAMENTO_CONTA_CONCESSIONARIA(344, "GS", "01", "OPE_CONTA_DIGITAL_PAGTO_CONCESSIONARIA"),
    OP_PAGAMENTO_CONTA_BANCARIA(345, "GT", "01", "OPE_CONTA_DIGITAL_PAGTO_TITULO"),
    OP_CONSULTA_FATURA_CARTAO_DETALHADA(348, "7J", null, "OPERACAO_CONSULTA_FATURA_CARTAO_DETALHADA"),
    OP_CONSULTA_CONTA_CREDITO(349, null, null, null),
    OP_CONSULTA_CPF_PROMOCAO_SHELL(350, null, null, null),
    OP_ATUALIZACAO_PARTICIPANTE(352, null, null, null),
    OP_RESGATE_PREMIO_SHELL(353, null, null, null),
    OP_GERACAO_BENEFICIO(351, null, null, null),
    OP_CARGA_TABELA(400, null, null, "Carga de tabelas do pinpad"),
    OP_CRED_IATA_GENERICO(401, null, null, null),
    OP_AUT_IATA_GENERICO(402, null, null, null),
    OP_PRE_AUT_CRED_GENERICO(403, null, null, null),
    OP_CONFIRMACAO_PRE_AUT_GENERICO(404, null, null, null),
    OP_CONSULTA_CDC_GENERICO(405, null, null, null),
    OP_DEB_CDC_GENERICO(406, null, null, null),
    OP_CONSULTA_PENDENCIAS(407, null, null, null),
    OP_ATIVACAO_SERVICO_SOLUCAO_CERTA(410, "GH", null, "OPE_ATIVACAO_SERVICO_SOLUCAO_CERTA"),
    OP_CANCELAMENTO_DIGITADO(411, null, null, null, false),
    OP_ALTERACAO_PRE_AUT(412, null, null, "OPERACAO ALTERACAO PRE AUTORIZACAO"),
    OP_DESBLOQUEIO_CARTAO(413, "5V", null, "OPERACAO DESBLOQUEIO CARTAO"),
    OP_ADESAO_SEGURO(414, null, null, null),
    OP_TESTE_COMUNICACAO_5N(415, null, null, "OPE_TESTE_COMUNICACAO"),
    OP_PRE_AUT_LOJISTA(416, null, null, null),
    OP_PRE_AUT_ADMINISTRADORA(417, null, null, null),
    OP_PAGAMENTO_DINHEIRO_BR_PREMMIA(418, null, null, null),
    OP_RESGATE_BR_PREMMIA(419, null, null, null),
    OP_QR_CODE_GENERICO(420, null, null, null),
    OP_CRED_CARTAO_QUALIDADE(421, null, null, "Opera\u00e7\u00e3o de Cr\u00e9dito: Cart\u00e3o Qualidade"),
    OP_PIX_PAYMENT(422, "H8", null, "PAGAMENTO PIX"),
    OP_PIX_QUERY(423, "H9", null, "CONSULTA PIX"),
    OP_CONFIGURACAO_TERMINAL(800, null, null, null),
    OP_TEF_IP_MENU_ADM(900, null, null, null),
    OP_TEF_IP_CHEQUE(901, null, null, null),
    OP_TEF_IP_VENDA_CARTAO(902, null, null, null),
    OP_TEF_IP_ENVIO_FACIL(903, null, null, null),
    OP_TEF_IP_VENDA_QR_CODE(904, null, null, null),
    OP_CAPTURA_DADO_PINPAD(908, null, null, null),
    OP_CARTAO_PREPAGO(999990, null, "01", "OPE_CARTAO_PREPAGO"),
    OP_CONSULTA_RESGATE_PREMIO(999992, "G4", null, "CONSULTA_RESGATE_PREMIO"),
    OP_TROCO_FACIL(999993, null, null, "OPERACAO TROCO FACIL"),
    OP_PAGAMENTO_CONTAS_DEBITO(999994, null, null, "OPERACAO PAGAMENTO DE CONTAS DEBITO"),
    OP_PAGAMENTO_CONTAS_DINHEIRO_CONVENIO(999995, null, null, "OPERACAO PAGAMENTO DE CONTAS DINHEIRO CONVENIO"),
    OP_PAGAMENTO_CONTAS_DINHEIRO_TITULO(999996, null, null, "OPERACAO PAGAMENTO DE CONTAS DINHEIRO TITULO"),
    OP_CONTA_DINHEIRO_CONVENIO(999997, "E7", null, "OPERACAO CONTA DINHEIRO CONVENIO"),
    OP_CONTA_DINHEIRO_TITULO(999998, "E6", null, "OPERACAO CONTA DINHEIRO TITULO"),
    OP_CREDITO_PRIMEIRA_COMPRA(999999, null, "01", "OPERACAO CREDITO PRIMEIRA COMPRA");

    private final Integer key;
    private final String keyCTF;
    private final String application;
    private final String description;
    private final boolean requiresPinpad;

    private OperationEnum(Integer key, String keyCTF, String application, String description) {
        this.key = key;
        this.keyCTF = keyCTF;
        this.application = application;
        this.description = description;
        this.requiresPinpad = true;
    }

    private OperationEnum(Integer key, String keyCTF, String application, String description, boolean requiresPinpad) {
        this.key = key;
        this.keyCTF = keyCTF;
        this.application = application;
        this.description = description;
        this.requiresPinpad = requiresPinpad;
    }

    public static boolean isRequiresPinpad(int op) throws IllegalArgumentException {
        for (OperationEnum e : OperationEnum.values()) {
            if (!e.getKey().equals(op)) continue;
            return e.requiresPinpad;
        }
        throw new IllegalArgumentException("Co\u00f3digo da opera\u00e7\u00e3o n\u00e3o encontrado (" + op + ")");
    }

    public static OperationEnum getEnumByKey(Integer key) {
        for (OperationEnum e : OperationEnum.values()) {
            if (!e.getKey().equals(key)) continue;
            return e;
        }
        return null;
    }

    public static OperationEnum getEnumByDescription(String description) {
        for (OperationEnum e : OperationEnum.values()) {
            if (null == e.getDescription() || !e.getDescription().equals(description)) continue;
            return e;
        }
        return null;
    }

    public Integer getKey() {
        return this.key;
    }

    public String getKeyCTF() {
        return this.keyCTF;
    }

    public CardApplicationTypeEnum getApplication() {
        return CardApplicationTypeEnum.getEnumByCode(this.application);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getRequiresPinpad() {
        return this.requiresPinpad;
    }
}

