/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.operation.util;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class TransactionOperationRules {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public static boolean validateQueryTransaction(int oldOperation, int newOperation) {
        OperationEnum newOperationEnum = OperationEnum.getEnumByKey(newOperation);
        if (null == newOperationEnum) {
            logger.warn("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encontrado (" + newOperation + ")");
            return false;
        }
        switch (newOperationEnum) {
            case OP_DEBITO: 
            case OP_DEB_PRE_DATADO: 
            case OP_DEB_PARCELADO_COM_PARC_AVISTA: 
            case OP_DEB_PARCELADO_SEM_PARC_AVISTA: 
            case OP_DEB_CDC_COM_PARC_AVISTA: 
            case OP_DEB_CDC_SEM_PARC_AVISTA: {
                return oldOperation == OperationEnum.OP_DEBITO.getKey();
            }
            case OP_CREDITO: 
            case OP_CRED_PARC_COM_JUROS: 
            case OP_CRED_PARC_SEM_JUROS: {
                return oldOperation == OperationEnum.OP_CREDITO.getKey() || oldOperation == OperationEnum.OP_CRED_DIGITADO.getKey() || oldOperation == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey() || oldOperation == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey() || oldOperation == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey();
            }
            case OP_CRED_DIGITADO_PARC_COM_JUROS: 
            case OP_CRED_DIGITADO_PARC_SEM_JUROS: 
            case OP_CREDITO_CELULAR_AVISTA: 
            case OP_CREDITO_CELULAR_PARC_ADMINISTRADORA: 
            case OP_CREDITO_CELULAR_PARC_LOJISTA: {
                return oldOperation == OperationEnum.OP_CREDITO.getKey() || oldOperation == OperationEnum.OP_CRED_DIGITADO.getKey();
            }
            case OP_CRED_IATA: 
            case OP_CRED_IATA_COM_JUROS: 
            case OP_CRED_IATA_SEM_JUROS: 
            case OP_CRED_DIGITADO_IATA: 
            case OP_CRED_DIGITADO_IATA_COM_JUROS: 
            case OP_CRED_DIGITADO_IATA_SEM_JUROS: {
                return oldOperation == OperationEnum.OP_CRED_IATA.getKey();
            }
            case OP_CRED_PRIVATE_LABEL: 
            case OP_CRED_PRIVATE_LABEL_DIGITADO: {
                return oldOperation == OperationEnum.OP_CRED_PRIVATE_LABEL.getKey();
            }
            case OP_CONSULTA_CDC_GENERICO: 
            case OP_CONSULTA_CDC_SEM_PARC_AVISTA: 
            case OP_CONSULTA_CDC_COM_PARC_AVISTA: {
                return oldOperation == OperationEnum.OP_CONSULTA_CDC_GENERICO.getKey();
            }
            case OP_CONSULTA_CARTAO: {
                return true;
            }
            case OP_CRED_DIGITADO: 
            case OP_CANCELAMENTO_CRED: 
            case OP_CANCELAMENTO_DEB: 
            case OP_CANCELAMENTO_GENERICO: 
            case OP_QR_CODE_GENERICO: 
            case OP_ATIVACAO_CARTAO_PREPAGO: 
            case OP_DEB_VOUCHER: 
            case OP_CONSULTA_DROGAO_COM_CARTAO: 
            case OP_CONSULTA_DROGAO_COM_CPF: 
            case OP_CONSULTA_FINANCIAMENTO_CREDITO: 
            case OP_CONSULTA_CREDITO_DIGITADO: 
            case OP_CRED_CARTAO_QUALIDADE: {
                return newOperation == oldOperation;
            }
        }
        logger.warn("N\u00e3o foi poss\u00edvel definir o grupo de " + newOperation);
        return false;
    }

    public static boolean isTypedOperation() {
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            return true;
        }
        EntradaCTFClientCtrl integrationIn = Contexto.getContexto().getEntradaIntegracao();
        if (integrationIn == null) {
            return false;
        }
        return !OperationEnum.isRequiresPinpad(integrationIn.getOperacao()) || integrationIn.isNumeroCartaoCtrl() && integrationIn.getNumeroCartao() != null;
    }
}

