/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.pinpad.service;

import br.com.auttar.pinpad.service.CryptoBlockType;
import br.com.auttar.pinpad.service.CryptoType;
import com.csi.ctfclient.excecoes.ExcecaoDadoInvalido;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.ParamAbecs;

public class GetTracksService {
    private CryptoType cryptoType;
    private CryptoBlockType cryptoBlockType;

    public ParamAbecs<char[], String> setTRACKS(String tracks) {
        return new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRACKS, tracks);
    }

    public ParamAbecs<char[], String> setMTHDDAT(String cryptoType) throws ExcecaoDadoInvalido {
        this.validateCrytoType(cryptoType);
        return new ParamAbecs<char[], String>(ConstantesAbecs.SPE_MTHDDAT, cryptoType);
    }

    public ParamAbecs<char[], byte[]> setIVCBC(byte[] initializationVector) throws ExcecaoDadoInvalido {
        if (null == this.cryptoBlockType || this.cryptoBlockType != CryptoBlockType.CBC) {
            throw new ExcecaoDadoInvalido("ERRO: SPE_IVCBC n\u00e3o pode ser definido porque o bloco de criptografia \u00e9 nulo ou inv\u00e1lido");
        }
        if (null != initializationVector && initializationVector.length != 8) {
            throw new ExcecaoDadoInvalido("ERRO: A quantidade de bytes do bloco de criptografia est\u00e1 inv\u00e1lida. Deve conter 8 bytes");
        }
        if (null == initializationVector) {
            return null;
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_IVCBC, initializationVector);
    }

    public ParamAbecs<char[], String> setOPNDIG(Integer openDigits) throws ExcecaoDadoInvalido {
        if (openDigits < 0 || openDigits > 8 && openDigits % 2 != 0) {
            throw new ExcecaoDadoInvalido("ERRO: A quantidade de d\u00edgitos informada em aberto para tag SPE_OPNDIG est\u00e1 inv\u00e1lida");
        }
        return new ParamAbecs<char[], String>(ConstantesAbecs.SPE_OPNDIG, openDigits.toString());
    }

    public ParamAbecs<char[], String> setKEYIDX(Integer keyIndex) throws ExcecaoDadoInvalido {
        if (keyIndex < 0 || keyIndex > 99) {
            throw new ExcecaoDadoInvalido("ERRO: A quantidade de d\u00edgitos informada em aberto para tag SPE_OPNDIG est\u00e1 inv\u00e1lida");
        }
        return new ParamAbecs<char[], String>(ConstantesAbecs.SPE_KEYIDX, String.format("%02d", keyIndex));
    }

    public ParamAbecs<char[], byte[]> setWKENC(byte[] workingKey) throws ExcecaoDadoInvalido {
        if (null == workingKey && CryptoType.MK_WK == this.cryptoType) {
            throw new ExcecaoDadoInvalido("ERRO: A working key \u00e9 obrigat\u00f3ria para tag SPE_WKENC quando criptografia do tipo MK_WK");
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_WKENC, workingKey);
    }

    public ParamAbecs<char[], byte[]> setPBKMOD(byte[] rsaModule) throws ExcecaoDadoInvalido {
        if (null == rsaModule && CryptoType.TDES == this.cryptoType) {
            throw new ExcecaoDadoInvalido("ERRO: M\u00f3dulo da chave p\u00fablica RSA \u00e9 obrigat\u00f3ria para tag SPE_PBKMOD, quando criptografia do tipo TDES");
        }
        if (null != rsaModule && rsaModule.length != 256) {
            throw new ExcecaoDadoInvalido("ERRO: A quantidade de bytes do m\u00f3dulo RSA est\u00e1 inv\u00e1lida. Deve conter 256 bytes");
        }
        if (null == rsaModule) {
            return null;
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_PBKMOD, rsaModule);
    }

    public ParamAbecs<char[], byte[]> setPBKEXP(byte[] rsaExponent) throws ExcecaoDadoInvalido {
        if (null == rsaExponent && CryptoType.TDES == this.cryptoType) {
            throw new ExcecaoDadoInvalido("ERRO: Expoente da chave p\u00fablica RSA \u00e9 obrigat\u00f3ria para tag SPE_PBKEXP, quando criptografia do tipo TDES");
        }
        if (null != rsaExponent && rsaExponent.length > 3) {
            throw new ExcecaoDadoInvalido("ERRO: A quantidade de bytes do expoente RSA est\u00e1 inv\u00e1lida. Deve conter no m\u00e1ximo 3 bytes");
        }
        if (null == rsaExponent) {
            return null;
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_PBKEXP, rsaExponent);
    }

    private void validateCrytoType(String cryptoType) throws ExcecaoDadoInvalido {
        if (cryptoType.length() != 2) {
            throw new ExcecaoDadoInvalido("ERRO: Tamnho do SPE_MTHDDAT informado diferente de 2");
        }
        this.cryptoType = CryptoType.toEnum(cryptoType.substring(0, 1));
        this.cryptoBlockType = CryptoBlockType.toEnum(cryptoType.substring(1));
        if (null == this.cryptoType) {
            throw new ExcecaoDadoInvalido("ERRO: Tipo de criptografia informado em SPE_MTHDDAT inexistente");
        }
        if (null == this.cryptoBlockType) {
            throw new ExcecaoDadoInvalido("ERRO: Bloco de criptografia informado em SPE_MTHDDAT inexistente");
        }
    }
}

