/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.apitef;

import br.com.auttar.util.exceptions.InvalidCtfDataException;
import com.csi.ctfclient.apitef.SaidaApiTefC;

public class ParcelUtils {
    private static void validateMininumMaximumParcels(SaidaApiTefC saidaApiTefC) throws InvalidCtfDataException {
        String minimumMaximumParcels = saidaApiTefC.getMinMaxParcelas();
        if (minimumMaximumParcels == null) {
            throw new InvalidCtfDataException("PU01", "SC0499 nulo", "");
        }
        if (minimumMaximumParcels.length() != 4) {
            throw new InvalidCtfDataException("PU02", "SC0499 com tamanho inv\u00e1lido (deve ser 4)", "tamanho = " + minimumMaximumParcels.length());
        }
    }

    public static int getMininumParcels(SaidaApiTefC saidaApiTefC) throws InvalidCtfDataException {
        ParcelUtils.validateMininumMaximumParcels(saidaApiTefC);
        try {
            return Integer.parseInt(saidaApiTefC.getMinMaxParcelas().substring(0, 2));
        }
        catch (NumberFormatException e) {
            throw new InvalidCtfDataException("PU03", "SC0499 com formato inv\u00e1lido", "SC0499 = " + saidaApiTefC.getMinMaxParcelas() + ", e = " + e.getMessage());
        }
    }

    public static int getMaximumParcels(SaidaApiTefC saidaApiTefC) throws InvalidCtfDataException {
        ParcelUtils.validateMininumMaximumParcels(saidaApiTefC);
        try {
            return Integer.parseInt(saidaApiTefC.getMinMaxParcelas().substring(2));
        }
        catch (NumberFormatException e) {
            throw new InvalidCtfDataException("PU03", "SC0499 com formato inv\u00e1lido", "SC0499 = " + saidaApiTefC.getMinMaxParcelas() + ", e = " + e.getMessage());
        }
    }
}

