/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.emv;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.AmountType;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class PinpadPasswordMessageFormatter {
    private static final String CTF_AMOUNT_TOKEN = "%valor%";
    private static final int PINPAD_DISPLAY_LENGTH = 16;
    private static final char PINPAD_DISPLAY_FILLER = ' ';
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PinpadPasswordMessageFormatter.class);

    public String passwordMessage(BigDecimal amount, String ctfMessage, AmountType amountType) {
        String strAmount = this.formatAmount(amount, amountType, ctfMessage == null);
        logger.debug("String do valor = " + strAmount);
        if (ctfMessage != null) {
            logger.info("CTF enviou 0248, aplicando formata\u00e7\u00e3o no display da GoOnChip");
            logger.debug("0248 = " + ctfMessage);
            if (strAmount != null && amount.compareTo(new BigDecimal(0)) > 0) {
                logger.debug("Transa\u00e7\u00e3o possui valor, aplicando formata\u00e7\u00e3o em 0248");
                String formattedCtfMessage = this.formatCTFMessage(ctfMessage, strAmount);
                logger.debug("Subcampo 0248 formatado = " + formattedCtfMessage);
                return formattedCtfMessage;
            }
            logger.debug("Transa\u00e7\u00e3o n\u00e3o possui valor, usando o subcampo 0248 para a mensagem do pinpad");
            return ctfMessage;
        }
        logger.info("Aplicando formata\u00e7\u00e3o manual no display da captura da senha");
        String valueMessage = "";
        if (strAmount != null) {
            if (strAmount.length() == 16) {
                logger.debug("Valor possui 16 posi\u00e7\u00f5es, ocultando r\u00f3tulos");
                valueMessage = strAmount;
            } else {
                logger.debug("Tipo do valor = " + (Object)((Object)amountType));
                valueMessage = amountType.equals((Object)AmountType.FINANCIAL) ? "Valor" + strAmount : "Pontos" + strAmount;
            }
        }
        String fullMessage = valueMessage + "Senha:";
        logger.debug("Display final do pinpad = " + fullMessage);
        return fullMessage;
    }

    private String formatCTFMessage(String ctfMessage, String amount) {
        int tokenPosition = ctfMessage.indexOf(CTF_AMOUNT_TOKEN);
        if (tokenPosition < 0) {
            logger.warn(String.format("Token (%s) n\u00e3o encontrado no display do Pinpad respondido pelo CTF. Retorno: %s", CTF_AMOUNT_TOKEN, ctfMessage));
            return ctfMessage;
        }
        if (ctfMessage.length() > 32) {
            logger.warn("Subcampo 0248 \u00e9 muito grande, ainda assim, tentando formatar");
        }
        if (tokenPosition > 16) {
            logger.warn("Token presente na segunda linha, ele ser\u00e1 colocado no final da primeira linha");
        }
        int lastTokenPosition = tokenPosition + CTF_AMOUNT_TOKEN.length();
        return this.getFirstLine(ctfMessage, amount, lastTokenPosition) + this.getSecondLine(ctfMessage, lastTokenPosition);
    }

    private String getFirstLine(String ctfMessage, String amount, int lastTokenPosition) {
        String firstLine = ctfMessage.substring(0, lastTokenPosition).replaceFirst(CTF_AMOUNT_TOKEN, "").trim();
        logger.debug("Primeira linha do display do pinpad = " + firstLine);
        if (16 < firstLine.length() + amount.length()) {
            logger.info("Label e valor n\u00e3o cabem na linha 1, usando apenas o valor");
            firstLine = StringUtil.completaString(amount, 16, ' ', 3);
        } else {
            try {
                firstLine = StringUtil.padMiddle(firstLine, amount, 16, ' ', 1);
            }
            catch (IllegalArgumentException e) {
                logger.warn("N\u00e3o foi poss\u00edvel formatar mensagem, usando apenas o valor");
                logger.warn(e.getMessage());
                firstLine = StringUtil.completaString(amount, 16, ' ', 3);
            }
        }
        return firstLine;
    }

    private String getSecondLine(String ctfMessage, int lastTokenPosition) {
        String secondLine = ctfMessage.substring(lastTokenPosition).replaceFirst(CTF_AMOUNT_TOKEN, "");
        logger.debug("Segunda linha do display do pinpad = " + secondLine);
        return secondLine;
    }

    private String formatAmount(BigDecimal amount, AmountType amountType, boolean applyPadding) {
        logger.debug(String.format("Formata\u00e7\u00e3o do valor, valor = %s; tipo de valor = %s, usar padding = %s", new Object[]{amount, amountType, applyPadding}));
        switch (amountType) {
            case FINANCIAL: {
                if (amount != null) {
                    NumberFormat formatter = this.getNumberFormatter(new Locale("pt", "BR"), 2, true);
                    String strAmount = formatter.format(amount);
                    if (applyPadding) {
                        return StringUtil.completaString(strAmount, strAmount.length() > 10 ? 16 : 11, ' ', 3);
                    }
                    return strAmount;
                }
                return null;
            }
            case POINTS: {
                String strAmount = amount.setScale(0).toString();
                return StringUtil.completaString(strAmount, strAmount.length() > 9 ? 15 : 10, ' ', 3);
            }
        }
        return null;
    }

    private NumberFormat getNumberFormatter(Locale locale, int digits, boolean group) {
        NumberFormat format = DecimalFormat.getInstance(locale);
        format.setMinimumFractionDigits(digits);
        format.setGroupingUsed(group);
        return format;
    }
}

