/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.factories;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.exceptions.PinpadOpenException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class PinpadDriverFactory {
    public static GenericPinpadController buildDriver(String port, String handler, boolean openCommunication) throws ExcecaoPerifericos {
        AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
        ProtocoloAbecs abecsInstance = new ProtocoloAbecs(port, handler);
        if (!openCommunication) {
            logger.info("Pulando validacao do driver de comunicacao com o pinpad.");
            return abecsInstance;
        }
        try {
            abecsInstance.openCommunication();
            return abecsInstance;
        }
        catch (PinpadOpenException e) {
            logger.warn("N\u00e3o foi poss\u00edvel estabelecer a comunica\u00e7\u00e3o com ABECS: " + e.getMessage());
            if (e.getOpenResult() != 3) {
                throw e;
            }
            return new ProtocoloBibliotecaCompartilhada(abecsInstance);
        }
    }
}

