/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ContingenciaConexao;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.util.Date;

public abstract class Apitef {
    public static final String ARQ_DLL_TEF = "apiwebctf";
    private static final String OPER_CONFIRMACAO = "80";
    private static final String OPER_DESFAZIMENTO = "C1";
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Apitef.class);
    private int timeOutDefault = 0;
    private boolean habilitaLog = false;
    private int diasLog = 0;
    private boolean pingUDP = false;
    private int identificacaoTransacao = 0;
    private ContingenciaConexao contingenciaConexao;
    private String versaoCielo = "";
    private String versaoEspecificacaoRedecard = "";
    private String versaoClientRedecard = "";
    private String versoesCTFClient;
    private IdentApiTefC identApiTefC;
    private EntradaApiTefC entradaApiTefC;
    private SaidaApiTefC saidaApiTefC;
    private String path;
    private String[] comunicacaoCTF;
    private String certificadoHttps;
    private String tokenTerminal;
    private int versaoPathTerminal;
    private int codigoGrupoMultiEC;
    private boolean multiEC;

    public Apitef(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        this.versoesCTFClient = versoesCTFClient;
        this.timeOutDefault = timeOutDefault;
        this.habilitaLog = habilitaLog;
        this.diasLog = diasLog;
        this.path = path;
    }

    protected abstract int getCupomTEF(IdentApiTefC var1, EntradaApiTefC var2, SaidaApiTefC var3);

    protected abstract SaidaApiTefC solicitacaoTEF(IdentApiTefC var1, EntradaApiTefC var2);

    protected abstract SaidaApiTefC confirmacaoTEF(IdentApiTefC var1, EntradaApiTefC var2);

    protected abstract SaidaApiTefC desfazimentoTEF(IdentApiTefC var1, EntradaApiTefC var2);

    protected abstract SaidaApiTefC getTransactionNumberTEF(IdentApiTefC var1, EntradaApiTefC var2);

    protected IdentApiTefC getIdentApiTefC() {
        return this.identApiTefC;
    }

    protected EntradaApiTefC getEntradaApiTefC() {
        return this.entradaApiTefC;
    }

    protected SaidaApiTefC getSaidaApiTefC() {
        return this.saidaApiTefC;
    }

    public int getTimeOutDefault() {
        return this.timeOutDefault;
    }

    protected void setTimeOutDefault(int timeOutDefault) {
        this.timeOutDefault = timeOutDefault;
    }

    public boolean isHabilitaLog() {
        return this.habilitaLog;
    }

    protected void setHabilitaLog(boolean habilitaLog) {
        this.habilitaLog = habilitaLog;
    }

    public int getDiasLog() {
        return this.diasLog;
    }

    protected void setDiasLog(int diasLog) {
        this.diasLog = diasLog;
    }

    public boolean isPingUDP() {
        return this.pingUDP;
    }

    public void setPingUDP(boolean pingUDP) {
        this.pingUDP = pingUDP;
    }

    public String getVersaoCielo() {
        return this.versaoCielo;
    }

    public void setVersaoCielo(String versaoCielo) {
        this.versaoCielo = versaoCielo;
    }

    public String getVersaoEspecificacaoRedecard() {
        return this.versaoEspecificacaoRedecard;
    }

    public void setVersaoEspecificacaoRedecard(String versaoEspecificacaoRedecard) {
        this.versaoEspecificacaoRedecard = versaoEspecificacaoRedecard;
    }

    public String getVersaoClientRedecard() {
        return this.versaoClientRedecard;
    }

    public void setVersaoClientRedecard(String versaoClientRedecard) {
        this.versaoClientRedecard = versaoClientRedecard;
    }

    public int getIdentificacaoTransacao() {
        return this.identificacaoTransacao;
    }

    public void setIdentificacaoTransacao(int origemTransacao) {
        this.identificacaoTransacao = origemTransacao;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getComunicacaoCTF() {
        return this.comunicacaoCTF;
    }

    public void setComunicacaoCTF(String[] comunicacaoCTF) {
        this.comunicacaoCTF = comunicacaoCTF;
    }

    public String getCertificadoHttps() {
        return this.certificadoHttps;
    }

    public void setCertificadoHttps(String certificadoHttps) {
        this.certificadoHttps = certificadoHttps;
    }

    public String getTokenTerminal() {
        return this.tokenTerminal;
    }

    public void setTokenTerminal(String tokenHttps) {
        this.tokenTerminal = tokenHttps;
    }

    public ContingenciaConexao getContingenciaConexao() {
        return this.contingenciaConexao;
    }

    public void setContingenciaConexao(ContingenciaConexao contingenciaConexao) {
        this.contingenciaConexao = contingenciaConexao;
    }

    public int getVersaoPathTerminal() {
        return this.versaoPathTerminal;
    }

    public void setVersaoPathTerminal(int versaoPathTerminal) {
        this.versaoPathTerminal = versaoPathTerminal;
    }

    public int getCodigoGrupoMultiEC() {
        return this.codigoGrupoMultiEC;
    }

    public void setCodigoGrupoMultiEC(int codigoGrupoMultiEC) {
        this.codigoGrupoMultiEC = codigoGrupoMultiEC;
    }

    public boolean isMultiEC() {
        return this.multiEC;
    }

    public void setMultiEC(boolean multiEC) {
        this.multiEC = multiEC;
    }

    private EntradaApiTefC prepararEntrada(IdentApiTefC identApiTefC, EntradaApiTefC entrada) {
        entrada.setTimestamp(new Date());
        if (this.versoesCTFClient != null) {
            if (this.versoesCTFClient.length() > 7) {
                entrada.setDadosCTFClient(this.versoesCTFClient.substring(0, 7));
                entrada.setDadosCTFClientDraft(this.versoesCTFClient.substring(7));
            } else {
                entrada.setDadosCTFClient(this.versoesCTFClient);
            }
        }
        entrada.setVersaoClient(this.getVersaoCielo());
        entrada.setVersaoEspecificacaoRedecard(this.getVersaoEspecificacaoRedecard());
        entrada.setVersaoClientRedecard(this.getVersaoClientRedecard());
        entrada.setFlagPingUDP(this.isPingUDP());
        if (entrada.getIdentificacaoTransacao() == -1) {
            entrada.setIdentificacaoTransacao(this.getIdentificacaoTransacao());
        }
        if (entrada.getCertificadoHttps() == null && this.getCertificadoHttps() != null) {
            entrada.setCertificadoHttps(this.getCertificadoHttps());
        }
        if ((entrada.getComunicacaoCTF() == null || entrada.getComunicacaoCTF().length == 0) && this.getComunicacaoCTF() != null) {
            entrada.setComunicacaoCTF(this.getComunicacaoCTF());
        }
        if (entrada.getTokenTerminal() == null && this.getTokenTerminal() != null) {
            entrada.setTokenTerminal(this.getTokenTerminal());
        }
        if (entrada.getCodigoGrupoMultiEC() == -1 && this.getCodigoGrupoMultiEC() > 0) {
            entrada.setMultiEC(this.isMultiEC());
            entrada.setCodigoGrupoMultiEC(this.getCodigoGrupoMultiEC());
        }
        if (entrada.getTimeoutCtf() == 0) {
            int timeout = 30;
            if (this.getTimeOutDefault() > 0) {
                entrada.setTimeoutCtf(this.getTimeOutDefault());
                this.logger.warn("CTFClient - utilizando timeout default = " + this.getTimeOutDefault());
            } else {
                this.logger.warn("CTFClient - utilizando timeout for\u00e7ado = " + timeout);
                entrada.setTimeoutCtf(timeout);
            }
        }
        if (this.habilitaLog) {
            entrada.setFlagTrace(true);
            entrada.setQtdDiasTrace(this.diasLog);
        }
        if (this.getContingenciaConexao() != null) {
            identApiTefC.setContingenciaConexao(this.getContingenciaConexao());
        }
        if (this.getVersaoPathTerminal() > 0) {
            entrada.setVersaoPathTerminal(this.getVersaoPathTerminal());
        }
        return entrada;
    }

    public SaidaApiTefC solicitacao(IdentApiTefC ident, EntradaApiTefC entrada) {
        if ((entrada = this.prepararEntrada(ident, entrada)).getIndiceMasterKey() == '*') {
            entrada.setTamanhoSenha("08");
        } else if (entrada.getIndiceMasterKey() == '0') {
            entrada.setTamanhoSenha("00");
        } else {
            entrada.setTamanhoSenha("#8");
        }
        String messageLog = entrada.getOperacao().equals("1F") ? entrada.getOperacao() + " (" + entrada.getOperacaoConsultada() + ")" : entrada.getOperacao();
        messageLog = messageLog + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        this.logger.info("solicita opera\u00e7\u00e3o " + messageLog);
        this.identApiTefC = ident;
        this.entradaApiTefC = entrada;
        SaidaApiTefC saidaApiTefC = this.solicitacaoTEF(ident, entrada);
        if (saidaApiTefC.getFlagBaixaTecnica() == '0') {
            this.entradaApiTefC.setFlagBaixaTecnicaVisanet('0');
        }
        this.saidaApiTefC = saidaApiTefC;
        try {
            StringBuffer sbDisplay = new StringBuffer();
            for (int i = 0; i < saidaApiTefC.getDisplayCTF().length; ++i) {
                sbDisplay.append(" " + saidaApiTefC.getDisplayCTF()[i]);
            }
            this.logger.info("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro() + " nsu_ctf=" + saidaApiTefC.getNsuCTF() + " cod_van=" + (saidaApiTefC.getCodigoVanAlfa() != null ? saidaApiTefC.getCodigoVanAlfa() : Byte.valueOf(saidaApiTefC.getCodigoVan())) + " cod_aut=" + saidaApiTefC.getCodigoAutorizadora() + " display_ctf=" + sbDisplay.toString());
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        return saidaApiTefC;
    }

    public SaidaApiTefC confirmacao(IdentApiTefC ident, EntradaApiTefC entrada) {
        SaidaApiTefC saidaApiTefC;
        if ((entrada = this.prepararEntrada(ident, entrada)).getOperacao() == null || entrada.getOperacao().trim().length() == 0) {
            entrada.setOperacao(OPER_CONFIRMACAO);
        }
        String messageLog = entrada.getOperacao() + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        this.logger.info("solicita opera\u00e7\u00e3o " + messageLog);
        this.identApiTefC = ident;
        this.entradaApiTefC = entrada;
        this.saidaApiTefC = saidaApiTefC = this.confirmacaoTEF(ident, entrada);
        this.logger.info("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro());
        return saidaApiTefC;
    }

    public SaidaApiTefC desfazimento(IdentApiTefC ident, EntradaApiTefC entrada) {
        SaidaApiTefC saidaApiTefC;
        entrada = this.prepararEntrada(ident, entrada);
        entrada.setOperacao(OPER_DESFAZIMENTO);
        String messageLog = entrada.getOperacao() + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        this.logger.info("solicita opera\u00e7\u00e3o " + messageLog);
        this.identApiTefC = ident;
        this.entradaApiTefC = entrada;
        this.saidaApiTefC = saidaApiTefC = this.desfazimentoTEF(ident, entrada);
        this.logger.info("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro());
        return saidaApiTefC;
    }

    public SaidaApiTefC getTransactionNumber(IdentApiTefC terminalId, EntradaApiTefC ctfIn) {
        SaidaApiTefC saidaApiTefC;
        String messageLog = "terminal=" + terminalId.getNumeroEstabelecimento() + terminalId.getNumeroLoja() + "." + terminalId.getNumeroPdv();
        this.logger.info("solicita n\u00famero da \u00faltima transa\u00e7\u00e3o " + messageLog);
        this.identApiTefC = terminalId;
        this.saidaApiTefC = saidaApiTefC = this.getTransactionNumberTEF(terminalId, ctfIn);
        this.logger.info("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro());
        return saidaApiTefC;
    }

    public int getCupom() {
        return this.getCupomTEF(this.identApiTefC, this.entradaApiTefC, this.saidaApiTefC);
    }

    public abstract void insereSubcampoSaida(int var1, String var2);
}

